AC_DEFUN([AC_PROG_PS],[
 AC_CHECK_PROGS(ps,[ps],no)
 if test $ps = "no" ; then
    AC_MSG_ERROR([Unable to find the ps application]);
 else
    AC_MSG_CHECKING([for ps capabilities])
    echo

    result=`ps -o rss  2>/dev/null`;
    
    if test x"${result}" = x; then
	AC_MSG_RESULT([no -o rss option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_UNIX_O_RSS], [1], [Define ps -o rss is valid])
	AC_MSG_RESULT([-o rss option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_UNIX_O_RSS], [test x"_OPTION_FOUND" = x"yes"])

    result=`ps -jH  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no -jH option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_UNIX_JH], [1], [Define ps -jH is valid])
	AC_MSG_RESULT([-jH option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_UNIX_JH], [test x"_OPTION_FOUND" = x"yes"])

    result=`ps -ly  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no -ly option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_UNIX_LY], [1], [Define ps -ly is valid])
	AC_MSG_RESULT([-ly option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_UNIX_LY], [test x"OPTION_FOUND" = x"yes"])

    result=`ps -ef  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no -ef option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_UNIX_EF], [1], [Define ps -ef is valid])
	AC_MSG_RESULT([-ef option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_UNIX_EF], [test x"OPTION_FOUND" = x"yes"])

    result=`ps -o pcpu 2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no -o option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_UNIX_O], [1], [Define ps -ef is valid])
	AC_MSG_RESULT([-o option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_UNIX_O], [test x"OPTION_FOUND" = x"yes"])

    result=`ps -w  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no -w option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_UNIX_W], [1], [Define ps -ef is valid])
	AC_MSG_RESULT([-w option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_UNIX_W], [test x"OPTION_FOUND" = x"yes"])

    result=`ps xf  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no xf option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_BSD_XF], [1], [Define ps xf is valid])
	AC_MSG_RESULT([xf option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_BSD_XF], [test x"OPTION_FOUND" = x"yes"])

    result=`ps l  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no l option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_BSD_L], [1], [Define ps ux is valid])
	AC_MSG_RESULT([l option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_BSD_L], [test x"OPTION_FOUND" = x"yes"])

    result=`ps aux  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no aux option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_BSD_AUX], [1], [Define ps aux is valid])
	AC_MSG_RESULT([aux option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_BSD_AUX], [test x"OPTION_FOUND" = x"yes"])
    
    result=`ps o pcpu  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no o option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_BSD_O], [1], [Define ps aux is valid])
	AC_MSG_RESULT([o option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_BSD_O], [test x"OPTION_FOUND" = x"yes"])
    
    result=`ps w  2>/dev/null`;
    if test x"${result}" = x; then
	AC_MSG_RESULT([no w option found])
	OPTION_FOUND=no
    else 
	AC_DEFINE([HAVE_BSD_W], [1], [Define ps aux is valid])
	AC_MSG_RESULT([w option found])
	OPTION_FOUND=yes
    fi
    AM_CONDITIONAL([HAVE_BSD_W], [test x"OPTION_FOUND" = x"yes"])

 fi
])
