#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

///////////////////////////////////////////////////////////////////////////
//   pango layout stuff
//////////////////////////////////////////////////////////////////////////

static void
layout_set_monospace(PangoLayout *layout){
    if (!layout) return;
    static PangoFontDescription *monospace_desc = NULL;
    static gint fontsize = 0;
    static gchar *fontfamily=NULL;
    gint newsize = 8;
    const gchar *p = getenv ("RFM_FIXED_FONT_SIZE");
    if(p && strlen (p)) {
	errno=0;
	long value = strtol(p, NULL, 0);
	if (errno == 0){
	    newsize = value;
	}
    }
    p = getenv ("RFM_FIXED_FONT_FAMILY");

    if (fontsize != newsize || !fontfamily || strcmp(fontfamily, p)) {
	if (!fontfamily || strcmp(fontfamily, p)){
	    g_free(fontfamily);
	    if (p) fontfamily = g_strdup(p);
	    else p = g_strdup("monospace");
	}
	fontsize = newsize;
	PangoFontDescription *font_desc = pango_font_description_new ();
	pango_font_description_set_family (font_desc, fontfamily);
	pango_font_description_set_size (font_desc, fontsize * PANGO_SCALE);
	if (monospace_desc) pango_font_description_free (monospace_desc); 
	monospace_desc = font_desc;
    }

    pango_layout_set_font_description(layout, monospace_desc); 
}

static void
layout_set_variable_font(PangoLayout *layout){
    if (!layout) return;
    static PangoFontDescription *variable_desc = NULL;
    static gint fontsize = 0;
    static gchar *fontfamily=NULL;
    gint newsize = 8;
    const gchar *p = getenv ("RFM_VARIABLE_FONT_SIZE");
    if(p && strlen (p)) {
	errno=0;
	long value = strtol(p, NULL, 0);
	if (errno == 0){
	    newsize = value;
	}
    }
    p = getenv ("RFM_VARIABLE_FONT_FAMILY");

    if (fontsize != newsize || !fontfamily || strcmp(fontfamily, p)) {
	if (!fontfamily || strcmp(fontfamily, p)){
	    g_free(fontfamily);
	    if (p) fontfamily = g_strdup(p);
	    else p = g_strdup("sans");
	}
	fontsize = newsize;
	PangoFontDescription *font_desc = pango_font_description_new ();
	pango_font_description_set_family (font_desc, fontfamily);
	pango_font_description_set_size (font_desc, fontsize * PANGO_SCALE);
	if (variable_desc) pango_font_description_free (variable_desc); 
	variable_desc = font_desc;
    }
    pango_layout_set_font_description(layout, variable_desc); 
}

#if 0
static void
layout_set_monospace(PangoLayout *layout){
    static PangoFontDescription *monospace_desc = NULL;
    static gint fontsize = 0;
    gint newsize = 8;
    const gchar *p = getenv ("RFM_FIXED_FONT_SIZE");
    if(p && strlen (p)) {
	errno=0;
	long value = strtol(p, NULL, 0);
	if (errno == 0){
	    newsize = value;
	}
    }
    if (fontsize != newsize) {
	fontsize = newsize;
	PangoFontDescription *font_desc = pango_font_description_new ();
	pango_font_description_set_family (font_desc, "monospace");
	pango_font_description_set_size (font_desc, fontsize * PANGO_SCALE);
	if (monospace_desc) pango_font_description_free (monospace_desc); 
	monospace_desc = font_desc;
    }

    pango_layout_set_font_description(layout, monospace_desc); 
}
#endif


static void
make_layout2(view_t * view_p, population_t *population_p){
    if (!view_p || !population_p || !population_p->en) return;
    record_entry_t *en=population_p->en;
// taxing:    if (!en->path || !en->st || !rfm_g_file_test(en->path, G_FILE_TEST_EXISTS)){
    if (!en->path || !en->st ){
	return;
    }
    // Use layout2 for file details (if applicable)
    // This function is used by monitor for updates on stat changes.
    gchar *mode_string=rfm_mode_string (en->st->st_mode);
    gchar *grupo=rfm_group_string(en->st);
    gchar *owner=rfm_user_string(en->st);
    gchar *date_string=rfm_date_string (en->st->st_mtime);

    gchar *layout2_text=g_strdup_printf("   <span><i>%s %8s:%-8s %12llu %s</i></span>", 
	    mode_string,
	    owner, grupo,
	    (long long unsigned)en->st->st_size,
	    date_string);
    g_free(mode_string);
    g_free(grupo);
    g_free(owner);
    g_free(date_string);
    population_p->layout2 = 
	gtk_widget_create_pango_layout (view_p->widgets.paper, NULL);
    pango_layout_set_markup(population_p->layout2, layout2_text, -1);
    g_free(layout2_text);
#if 0
    if (rfm_layout_is_details_size(view_p)){
	layout_set_monospace(population_p->layout2);
    } else {
	layout_set_variable_font(population_p->layout2);
    }
#endif	
}

static void
mk_logical_rect (PangoLayout * layout, PangoRectangle * logical_rect) {
    NOOP (">> mk_logical_rect\n");
    if(layout) {
        pango_layout_get_pixel_extents (layout, NULL, logical_rect);
        /* ++ because zero is actually unity, not nonexistance */
        logical_rect->width++;
        logical_rect->height++;
    }
}
    

void
rfm_layout_cleanup(population_t *population_p){
    if(population_p->layout){
        g_object_unref (population_p->layout);
	}
    if(population_p->layout2 ){
        g_object_unref (population_p->layout2);
	}
    if(population_p->layout_full){
        g_object_unref (population_p->layout_full);
	}
    population_p->layout = population_p->layout2 =
	population_p->layout_full = NULL;
}

static void
mk_layouts (view_t * view_p, const gchar * tag, 
		PangoLayout ** layout, 
		PangoLayout ** layout2,
		PangoLayout ** layout_full) {
    NOOP (">> rfm_mk_layouts\n");
    int i;
    gchar *optimal_chars = " .-_";
    static gchar *optimal_set[4] = { NULL, NULL, NULL, NULL };
    PangoRectangle logical_rect;
    gchar *tag_copy = NULL,
        *the_tag = NULL;

    //if (!population_p) return;
    if(!layout || !layout2 || !layout_full){
		DBG("mk_layouts(): one of the layout pointers is null\n");
        return;
	}

    if(!tag || !strlen (tag)){
		NOOP("mk_layouts(): tag is null or empty!\n");
        return;
    }

    // Easy part: full layout.
    *layout_full = gtk_widget_create_pango_layout (view_p->widgets.paper, tag);
    layout_set_variable_font(*layout_full);

#if 0
    // not used anymore...
    if (view_p->module){
	gchar *module_tag = rfm_rational(PLUGIN_DIR, view_p->module, view_p, (void *)tag,
		"make_list_layout1");
	if (module_tag){
	    *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, module_tag);
	    layout_set_variable_font(*layout);
	    g_free(module_tag);
	    return;
	}
    }
#endif
 
    if(!optimal_set[0]) {
        for(i = 0; i < strlen (optimal_chars); i++) {
            gchar c[2] = { 0, 0 };
            c[0] = optimal_chars[i];
            optimal_set[i] = rfm_utf_string (c);
        }
    }

    /* new method... */
    /* get width of string
     * string MUST be a validated utf string here. */
    the_tag = g_strdup (tag);
    *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, the_tag);

    layout_set_variable_font(*layout);

    pango_layout_get_pixel_extents (*layout, NULL, &(logical_rect));
    gint max_width=CELLWIDTH(view_p) - 2 * TEXTSPACING;
    gint icon_size = ICON_SIZE(view_p);
    if (icon_size == TINY_ICON_SIZE) max_width -= TINY_ICON_SIZE;

    if(rfm_layout_is_details_size(view_p) ||
        logical_rect.width + 1 <= max_width) 
    {
        /* if it fits, or < TINY_ICON_SIZE, were all done */
        NOOP (stderr, "no cut necessary for %s\n", tag);
        g_free (the_tag);
        return;
    }
    /* shucks, it doesn't fit. Let's work with a copy of the tag */
    NOOP (stderr, "shucks, it doesn't fit: %d > %d\n", logical_rect.width + 1, max_width);
    tag_copy = g_strdup (the_tag);
    while(strlen (tag_copy) > 1 && logical_rect.width + 1 > max_width) {
        gchar *rear;
        int length = strlen (tag_copy);
        gchar *p = tag_copy + length - 1;
        rear = g_utf8_find_prev_char (tag_copy, p);
        length = strlen (rear);
        memset (rear, 0, length);
        g_object_unref (*layout);
        *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, tag_copy);
	layout_set_variable_font(*layout);
        pango_layout_get_pixel_extents (*layout, NULL, &(logical_rect));
    }
    if (icon_size >= TINY_ICON_SIZE && icon_size < SMALL_ICON_SIZE){
	// this is compact view, so we don't care about layout2
        g_object_unref (*layout);
	gchar *compact_tag=g_strdup_printf("%s...", tag_copy);
        *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, compact_tag);
	layout_set_variable_font(*layout);
        pango_layout_get_pixel_extents (*layout, NULL, &(logical_rect));
	g_free (compact_tag);
	g_free (the_tag);
	g_free (tag_copy);
        return;
    }
    NOOP (stderr, "\"%s\" cut to \"%s\"\n", the_tag, tag_copy);
    /* Now the first part fits, but the split may not be optimum
     * we must now look for one in " .-_" to do the split, but the
     * character search must be done in utf */
    /* is the cut optimal? */
    {
        int cut_location = strlen (tag_copy);
        //gchar *optimal_ch;
        gchar *p = the_tag + (cut_location - 1);
        gchar *optimal_cut_p = NULL;
    NOOP (stderr, "1. p == \"%s\"\n", p);
        p = g_utf8_find_prev_char (the_tag, p); /* previous validated location */
    NOOP (stderr, "2. p == \"%s\"\n", p);
        p = g_utf8_find_next_char (p, NULL);    /* validated location */
    NOOP (stderr, "3. p == \"%s\"\n", p);

        for(i = 0; i < strlen (optimal_chars); i++) {
            if(strncmp (p, optimal_set[i], strlen (optimal_set[i])) == 0) {
                //optimal_ch = optimal_set[i];
                optimal_cut_p = p;
                NOOP ("optimal cut found for %s\n", tag);
                break;
            }
        }
        if(optimal_cut_p)
            goto go_on;

        for(i = 0; i < strlen (optimal_chars); i++) {
            gchar *g = g_utf8_strrchr (tag_copy, -1, g_utf8_get_char (optimal_set[i]));

            if(g) {
                int diff = strlen (tag_copy) - strlen (g);
                g = the_tag + diff + 1;
                *layout2 = gtk_widget_create_pango_layout (view_p->widgets.paper, g);
		layout_set_variable_font(*layout2);
                pango_layout_get_pixel_extents (*layout2, NULL, &(logical_rect));
                if(logical_rect.width + 1 <= max_width) {
                    NOOP ("might improve cut for %s\n", tag);
                    g_object_unref (*layout);
                    memset (tag_copy + diff + 1, 0, strlen (tag_copy + diff + 1));
                    *layout = gtk_widget_create_pango_layout (view_p->widgets.paper, tag_copy);
		    layout_set_variable_font(*layout);

                    goto done;
                } else {
                    NOOP ("NOT improveable: %s (could look for another cut char)\n", tag);
                    g_object_unref (*layout2);
                }
                break;
            }
        }
    }

    /* So we don't have an optimal split. Let's construct the rest. */
  go_on:
    if(strlen (tag_copy) && strlen (the_tag) > strlen (tag_copy)) {
        gchar *p = the_tag + (strlen (tag_copy));
        /* XXX should do this for all spaces, not just the first  */
        if(strncmp (p, optimal_set[0], strlen (optimal_set[0])) == 0)
            p = g_utf8_find_next_char (p, NULL);

        *layout2 = gtk_widget_create_pango_layout (view_p->widgets.paper, p);
	layout_set_variable_font(*layout2);
        /* final question, does it fit? */
        pango_layout_get_pixel_extents (*layout2, NULL, &(logical_rect));
        while(logical_rect.width + 1 > max_width) {
            gchar *g;
            NOOP ("second line does not fit (%s)\n", p);
            g_object_unref (*layout2);
            p = g_utf8_find_next_char (p, NULL);
            g = g_strconcat ("~", p, NULL);
            *layout2 = gtk_widget_create_pango_layout (view_p->widgets.paper, g);
	    layout_set_variable_font(*layout2);
            pango_layout_get_pixel_extents (*layout2, NULL, &(logical_rect));
            g_free (g);
        }

    }
    /* finally we free our copies of the tag */
  done:
    g_free (tag_copy);
    g_free (the_tag);
    return;
}

void
rfm_do_layout (view_t * view_p, population_t * population_p) {
    //return;
    NOOP (">> layout\n");
    if(!view_p || !population_p) {
        DBG ("!view_p || !population_p\n");
        return;
    }
    const gchar * label = population_p->label;
    gchar *actual_tag = rfm_utf_string (label);
    rfm_layout_cleanup(population_p);
    mk_layouts (view_p, actual_tag, 
			&(population_p->layout), 
			&(population_p->layout2),
			&(population_p->layout_full));
    g_free (actual_tag);


    // Layout2 is not used when iconsize >= TINY_ICON_SIZE && iconsize < SMALL_ICON_SIZE
    // Layout2 is used for ls -l info when iconsize < TINY_ICON_SIZE
    if (rfm_layout_is_details_size(view_p)){
	if (population_p->layout2) g_object_unref(population_p->layout2);
	population_p->layout2 = NULL;
	if (view_p->en && view_p->module == NULL) {
	    make_layout2(view_p, population_p);
	} else {
	    rfm_rational(PLUGIN_DIR, POPULATION_MODULE(population_p), 
			view_p, population_p, "make_list_layout2");
	}
	layout_set_monospace(population_p->layout);
	layout_set_monospace(population_p->layout2);
	layout_set_monospace(population_p->layout_full);
    } else {
	layout_set_variable_font(population_p->layout2);
    }
    mk_logical_rect (population_p->layout, &(population_p->logical_rect));
    mk_logical_rect (population_p->layout2, &(population_p->logical_rect2));
    mk_logical_rect (population_p->layout_full, &(population_p->logical_rect_full));
    return;
}

/////////////////////////////////////////////////////////////////////////


