#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
////////////////////////////////////////////////////////////////////////////////////////
//             rodent_create_popup_bythread guts (threaded functions) 
////////////////////////////////////////////////////////////////////////////////////////

static gchar *auto_C_name[] = {AUTO_C_NAME};
static GtkWidget *
thread_add_menu_separator (GtkWidget * parent, const gchar *text);
static GtkWidget *
thread_add_submenu (GtkWidget * parent, const gchar * label, const gchar * name, const gchar * iconfile);
static GtkWidget *
thread_mk_pixmap_menu (GtkWidget * parent, const gchar * icon_id, int caso);
static void
thread_multimenu_make(GtkAccelGroup * accel_group, RodentMenuDefinition *in_p);

static GMutex	*popup_mutex=NULL;
static GCond	*popup_ready=NULL;
// This is to keep main loop running while waiting for popup
static RfmRecMutex popup_create_mutex;

static gboolean
mutex_controller(void){
    if (!popup_mutex || !popup_ready){
	g_error("rodent_popup_control has not been invoked\n");
    }
    rfm_global_t *rfm_global_p = rfm_global();
    while (!rfm_global_p->window) rfm_threadwait();
    if (!rfm_get_widget(MAIN_POPUP_MENU_ID)){
	g_mutex_lock(popup_mutex);
	g_cond_wait(popup_ready, popup_mutex);
	g_mutex_unlock(popup_mutex);
    }
    return TRUE;

}

static gboolean
popup_controller(void){
    return mutex_controller();
}
    

static gboolean 
menu_item_button_press (GtkWidget *widget, GdkEvent  *event, gpointer data) {
    NOOP(stderr, "***** popup menu item %s button press\n", (gchar *)data);
    return FALSE;
}

static
void unmap (GtkWidget *widget, gpointer data){
    NOOP(stderr,  "****  popup menu unmap signal-----\n");
    rfm_global_t *rfm_global_p = rfm_global();
    g_object_set_data(G_OBJECT(rfm_global_p->window), "popup_mapped", NULL);
    // Since this is main thread business, a read lock request
    // will have deadlock potential.
    //widgets_t *widgets_p = rfm_get_widget("widgets_p");
    //view_t *view_p = widgets_p->view_p;
    //rfm_rw_lock_reader_unlock (&(view_p->mutexes.monitor_lock));

    return ;
}

static
void map (GtkWidget *widget, gpointer data){
    NOOP(stderr,  "****  popup menu map signal+++++\n");
    rfm_global_t *rfm_global_p = rfm_global();
    g_object_set_data(G_OBJECT(rfm_global_p->window), "popup_mapped", GINT_TO_POINTER(1));
    // Since this is main thread business, a read lock request
    // will have deadlock potential.
    //widgets_t *widgets_p = rfm_get_widget("widgets_p");
    //view_t *view_p = widgets_p->view_p;
    //rfm_rw_lock_reader_lock (&(view_p->mutexes.monitor_lock));
    return ;
}

#if 10
static
gboolean set_default_app (GtkWidget      *widget,
	                   GdkEventButton *event,
                           gpointer        data){
    if (event->state & GDK_CONTROL_MASK){
	g_object_set_data(G_OBJECT(widget), "CTL_SET", GINT_TO_POINTER(1));
    } else {
	g_object_set_data(G_OBJECT(widget), "CTL_SET", NULL);
    }
    return FALSE;
}
#endif

static void *
thread_add_menu_item_f (gpointer data) {
    void **arg = data;
    GtkWidget * parent = arg[0];
    const gchar * label = (const gchar *)arg[1];
    const gchar * name = (const gchar *)arg[2];
    const gchar * icon_id = (const gchar *)arg[3];
    gpointer callback = arg[4];
    gpointer callback_data = arg[5];
    GtkWidget *w = rfm_menu_item_new(icon_id, label);
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent), w);
    if (name) rfm_set_widget (w, name);

    // This is only for autotypeC items... 
    // AutotypeC item content is determined at run
    // time and specific to mimetype.
        
    gboolean do_tooltip = FALSE;
    gint i; for(i = 0; auto_C_name[i]; i++) {
	if (name && strcmp(auto_C_name[i], name)==0){
	    do_tooltip = TRUE;
	    break;
	}
    }
    if (do_tooltip) {
	gchar *tooltip_text=g_strdup_printf("Ctrl+%s\n<b>%s: %s</b>",
			_("click"),_("Assign"), _("Associated command"));
	rfm_add_custom_tooltip(w, NULL, tooltip_text);
	g_free(tooltip_text);
	g_signal_connect((gpointer) w, "button-press-event", 
		G_CALLBACK (set_default_app), NULL);
	
    }
    
    if(callback){
        g_signal_connect ((gpointer) w, "activate", G_CALLBACK (callback), callback_data);
    }
    return w;

}

static GtkWidget *
thread_add_menu_item (GtkWidget * parent,
                   const gchar * name,
                   const gchar * label,
                   const gchar * icon_id,
                   gpointer callback, 
		   gpointer callback_data) {
    void *arg[6];
    arg[0] = parent;
    arg[1] = (void *)label;
    arg[2] = (void *)name;
    arg[3] = (void *)icon_id;
    arg[4] = callback;
    arg[5] = callback_data;
    GtkWidget *w = rfm_context_function(thread_add_menu_item_f, arg);
    return w;
}


static void *
thread_mk_radio_button_f (gpointer data)
{
    void **arg = data;
    GtkWidget * parent = arg[0];
    GSList ** radiogroup = arg[1]; 
    const gchar * label = (const gchar *)arg[2];
    const gchar * name = (const gchar *)arg[3];
    gpointer callback = arg[4];
    gpointer callback_data = arg[5];
    GtkWidget *w = rfm_create_radiomenuitem (label, *radiogroup);
    *radiogroup = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (w));
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent), w);
    if (callback) g_signal_connect (G_OBJECT(w) , "toggled", G_CALLBACK (callback), callback_data);
    if(name) rfm_set_widget (w, name);
    return w;
}

static GtkWidget *
thread_mk_radio_button (GtkWidget * parent,  
	GSList ** radiogroup, 
	const gchar * name, 
	const gchar * label, 
	gpointer callback, 		   
	gpointer callback_data){
    void *arg[6];
    arg[0] = parent;
    arg[1] = radiogroup;
    arg[2] = (void *)(label);
    arg[3] = (void *)(name);
    arg[4] = callback;
    arg[5] = callback_data;
    GtkWidget *w = rfm_context_function(thread_mk_radio_button_f, arg);
    return w;
}



static void *thread_mk_check_item_f(gpointer data){
    void **arg = data;
    GtkWidget * parent = arg[0];
    const gchar * label = (const gchar *)arg[1];
    const gchar * name = (const gchar *)arg[2];
    const gchar * icon_id = (const gchar *)arg[3];
    gpointer callback = arg[4];
    gpointer callback_data = arg[5];

    GtkWidget *w = rfm_create_checkmenuitem (label, FALSE);
    gtk_container_add (GTK_CONTAINER (parent), w);
    if (callback) {
	g_signal_connect ((gpointer) w, "button-press-event", 
		G_CALLBACK (menu_item_button_press),(gpointer)(label));
	g_signal_connect ((gpointer) w, "toggled", 
		G_CALLBACK (callback), callback_data);
    }
    if(name) rfm_set_widget (w, name);
    return w;
}

static GtkWidget *thread_mk_check_item(GtkWidget * parent,
                   const gchar * name,
                   const gchar * label,
                   const gchar * icon_id,
                   gpointer callback, 
		   gpointer callback_data){
    void *arg[6];
    arg[0] = parent;
    arg[1] = (void *)label;
    arg[2] = (void *)name;
    arg[3] = (void *)icon_id;
    arg[4] = callback;
    arg[5] = callback_data;
    GtkWidget *w = rfm_context_function(thread_mk_check_item_f, arg);
    return w;

}


static void *
thread_add_menu_separator_f (gpointer data) {
    void **arg = data;
    GtkWidget * parent = arg[0];
    const gchar * text = (const gchar *)arg[1];
    GtkWidget *w;
    if (text) {
	w = gtk_menu_item_new_with_label (text);
    } else 
    {
	w = gtk_menu_item_new ();
    }
    gtk_widget_show (w);
    gtk_container_add (GTK_CONTAINER (parent), w);
    gtk_widget_set_sensitive (w, FALSE);
    return w;
}

static GtkWidget *
thread_add_menu_separator (GtkWidget * parent, const gchar *text) {
    void *arg[2];
    arg[0] = (void *)parent;
    arg[1] = (void *)text;
    GtkWidget *w;
    w = rfm_context_function(thread_add_menu_separator_f, arg);
    return w;
}


static void *
thread_mk_pixmap_menu_f (gpointer data) {

    void **arg = data;
    GtkWidget * parent = arg[0];
    const gchar * icon_id = (const gchar *)arg[1];
    gint caso = GPOINTER_TO_INT(arg[2]);
    GdkPixbuf *pb = arg[3];
    GtkWidget *w = NULL;
    w = gtk_image_new_from_pixbuf (pb);
    gtk_widget_show (w);

    switch (caso) {
    case BIGGER_MENU_PIXMAP:
    case MENU_PIXMAP:
	NOOP ("gtk_image_menu_item_set_image now...\n");
        rfm_set_menu_image(parent, w);
        /*
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>9
                // no replacement for gtk_image_menu_item
        //g_object_unref(w); w=NULL;
#else
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (parent), w);
#endif
*/
	break;
    case BIGGER_BUTTON_PIXMAP:
    case BUTTON_PIXMAP:
	gtk_container_add (GTK_CONTAINER (parent), w);
	break;
    }
    if (pb && G_IS_OBJECT(pb))g_object_unref(pb);
    return w;
}

static GtkWidget *
thread_mk_pixmap_menu (GtkWidget * parent, const gchar * icon_id, int caso) {
    GdkPixbuf *pb = NULL;

    NOOP (" gui_mk_pixmap_menu, icon_id: %s\n", icon_id);
    switch (caso) {
    case MENU_PIXMAP:
        pb = rfm_get_pixbuf (icon_id, SIZE_BUTTON);
        break;
    case BUTTON_PIXMAP:
        pb = rfm_get_pixbuf (icon_id, SIZE_BUTTON);
        break;
    case BIGGER_MENU_PIXMAP:
    case BIGGER_BUTTON_PIXMAP:
        pb = rfm_get_pixbuf (icon_id, SIZE_DIALOG);
        break;
    }
    if(!pb || !GDK_IS_PIXBUF(pb)) {
    /*    pb = rfm_get_pixbuf ("xffm/emote_cool", 
		(caso==BIGGER_BUTTON_PIXMAP || caso==BIGGER_MENU_PIXMAP)?
		SIZE_DIALOG:
		SIZE_BUTTON);*/
        DBG ("Unable to get pixbuf for %s (unable to get any pixbuf at all!)\n", icon_id);
        return NULL;
    }

    void *arg[4];
    arg[0] = parent;
    arg[1] = (void *)icon_id;
    arg[2] = GINT_TO_POINTER(caso);
    arg[3] = pb;
    GtkWidget *w;
    w = rfm_context_function(thread_mk_pixmap_menu_f, arg);
    return w;
}

static void *
thread_add_submenu_f (gpointer data) 
{ 

    void **arg = data;
    GtkWidget * parent = arg[0];
    const gchar * label = (const gchar *)arg[1];
    const gchar * name = (const gchar *)arg[2];
    const gchar * icon_id = (const gchar *)arg[3];
    

    GtkWidget *menu_menu = gtk_menu_new ();
    g_signal_connect (menu_menu, "unmap", G_CALLBACK (unmap), (void *)name);
    g_signal_connect (menu_menu, "map", G_CALLBACK (map), (void *)name);

    if(name) {
        gchar *g = g_strconcat (name, "_menu", NULL);
        rfm_set_widget (menu_menu, g);
	g_free(g);
	NOOP(stderr, "set widget: %s\n", g);
    }
    if (parent) {
        GtkWidget *w = rfm_menu_item_new(icon_id, label);
    
/*       
#if GTK_MAJOR_VERSION==3 && GTK_MINOR_VERSION>9
                // no replacement for gtk_image_menu_item
	GtkWidget *w = gtk_menu_item_new_with_label (label);
#else
	GtkWidget *w = gtk_image_menu_item_new_with_mnemonic (label);
	gtk_image_menu_item_set_always_show_image ((GtkImageMenuItem *) w, TRUE);
	
        GdkPixbuf *pixbuf=NULL;
	if (icon_id) {
	    pixbuf=rfm_get_pixbuf(icon_id, TINY_ICON_SIZE);
	}
	if (pixbuf) {
	    GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
	    gtk_image_menu_item_set_image((GtkImageMenuItem *)w, image);
	    g_object_unref(pixbuf);
	}
#endif
*/
	if(name) rfm_set_widget (w, name);
	gtk_widget_show_all (w);
	// add label menuitem to parent
	gtk_container_add (GTK_CONTAINER (parent), w);
	// attach submenu to label menuitem
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (w), menu_menu);
    }
   
    GtkWidget *v;
    v = gtk_menu_item_new_with_label (label);
    gtk_widget_show (v);
    gtk_container_add (GTK_CONTAINER (menu_menu), v);
    gtk_widget_set_sensitive (v, FALSE);
    GtkWidget *label_widget = gtk_bin_get_child (GTK_BIN (v));
    g_object_set_data(G_OBJECT(menu_menu), "label", label_widget);
    return menu_menu;
}

static GtkWidget *
thread_add_submenu (GtkWidget * parent, const gchar * label, const gchar * name, const gchar * icon_id) 
{ 
    void *arg[4];
    arg[0] = parent;
    arg[1] = (void *)label;
    arg[2] = (void *)name;
    arg[3] = (void *)icon_id;
    GtkWidget *w;

    w = thread_add_submenu_f( arg);
    return w;
}

static GtkWidget *
add_submenu (GtkWidget * parent, const gchar * label, const gchar * name, const gchar * icon_id) 
{ 
    void *arg[4];
    arg[0] = parent;
    arg[1] = (void *)label;
    arg[2] = (void *)name;
    arg[3] = (void *)icon_id;
    GtkWidget *w;

    w = thread_add_submenu_f( arg);
    thread_add_menu_separator (w, NULL);
    return w;
}

static void
thread_multimenu_make(GtkAccelGroup * accel_group, RodentMenuDefinition *in_p){

    RodentMenuDefinition *p = in_p;
    for (;p && p->type != NULL_TYPE; p++){
	GtkWidget *parent = rfm_get_widget(p->parent_id);
	GtkWidget *w = NULL;
	switch (p->type) {
	    case SUBMENU_TYPE:
		w = thread_add_submenu ( parent, _(p->callback.string), p->id, p->callback.icon);
		break;
	    case MENUITEM_TYPE:
		if (p->callback.function == NULL) {
		    p->callback.function = rodent_menu_callback;
		    p->callback.data = GINT_TO_POINTER(p->callback.function_id);
		}
		w = thread_add_menu_item ( parent, p->id, _(p->callback.string),  p->callback.icon, 
			p->callback.function, p->callback.data);
		break;
	    case CHECKITEM_TYPE:
		if (p->callback.function == NULL) {
		    p->callback.function = rodent_menu_callback;
		    p->callback.data = GINT_TO_POINTER(p->callback.function_id);
		}
		w = thread_mk_check_item(parent, p->id, _(p->callback.string),  
			p->callback.icon, 
			p->callback.function, p->callback.data);
		break;
	    case RADIOITEM_TYPE:;
		if (p->callback.function == NULL) {
		    p->callback.function = rodent_menu_callback;
		    p->callback.data = GINT_TO_POINTER(p->callback.function_id);
		}
		gchar *list_name = g_strconcat(p->parent_id, "_list", NULL);
		GSList **radiogroup_p = rfm_get_widget(list_name);
		g_free(list_name);
		w = thread_mk_radio_button(parent, radiogroup_p, p->id, _(p->callback.string), p->callback.function, p->callback.data);
		break;
	    case SEPARATOR_TYPE:
		w = thread_add_menu_separator (parent, _(p->callback.string));
		if(p->id) rfm_set_widget (w, p->id);
		break;
	}
    }
    return ;
}



//
static GtkWidget *
mk_popup_menu (void) 
{
    GtkAccelGroup *accel_group = NULL;
    GtkWidget *main_popup = add_submenu (NULL,  "Rodent", MAIN_POPUP_ID,  NULL);  

#if 10
    RodentMenuDefinition submenu_definitions_p[] = {MAIN_MENU_SUBMENUS};
    thread_multimenu_make(accel_group, submenu_definitions_p); 
    // Go to submenu.

    RodentMenuDefinition goto_definitions_p[] = {GOTO_MENU_STUFF};
    thread_multimenu_make(accel_group, goto_definitions_p); 

    // Bookmarks in to menu:
    gint level;
    GtkWidget *parent = rfm_get_widget("goto_menu_menu");
    // Bookmark holders
    for(level = 0; level < DEEPEST_BOOK_MENU_LEVELS; level++) {
        gchar *name = g_strdup_printf ("%s-%d", "bookmark", level);
	thread_add_menu_item ( parent, name, name, "xffm/emblem_symbolic-link", rodent_menu_callback, GINT_TO_POINTER(LEVEL_GOTO_ACTIVATE));
	g_free(name);
    }



    RodentMenuDefinition goto_definitions2_p[] = {GOTO_MENU_STUFF2};
    thread_multimenu_make(accel_group, goto_definitions2_p); 

    // Plugins
    GSList *list;
    GSList *plugin_list = rfm_find_plugins ();
    gint module_number = 0;
    for(list = plugin_list; list && list->data; list = list->next) {
        if(!rfm_is_root_plugin ((gchar *) (list->data))) {
	    NOOP(stderr, "%s is not a root module\n", 
		    (gchar *) (list->data));
	    continue;
	}
        
        if(++module_number > DEEPEST_MODULE_MENU_LEVELS)
            break;
        const gchar *name = list->data;
        const gchar *icon = rfm_get_plugin_icon (name);
        if(!icon) icon = "xffm/stock_go-forward";
	
	gchar *label = rfm_get_plugin_label(name);
        if(!label) label = g_strdup(name);
	
	GtkWidget *w =
	    thread_add_menu_item ( parent, name, label, icon, rodent_menu_callback, GINT_TO_POINTER(PLUGIN_GOTO_ACTIVATE));
	g_free(label);
	g_object_set_data(G_OBJECT(w),"module_name",g_strdup(name));

    }
 
    thread_add_menu_separator (parent, NULL);
    for(level = 0; level < DEEPEST_DIR_MENU_LEVELS; level++) {
        gchar *name = g_strdup_printf ("level-%d", level);
	thread_add_menu_item ( parent, name, name, "xffm/stock_go-last", rodent_menu_callback, GINT_TO_POINTER(LEVEL_GOTO_ACTIVATE));
	g_free(name);
    }


    // file menu
    RodentMenuDefinition file_definitions_p[] = {FILE_MENU_STUFF};
    thread_multimenu_make(accel_group, file_definitions_p); 

    // select menu
    RodentMenuDefinition select_definitions_p[] = {SELECT_MENU_STUFF};
    thread_multimenu_make(accel_group, select_definitions_p); 

    // sort menu (view menu 1)
    RodentMenuDefinition sort_definitions_p[] = {SORT_MENU_STUFF};
    {
	gchar *list_name = g_strconcat(sort_definitions_p->parent_id, "_list", NULL);
	GSList *radiogroup = NULL;
	rfm_set_widget(&radiogroup, list_name);
	g_free(list_name);
    }
    thread_multimenu_make(accel_group, sort_definitions_p); 

    // iconsize menu (view menu 2)
		
    RodentMenuDefinition zoom_definitions_p[] = {VIEW_MENU_STUFF};
    {
	gchar *list_name = g_strconcat(zoom_definitions_p->parent_id, "_list", NULL);
	GSList *radiogroup = NULL;
	rfm_set_widget(&radiogroup, list_name);
	g_free(list_name);
    }
    thread_multimenu_make(accel_group, zoom_definitions_p); 

    // help menu
    RodentMenuDefinition help_definitions_p[] = {HELP_MENU_STUFF};
    thread_multimenu_make(accel_group, help_definitions_p); 
#endif
    return main_popup;
}

