/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: m-themes.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : definition of inline themes for gui                      *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*
 */

/*
   Copyright (C) 1997-2026 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#ifdef LIBMDC_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include "m-defs.h"
#include "m-global.h"

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/
void MdcThemeSetting(int action, const char *nrstr)
{
   int nr = 0;

   if (nrstr != NULL) nr = atoi(nrstr);

   /* check for allowed types */
   if ((nr > 0) && (nr < MDC_MAX_THEMES)) XMDC_THEME_CHOICE = nr;

   /* set actions bitwise */
   XMDC_THEME_ACTION |= action;
}

/****************************************************************************
                              D E F I N E S
****************************************************************************/


const char *mdc_theme_system = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 */\n\
/*\n\
 */\n\
\n\
/* Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 */\n\
\n\
/* follow current theme; make sure textview is monospaced */\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
";

const char *mdc_theme_hundlivdusk = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 */\n\
/*\n\
 */\n\
\n\
/* Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 */\n\
\n\
\n\
/* personal hundliv theme */\n\
@define-color color_hundliv_black       #1b1d1e; /* black      */\n\
@define-color color_hundliv_white       #f8f8f2; /* white      */\n\
@define-color color_hundliv_dark_gray   #1b1d1e; /* dark  gray */\n\
@define-color color_hundliv_dim_gray    #505354; /* dim   gray */\n\
@define-color color_hundliv_light_gray  #ccccc6; /* light gray */\n\
@define-color color_hundliv_green       #82b414; /* green      */\n\
@define-color color_hundliv_orange      #fda53c; /* orange     */\n\
@define-color color_hundliv_yellow      #fee763; /* yellow     */\n\
@define-color color_hundliv_red         #d23d3d; /* red        */\n\
@define-color color_hundliv_magenta     #624d8f; /* magenta    */\n\
@define-color color_hundliv_purple      #8473a7; /* purple     */\n\
@define-color color_hundliv_blue        #4d73aa; /* blue       */\n\
@define-color color_hundliv_dim_cyan    #89b6e2; /* dim   cyan */\n\
@define-color color_hundliv_light_cyan  #46a4ff; /* light cyan */\n\
\n\
@define-color color_basic_bg @color_hundliv_dark_gray;\n\
@define-color color_basic_fg @color_hundliv_green;\n\
@define-color color_focus_bg @color_hundliv_green;\n\
@define-color color_focus_fg @color_hundliv_magenta;\n\
@define-color color_dimmed   @color_hundliv_dim_gray;\n\
@define-color color_shadow   @color_hundliv_black;\n\
@define-color color_text     @color_hundliv_dim_cyan;\n\
\n\
\n\
*:selected {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:hover {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:disabled {\n\
  color: @color_dimmed;\n\
}\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
window, dialog, menu, menubar, grid, text, entry, treeview, tab, frame, header, textview, spinbutton, slider, list {\n\
  background-color: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  /*font: 12px monospace;*/\n\
}\n\
\n\
headerbar.titlebar {\n\
  background: @color_basic_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
treeview, list, textview text {\n\
  color: @color_text;\n\
}\n\
\n\
header {\n\
  border-bottom-color: @color_basic_bg;\n\
}\n\
\n\
list {\n\
  background-color: @color_basic_bg;\n\
}\n\
\n\
scrollbar slider:hover {\n\
  background-color: @color_hundliv_light_cyan;\n\
}\n\
\n\
box {\n\
  background-color: transparent;\n\
}\n\
\n\
notebook stack {\n\
  background-color: transparent;\n\
}\n\
\n\
spinbutton:focus {\n\
  /*border-color: @color_focus_bg;*/\n\
  border-color: @color_hundliv_orange;\n\
}\n\
\n\
spinbutton selection {\n\
  /*background-color: @color_focus_bg;*/\n\
  background-color: @color_hundliv_orange;\n\
}\n\
\n\
entry:focus {\n\
  /*border-color: @color_focus_fg;*/\n\
  border-color: @color_hundliv_orange;\n\
  box-shadow: none;\n\
}\n\
\n\
entry selection {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
  box-shadow: @color_shadow;\n\
}\n\
\n\
tab:checked {\n\
  box-shadow: 0 -4px @color_hundliv_purple inset;\n\
}\n\
\n\
tab:hover {\n\
  box-shadow: 0 -4px @color_focus_fg inset;\n\
}\n\
\n\
menuitem:hover {\n\
  box-shadow: none;\n\
}\n\
\n\
radio, check {\n\
  background-image: none;\n\
  border-color: @color_dimmed;\n\
}\n\
\n\
radio:checked, check:checked {\n\
  background-image: none;\n\
  background-color: @color_hundliv_magenta;\n\
  border-color: @color_hundliv_blue;\n\
  color: @color_hundliv_light_cyan;\n\
}\n\
\n\
radio:disabled, check:disabled {\n\
  background-image: none;\n\
  background-color: @color_basic_bg;\n\
  border-color: @color_dimmed;\n\
  color: @color_dimmed;\n\
}\n\
\n\
slider {\n\
  background-image: none;\n\
  background-color: @color_hundliv_blue;\n\
  border-color: @color_hundliv_light_cyan;\n\
}\n\
\n\
slider:hover {\n\
  background-image: none;\n\
  background-color: @color_hundliv_light_cyan;\n\
  border-color: @color_hundliv_blue;\n\
}\n\
\n\
highlight {\n\
  border-color: @color_hundliv_red;\n\
  background-color: @color_hundliv_orange;\n\
}\n\
\n\
trough {\n\
  background-color: @color_dimmed;\n\
  border-color: @color_dimmed;\n\
}\n\
\n\
/*\n\
treeview box {\n\
  background-color: transparent;\n\
}\n\
\n\
list row box {\n\
  background-color: transparent;\n\
}\n\
*/\n\
\n\
button {\n\
  background-image: none;\n\
  text-shadow: none;\n\
  background: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
arrow {\n\
  background-color: transparent;\n\
}\n\
\n\
#WarningLabel {\n\
  color: @color_hundliv_orange;\n\
}\n\
/*\n\
#TextView {\n\
  font: 12px monospace;\n\
}*/\n\
";

const char *mdc_theme_speedometer = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 *\n\
 */\n\
/*\n\
 */\n\
\n\
/*\n\
 * Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 *\n\
 */\n\
\n\
/* personal speedometer theme: dark, green, yellow & red */\n\
@define-color color_spdo_dark_gray #2b2e30; /* dark gray */\n\
@define-color color_spdo_dim_gray  #919294; /* dim  gray */\n\
@define-color color_spdo_black     #000000; /* black     */\n\
@define-color color_spdo_white     #ffffff; /* white     */\n\
@define-color color_spdo_green     #00bf00; /* green     */\n\
@define-color color_spdo_yellow    #ffff00; /* yellow    */\n\
@define-color color_spdo_red       #ff0000; /* red       */\n\
\n\
@define-color color_basic_bg @color_spdo_dark_gray;\n\
@define-color color_basic_fg @color_spdo_green;\n\
@define-color color_focus_bg @color_spdo_green;\n\
@define-color color_focus_fg @color_spdo_yellow;\n\
@define-color color_dimmed   @color_spdo_dim_gray;\n\
@define-color color_shadow   @color_spdo_black;\n\
@define-color color_text     @color_spdo_white;\n\
\n\
*:selected {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:hover {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:disabled {\n\
  color: @color_dimmed;\n\
}\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
window, dialog, menu, menubar, grid, text, entry, treeview, tab, frame, header, textview, spinbutton, slider, list, popover {\n\
  background-color: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_spdo_yellow;\n\
}\n\
\n\
headerbar.titlebar {\n\
  background: @color_basic_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
treeview, list, textview text {\n\
  color: @color_text;\n\
}\n\
\n\
header {\n\
  border-bottom-color: @color_basic_bg;\n\
}\n\
\n\
list {\n\
  background-color: @color_basic_bg;\n\
}\n\
\n\
scrollbar slider:hover {\n\
  background-color: @color_focus_fg;\n\
}\n\
\n\
box {\n\
  background-color: transparent;\n\
}\n\
\n\
notebook stack {\n\
  background-color: transparent;\n\
}\n\
\n\
spinbutton:focus {\n\
  border-color: @color_focus_bg;\n\
}\n\
\n\
spinbutton selection {\n\
  background-color: @color_focus_bg;\n\
}\n\
\n\
entry:focus {\n\
  border-color: @color_focus_fg;\n\
  box-shadow: none;\n\
}\n\
\n\
entry selection {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
  box-shadow: 0 -4px @color_shadow inset;  \n\
}\n\
\n\
tab:checked {\n\
  box-shadow: 0 -4px @color_spdo_yellow inset;\n\
}\n\
\n\
tab:hover {\n\
  box-shadow: 0 -4px @color_focus_fg inset;\n\
}\n\
\n\
menuitem:hover {\n\
  box-shadow: none;\n\
}\n\
\n\
radio, check {\n\
  background-image: none;\n\
  border-color: @color_dimmed;\n\
}\n\
\n\
radio:checked, check:checked {\n\
  background-image: none;\n\
  background-color: @color_spdo_yellow;\n\
  border-color: @color_spdo_red;\n\
  color: @color_spdo_green;\n\
}\n\
\n\
radio:disabled, check:disabled {\n\
  background-image: none;\n\
  background-color: @color_basic_bg;\n\
  border-color: @color_dimmed;\n\
  color: @color_dimmed;\n\
}\n\
\n\
slider {\n\
  background-image: none;\n\
  background-color: @color_spdo_green;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
\n\
slider:hover {\n\
  background-image: none;\n\
  background-color: @color_spdo_yellow;\n\
  border-color: @color_spdo_green;\n\
}\n\
\n\
highlight {\n\
  border-color: @color_spdo_yellow;\n\
  background-color: @color_spdo_red;\n\
}\n\
\n\
trough {\n\
  background-color: @color_dimmed;\n\
  border-color: @color_dimmed;\n\
}\n\
\n\
/*\n\
treeview box {\n\
  background-color: transparent;\n\
}\n\
\n\
list row box {\n\
  background-color: transparent;\n\
}\n\
*/\n\
\n\
button {\n\
  background-image: none;\n\
  text-shadow: none;\n\
  background: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
arrow {\n\
  background-color: transparent;\n\
}\n\
\n\
#WarningLabel {\n\
  color: @color_spdo_yellow;\n\
}\n\
\n\
#TextView {\n\
  font: 12px monospace;\n\
}\n\
\n\
\n\
";

const char *mdc_theme_bluedark = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 */\n\
/*\n\
 */\n\
\n\
/* Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 */\n\
\n\
\n\
/* basic dark color scheme, white on blue hightlight */\n\
@define-color color_basic_bg #2b2e30;  /* dark gray  */\n\
@define-color color_basic_fg #f6f6fe;  /* light gray */\n\
@define-color color_focus_bg #4a79c7;  /* blue-ish   */\n\
@define-color color_focus_fg #ffffff;  /* white      */\n\
@define-color color_dimmed   #919294;  /* dim gray   */\n\
@define-color color_shadow   #000000;  /* black      */\n\
\n\
*:selected {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:hover {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:disabled {\n\
  color: @color_dimmed;\n\
}\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
window, dialog, menu, grid, text, entry, treeview, tab, frame, header, textview, spinbutton, slider, list {\n\
  background-color: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
}\n\
\n\
header {\n\
  border-bottom-color: @color_basic_bg;\n\
}\n\
\n\
list {\n\
  background-color: @color_basic_bg;\n\
}\n\
\n\
scrollbar slider:hover {\n\
  background-color: @color_focus_fg;\n\
}\n\
\n\
box {\n\
  background-color: transparent;\n\
}\n\
\n\
notebook stack {\n\
  background-color: transparent;\n\
}\n\
\n\
spinbutton:focus {\n\
  border-color: @color_focus_bg;\n\
}\n\
\n\
spinbutton selection {\n\
  background-color: @color_focus_bg;\n\
}\n\
\n\
entry:focus {\n\
  border-color: @color_focus_fg;\n\
  box-shadow: none;\n\
}\n\
\n\
entry selection {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
  box-shadow: @color_shadow;\n\
}\n\
\n\
tab:checked {\n\
  box-shadow: 0 -4px @color_focus_bg inset;\n\
}\n\
\n\
tab:hover {\n\
  box-shadow: 0 -4px @color_focus_fg inset;\n\
}\n\
\n\
menuitem:hover {\n\
  box-shadow: none;\n\
}\n\
\n\
/*\n\
treeview box {\n\
  background-color: transparent;\n\
}\n\
\n\
list row box {\n\
  background-color: transparent;\n\
}\n\
*/\n\
\n\
button {\n\
  background-image: none;\n\
  text-shadow: none;\n\
  background: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
arrow {\n\
  background-color: transparent;\n\
}\n\
\n\
";

const char *mdc_theme_bluelight = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 */\n\
/*\n\
 */\n\
\n\
/* Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 */\n\
\n\
\n\
/* basic light color scheme, white on blue hightlight */\n\
@define-color color_basic_bg #f6f6fe;  /* light gray */\n\
@define-color color_basic_fg #2b2e30;  /* dark gray  */\n\
@define-color color_focus_bg #4a79c7;  /* blue-ish   */\n\
@define-color color_focus_fg #ffffff;  /* white      */\n\
@define-color color_dimmed   #919294;  /* dim gray   */\n\
@define-color color_shadow   #000000;  /* black      */\n\
\n\
*:selected {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:hover {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:disabled {\n\
  color: @color_dimmed;\n\
}\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
window, dialog, menu, grid, text, entry, treeview, tab, frame, header, textview, spinbutton, slider, list {\n\
  background-color: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
}\n\
\n\
header {\n\
  border-bottom-color: @color_basic_bg;\n\
}\n\
\n\
list {\n\
  background-color: @color_basic_bg;\n\
}\n\
\n\
scrollbar slider:hover {\n\
  background-color: @color_focus_fg;\n\
}\n\
\n\
box {\n\
  background-color: transparent;\n\
}\n\
\n\
notebook stack {\n\
  background-color: transparent;\n\
}\n\
\n\
spinbutton:focus {\n\
  border-color: @color_focus_bg;\n\
}\n\
\n\
spinbutton selection {\n\
  background-color: @color_focus_bg;\n\
}\n\
\n\
entry:focus {\n\
  border-color: @color_focus_fg;\n\
  box-shadow: none;\n\
}\n\
\n\
entry selection {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
  box-shadow: @color_shadow;\n\
}\n\
\n\
tab:checked {\n\
  box-shadow: 0 -4px @color_focus_bg inset;\n\
}\n\
\n\
tab:hover {\n\
  box-shadow: 0 -4px @color_focus_fg inset;\n\
}\n\
\n\
menuitem:hover {\n\
  box-shadow: none;\n\
}\n\
\n\
/*\n\
treeview box {\n\
  background-color: transparent;\n\
}\n\
\n\
list row box {\n\
  background-color: transparent;\n\
}\n\
*/\n\
\n\
button {\n\
  background-image: none;\n\
  text-shadow: none;\n\
  background: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
arrow {\n\
  background-color: transparent;\n\
}\n\
\n\
\n\
";

const char *mdc_theme_turbovision = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 */\n\
/*\n\
 */\n\
\n\
/* Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 */\n\
\n\
\n\
/* basic TurboVision color scheme, yellow on green hightlight */\n\
@define-color color_basic_bg #d6d6d6;  /* gray     */\n\
@define-color color_basic_fg #0000ff;  /* blue     */\n\
@define-color color_focus_bg #00bf00;  /* green    */\n\
@define-color color_focus_fg #ffff00;  /* yellow   */\n\
@define-color color_dimmed   #919294;  /* dim gray */\n\
@define-color color_shadow   #000000;  /* black    */\n\
\n\
*:selected {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:hover {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:disabled {\n\
  color: @color_dimmed;\n\
}\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
window, dialog, menu, grid, text, entry, treeview, tab, frame, header, textview, spinbutton, slider, list {\n\
  background-color: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
}\n\
\n\
header {\n\
  border-bottom-color: @color_basic_bg;\n\
}\n\
\n\
list {\n\
  background-color: @color_basic_bg;\n\
}\n\
\n\
scrollbar slider:hover {\n\
  background-color: @color_focus_fg;\n\
}\n\
\n\
box {\n\
  background-color: transparent;\n\
}\n\
\n\
notebook stack {\n\
  background-color: transparent;\n\
}\n\
\n\
spinbutton:focus {\n\
  border-color: @color_focus_bg;\n\
}\n\
\n\
spinbutton selection {\n\
  background-color: @color_focus_bg;\n\
}\n\
\n\
entry:focus {\n\
  border-color: @color_focus_fg;\n\
  box-shadow: none;\n\
}\n\
\n\
entry selection {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
  box-shadow: @color_shadow;\n\
}\n\
\n\
tab:checked {\n\
  box-shadow: 0 -4px @color_focus_bg inset;\n\
}\n\
\n\
tab:hover {\n\
  box-shadow: 0 -4px @color_focus_fg inset;\n\
}\n\
\n\
menuitem:hover {\n\
  box-shadow: none;\n\
}\n\
\n\
/*\n\
treeview box {\n\
  background-color: transparent;\n\
}\n\
\n\
list row box {\n\
  background-color: transparent;\n\
}\n\
*/\n\
\n\
button {\n\
  background-image: none;\n\
  text-shadow: none;\n\
  background: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
arrow {\n\
  background-color: transparent;\n\
}\n\
\n\
";

const char *mdc_theme_hundlivdawn = " \
/*\n\
 * filename: xmedcon.css\n\
 *\n\
 * CONFIG File: Medical Image Conversion Utility\n\
 *\n\
 * purpose    : the general Gtk styling & layout file\n\
 *\n\
 * project    : (X)MedCon by Erik Nolf\n\
 */\n\
/*\n\
 */\n\
\n\
/* Note: When (X)MedCon is installed, this becomes the system\n\
 *       wide styling file. You could copy it to your own\n\
 *       ${HOME}/.xmedcon.css for personal configurations.\n\
 */\n\
\n\
\n\
/* personal hundliv light theme */\n\
@define-color color_hundliv_black       #212222; /* black      */\n\
@define-color color_hundliv_white       #e4e4ce; /* white      */\n\
@define-color color_hundliv_dark_gray   #212222; /* dark  gray */\n\
@define-color color_hundliv_dim_gray    #44494c; /* dim   gray */\n\
@define-color color_hundliv_light_gray  #959588; /* light gray */\n\
@define-color color_hundliv_green       #ace724; /* green      */\n\
@define-color color_hundliv_orange      #fdb45f; /* orange     */\n\
@define-color color_hundliv_yellow      #fede2b; /* yellow     */\n\
@define-color color_hundliv_red         #c72e2e; /* red        */\n\
@define-color color_hundliv_magenta     #6d56a0; /* magenta    */\n\
@define-color color_hundliv_purple      #67578b; /* purple     */\n\
@define-color color_hundliv_blue        #426391; /* blue       */\n\
@define-color color_hundliv_dim_cyan    #a6c8e9; /* dim   cyan */\n\
@define-color color_hundliv_light_cyan  #2293ff; /* light cyan */\n\
\n\
@define-color color_basic_bg @color_hundliv_light_gray;\n\
@define-color color_basic_fg @color_hundliv_black;\n\
@define-color color_focus_bg @color_hundliv_green;\n\
@define-color color_focus_fg @color_hundliv_magenta;\n\
@define-color color_dimmed   @color_hundliv_dim_gray;\n\
@define-color color_shadow   @color_hundliv_black;\n\
@define-color color_text     @color_hundliv_blue;\n\
\n\
\n\
*:selected {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:hover {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
*:disabled {\n\
  color: @color_dimmed;\n\
}\n\
\n\
textview{\n\
  font: 12px monospace;\n\
}\n\
\n\
window, dialog, menu, menubar, grid, text, entry, treeview, tab, frame, header, textview, spinbutton, slider, list {\n\
  background-color: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  /*font: 12px monospace;*/\n\
}\n\
\n\
headerbar.titlebar {\n\
  background: @color_basic_bg;\n\
  color: @color_focus_fg;\n\
}\n\
\n\
treeview, list, textview text {\n\
  color: @color_text;\n\
}\n\
\n\
header {\n\
  border-bottom-color: @color_basic_bg;\n\
}\n\
\n\
list {\n\
  background-color: @color_basic_bg;\n\
}\n\
\n\
scrollbar slider:hover {\n\
  background-color: @color_hundliv_light_cyan;\n\
}\n\
\n\
box {\n\
  background-color: transparent;\n\
}\n\
\n\
notebook stack {\n\
  background-color: transparent;\n\
}\n\
\n\
spinbutton:focus {\n\
  /*border-color: @color_focus_bg;*/\n\
  border-color: @color_hundliv_orange;\n\
}\n\
\n\
spinbutton selection {\n\
  /*background-color: @color_focus_bg;*/\n\
  background-color: @color_hundliv_orange;\n\
}\n\
\n\
entry:focus {\n\
  /*border-color: @color_focus_fg;*/\n\
  border-color: @color_hundliv_orange;\n\
  box-shadow: none;\n\
}\n\
\n\
entry selection {\n\
  background-color: @color_focus_bg;\n\
  color: @color_focus_fg;\n\
  box-shadow: @color_shadow;\n\
}\n\
\n\
tab:checked {\n\
  box-shadow: 0 -4px @color_hundliv_purple inset;\n\
}\n\
\n\
tab:hover {\n\
  box-shadow: 0 -4px @color_focus_fg inset;\n\
}\n\
\n\
menuitem:hover {\n\
  box-shadow: none;\n\
}\n\
\n\
radio, check {\n\
  background-image: none;\n\
  border-color: @color_dimmed;\n\
}\n\
\n\
radio:checked, check:checked {\n\
  background-image: none;\n\
  background-color: @color_hundliv_magenta;\n\
  border-color: @color_hundliv_blue;\n\
  color: @color_hundliv_light_cyan;\n\
}\n\
\n\
radio:disabled, check:disabled {\n\
  background-image: none;\n\
  background-color: @color_basic_bg;\n\
  border-color: @color_dimmed;\n\
  color: @color_dimmed;\n\
}\n\
\n\
slider {\n\
  background-image: none;\n\
  background-color: @color_hundliv_blue;\n\
  border-color: @color_hundliv_light_cyan;\n\
}\n\
\n\
slider:hover {\n\
  background-image: none;\n\
  background-color: @color_hundliv_light_cyan;\n\
  border-color: @color_hundliv_blue;\n\
}\n\
\n\
highlight {\n\
  border-color: @color_hundliv_red;\n\
  background-color: @color_hundliv_orange;\n\
}\n\
\n\
trough {\n\
  background-color: @color_dimmed;\n\
  border-color: @color_dimmed;\n\
}\n\
\n\
/*\n\
treeview box {\n\
  background-color: transparent;\n\
}\n\
\n\
list row box {\n\
  background-color: transparent;\n\
}\n\
*/\n\
\n\
button {\n\
  background-image: none;\n\
  text-shadow: none;\n\
  background: @color_basic_bg;\n\
  color: @color_basic_fg;\n\
  border-color: @color_shadow;\n\
}\n\
\n\
arrow {\n\
  background-color: transparent;\n\
}\n\
\n\
#WarningLabel {\n\
  color: @color_hundliv_orange;\n\
}\n\
/*\n\
#TextView {\n\
  font: 12px monospace;\n\
}*/\n\
\n\
\n\
";
