/***************************************************************
 **
 ** class jhead::JHead
 **
 ** This class is an inteface to the functions provided in jhead
 ** Please note that I will only expose those APIs which I need
 ** in QDVDAuthor to obtain Exif information from images.
 ** 
 ** The class is defined as an interface because I want to 
 ** dynamically load the library only when I need its 
 ** functionality. 
 ** 
 ***************************************************************/

#ifndef __JHEAD_H__
#define __JHEAD_H__

#include <QIcon>
#include <QString>
#include <QDateTime>

namespace jhead
{

class JHead
{
public:
  class GPSInfo  {
  public:
    GPSInfo ( ) { };

    QString qsLat;
    QString qsLon;
    QString qsAlt;
  };
  class Info  {
  public:
     Info ( ) { pGPSInfo=NULL; pThumbnail=NULL; iWidth=-1; iHeight=-1; iFileSize=-1; iOrientation=0; };
    ~Info ( ) { if ( pGPSInfo ) delete pGPSInfo; if ( pThumbnail ) delete pThumbnail; };

    int  iWidth;
    int  iHeight;
    int  iFileSize;
    int  iOrientation;
    QIcon     *pThumbnail;
    QString   qsFileName;
    QString   qsThumbnailFileName;
    QString   qsComment;
    QDateTime fileDate;
    QDateTime imageDate;
    GPSInfo   *pGPSInfo;
    
    // More Exif info
    QString   qsCamera;
    QString   qsModel;
    bool      bIsColor;
    int       iFlashFlags;
    float     fFocalLength;
    float     fDigitalZoom;
    float     fCCDWidth;
    float     fExposureTime;
    float     fAperture;
    int       iISOEquiv;
    float     fExposureBias;
    bool      bWhitebalance;
    int       iLightsource;
    int       iExposureProg;
    int       iDistanceRange;
  };

  JHead ( ) { };
  virtual ~JHead ( ) { };

  virtual void setFileName ( QString &qsFileName ) { m_qsFileName = qsFileName; };

// Here are the calls to the API.
  virtual Info *getFileInfo ( QString &qsFile, QString *pThumb=NULL ) = 0;
  virtual bool  hasThumbnail            ( ) = 0;
  virtual QDateTime getCreationDate     ( ) = 0;
  virtual void  saveThumbnail ( QString & ) = 0;
  virtual int   getWidth                ( ) = 0;
  virtual int   getHeight               ( ) = 0;

private:
  QString m_qsFileName;
};

}; // end of namespace jhead

// the types of the class factories
//typedef jhead::JHead *create_t ( );   //ooo
typedef jhead::JHead *createJHead_t ( );    //xxx
//typedef void destroy_t ( jhead::JHead * );    //ooo
typedef void destroyJHead_t ( jhead::JHead * ); //xxx

#endif
