
extern "C"
{
#include "../jhead.h"
}

#include <QFileInfo>
#include <QList>

#include "library.h"


// The class factories
extern "C"  jhead::JHead *createPlugin ( ) {
    return new jhead::Library;
}
extern "C" void destroyPlugin ( jhead::JHead *pDeleteMe ) {
    delete pDeleteMe;
}

extern void ProcessFile   ( const char * );
extern void ResetJpegfile ( void );
extern void DiscardData   ( void );
//      memset(&ImageInfo, 0, sizeof(ImageInfo));

#ifndef PREFIX
#define PREFIX "/usr"
#endif

namespace jhead
{

QMutex Library::m_mutex;

Library::Library ( )
{
  // Init the data
  ResetJpgfile   ( );
  m_pInfo = NULL;
}

Library::~Library ( )
{
  lock        ( );
  DiscardData ( );
  unlock      ( );
}

void Library::lock ( )
{
  m_mutex.lock ( );
}

void Library::unlock ( )
{
  m_mutex.unlock ( );
}

jhead::JHead::Info *Library::getFileInfo ( QString &qsFileName, QString *pThumbnailFileName )
{
  QFileInfo fileInfo ( qsFileName );
  // Since we have static crap around we have to lolck this in
  lock ( );

  // Re-sets the static buffers
  DiscardData ( );

  //int iRet  = ::ReadJpegFile ( (const char *)qsFileName.toAscii ( ), READ_METADATA ); //ooo
  int iRet  = ::ReadJpegFile ( (const char *)qsFileName.toLatin1 ( ).data(), READ_METADATA );   //xxx
  int iRet2 = -1;

  Info *pInfo = NULL;
  m_pInfo = NULL;
  if ( iRet )  {
    pInfo                 = new Info;
    pInfo->qsFileName     = qsFileName;
    pInfo->iWidth         = ImageInfo.Width;
    pInfo->iHeight        = ImageInfo.Height;
    pInfo->iFileSize      = (int)fileInfo.size ( ); //ImageInfo.FileSize;
    pInfo->fileDate.setTime_t ( ImageInfo.FileDateTime );
    if ( pInfo->fileDate.isValid ( ) )
         pInfo->fileDate  = fileInfo.created ( );
    if ( strlen ( ImageInfo.DateTime ) > 17 )
         pInfo->imageDate = QDateTime::fromString ( ImageInfo.DateTime, "yyyy:MM:dd hh:mm:ss" ); //, Qt::ISODate );
    else
         pInfo->imageDate = pInfo->fileDate;
    pInfo->iOrientation   = ImageInfo.Orientation;
    if ( ImageInfo.Comments[0] )
      pInfo->qsComment    = QString ( ImageInfo.Comments );
    if ( ImageInfo.GpsInfoPresent )  {
      pInfo->pGPSInfo = new GPSInfo;
      pInfo->pGPSInfo->qsLat = QString ( ImageInfo.GpsLat  );
      pInfo->pGPSInfo->qsLon = QString ( ImageInfo.GpsLong );
      pInfo->pGPSInfo->qsAlt = QString ( ImageInfo.GpsAlt  );
    }
    if ( pThumbnailFileName && ( ImageInfo.ThumbnailOffset != 0 )  &&  ( ImageInfo.ThumbnailSize != 0 ) )  {
      //iRet2 = ::SaveThumbnail  ( pThumbnailFileName->toAscii  ( ).data ( ) ); //"/tmp/th.jpg" );  //ooo
      iRet2 = ::SaveThumbnail  ( pThumbnailFileName->toLatin1  ( ).data ( ) ); //"/tmp/th.jpg" );  //xxx
      pInfo->qsThumbnailFileName = *pThumbnailFileName;
      pInfo->pThumbnail = new QIcon ( pInfo->qsThumbnailFileName );
    }
  }
  unlock ( );

// Debug output
#if 0
  printf ( "Read<%d> Save<%d>  pInfo<%p>\n", iRet, iRet2, pInfo );
  if ( pInfo )  {
    printf ( "date<%s> vs date<%s> fdate<%d> vs <%s>\n", ImageInfo.DateTime, (const char *)pInfo->imageDate.toString ( ).toAscii ( ), (int)ImageInfo.FileDateTime, (const char *)pInfo->fileDate.toString ( ).toAscii ( ) );
  }
#endif
  return pInfo;
}

// Here are the calls to the API.
bool Library::hasThumbnail ( )
{
  return m_pInfo ? ( m_pInfo->pThumbnail != NULL ) : false;
}

QDateTime Library::getCreationDate ( )
{
  QDateTime dt = QDateTime::currentDateTime ( );
  return m_pInfo ? m_pInfo->imageDate : dt;
}

void Library::saveThumbnail ( QString & )
{

}

int Library::getWidth ( )
{
  return m_pInfo ? m_pInfo->iWidth : -1;
}

int Library::getHeight ( )
{
  return m_pInfo ? m_pInfo->iHeight : -1;
}

}; // End of namespace jhead

