
#include <stdlib.h>
#include <dlfcn.h>

#include <QDir>
#include <QIcon>
#include <QFileDialog>
#include <QApplication>
#include <QListWidgetItem>

#include "window.h"

Window::Window(QWidget *parent)
    : QDialog ( parent )
{
  setupUi ( this );
  m_pLibrary         = NULL;
  m_pPlugin          = NULL;
  m_pDestroyFunction = NULL;
  m_pListView->setViewMode ( QListView::IconMode );
  m_pListView->setIconSize ( QSize  ( 100, 100 ) );
  m_pListView->setGridSize ( QSize  ( 110, 160 ) );
  m_pListView->setSpacing  ( 40 );
  m_pListView->setMovement ( QListView::Snap );
  m_pListView->setWordWrap ( true );
  m_pProgressBar->setValue ( 0 );

  connect ( m_pButtonBrowse, SIGNAL ( clicked ( ) ), this, SLOT ( slotBrowse ( ) ) );

  loadPlugin ( );
}

Window::~Window ( )
{
  unloadPlugin ( );
}

void Window::slotBrowse ( )
{
  // For easier testing I want to re-load the plugin each time ...
  unloadPlugin ( );
  loadPlugin   ( );

  if ( m_pPlugin )  {
    int iCounter = 1;
    QString qsDir = QFileDialog::getExistingDirectory ( this );
    if ( qsDir.isEmpty ( ) )
      return;

    QDir theDir ( qsDir );
    QString qsFullPath, qsThumbPath;
    QString qsFilter ( "*.jpg *.jpeg *.JPG *.JPEG");

    QList<jhead::JHead::Info *> list;
    jhead::JHead::Info *pInfo = NULL;
    QStringList listOfFilter  = qsFilter.split   ( QString ( " " ) );
    QStringList listOfFiles   = theDir.entryList ( listOfFilter, QDir::Files );

    m_pProgressBar->setRange ( 0, listOfFiles.count ( ) * 2 );
    QStringList::iterator it = listOfFiles.begin ( );
    while ( it != listOfFiles.end ( ) )  {
      qsFullPath  = theDir.path ( ) + "/" + *it;
      qsThumbPath = "/tmp/"   + *it++;
      pInfo = m_pPlugin->getFileInfo   ( qsFullPath, &qsThumbPath );
      if ( pInfo )
           list.append ( pInfo );
      m_pProgressBar->setValue ( iCounter ++ );
      QCoreApplication::flush  ( );
    }

    m_pListView->clear ( );
    QFileInfo fileInfo;
    QString qsFileName, qsInfo;
    QList<jhead::JHead::Info *>::iterator it2 = list.begin ( );

    while ( it2 != list.end ( ) )  {
      pInfo      = *it2++;
      if ( ! pInfo )
        continue;
      if ( ! pInfo->pThumbnail )  {
        delete pInfo;
        continue;
      }

      fileInfo.setFile    (  pInfo->qsThumbnailFileName );
      qsInfo = QString ( "%1\n%2\n%3x%4" ).arg ( fileInfo.fileName ( ) ).arg ( pInfo->imageDate.toString ( "yyyy/MM/dd hh:mm:ss" ) ).arg ( pInfo->iWidth ).arg ( pInfo->iHeight );
      new QListWidgetItem ( *pInfo->pThumbnail, qsInfo, m_pListView );
      m_pProgressBar->setValue ( iCounter ++ );
      QCoreApplication::flush  ( );

      delete pInfo;
    }
    m_pProgressBar->setValue ( 0 );
    QString qsTitle = QString ( "%1 Images in <%2> have exif built in thumbnails" ).arg ( m_pListView->count ( ) ).arg ( qsDir );
    setWindowTitle ( qsTitle );
  }
}

bool Window::loadPlugin ( )
{
  QString qsFilePath = "../lib/libjhead.so";

  m_pLibrary = dlopen ( (const char *)qsFilePath.toAscii ( ), RTLD_LAZY );
  if ( ! m_pLibrary ) {
    printf ( "Fatal: Cannot load library <%s>\n       %s\n", (const char *)qsFilePath.toAscii ( ), dlerror ( ) );
    return false;
  }

  // reset errors
  dlerror ( );

  // load the symbols
  //create_t   *pCreateLibrary = (create_t *) dlsym ( m_pLibrary, "createPlugin" ); //ooo
  createJHead_t   *pCreateLibrary = (createJHead_t *) dlsym ( m_pLibrary, "createPlugin" ); //xxx
  const char *pErrorString   = dlerror (  );
  if ( pErrorString ) {
    printf ( "Cannot load symbol create: %s\n", pErrorString );
    return false;
  }

  //m_pDestroyFunction = (destroy_t *) dlsym ( m_pLibrary, "destroyPlugin" );   //ooo
  m_pDestroyFunction = (destroyJHead_t *) dlsym ( m_pLibrary, "destroyPlugin" );    //xxx
  pErrorString = dlerror ( );
  if ( pErrorString ) {
    printf ( "Cannot load symbol destroy: %s\n", pErrorString );
    return false;
  }

  // create an instance of the class
  m_pPlugin = pCreateLibrary ( );

  return true;
}

void Window::unloadPlugin ( )
{
  // destroy the class
  if ( m_pPlugin && m_pDestroyFunction )  {
    m_pDestroyFunction ( m_pPlugin );
  }
  m_pDestroyFunction = NULL;
  m_pPlugin = NULL;

  // unload the triangle library
  if ( m_pLibrary )
    dlclose ( m_pLibrary );
  m_pLibrary = NULL;
}




