/***************************************************************************
    dialogaudio.cpp
                             -------------------
                             
    begin                : March 2015
    copyright            : (c) 2015 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
    
   DialogAudio 
    
   This class encapsulates the Dialog to assign audio to a language and / or
   mark the audio stream or transcoding.
    
****************************************************************************/

#ifndef DIALOGAUDIO_H
#define DIALOGAUDIO_H

#include <QTreeWidgetItem>   //xxx

//#include "uidialogaudio.h"		//ooo
#include "ui_uidialogaudio.h"		//xxx

class TranscodeInterface;
class SourceFileEntry;
class SourceFileInfo;
class AudioEntry;
class DVDMenu;
class Audio;

//class DialogAudio : public uiDialogAudio			//ooo
class DialogAudio : public QDialog, public Ui::uiDialogAudio	//xxx
{
    Q_OBJECT

public:
     //DialogAudio ( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );	//ooo
     DialogAudio ( QWidget* pParent = 0 );									//xxx
    ~DialogAudio ( );

    void initMe ( SourceFileInfo  *, SourceFileEntry *, QString & );
    void initMe ( SourceFileEntry * );
    void initMe ( DVDMenu * );
    void initAudioSource ( SourceFileEntry * );
    int  getSelectedNumber ( );
    void setTranscode ( TranscodeInterface * );
    TranscodeInterface *getTranscode ( );

protected slots:
    virtual void accept                ( );
    virtual void slotHelp              ( );
    virtual void slotAdd               ( );
    virtual void slotEdit              ( );
    virtual void slotDelete            ( );
    virtual void slotSetSelectedItem   ( );
    virtual void slotAudioEntryChanged ( int );
    virtual void slotTranscoding       ( bool );
    //virtual void slotCurrentChanged    ( Q3ListViewItem * );  //ooo
    virtual void slotCurrentChanged    ( QTreeWidgetItem *, int );   //xxx

private:
    void initAudioInfo    ( Audio * );
    void initAudioInfo    ( TranscodeInterface * );
    void initAudioInfo    ( SourceFileInfo * );
    void setAudioInfo     ( SourceFileInfo *, SourceFileInfo * );
    void removeAudioTrack ( SourceFileInfo *, int );
    QString showLanguageDialog   ( );
    bool    checkAudioNumber ( int );

private:
    QString m_qsFileName;
    SourceFileEntry  *m_pSourceFileEntry;
    SourceFileEntry  *m_pOrigSourceFileEntry;
    SourceFileInfo   *m_pSourceFileInfo;
    SourceFileInfo   *m_pOrigSourceFileInfo;
    //Q3ListViewItem    *m_pSelectItem; //ooo
    QTreeWidgetItem    *m_pSelectItem;  //xxx
    DVDMenu          *m_pDVDMenu;
};

#endif // DIALOGAUDIO_H
