/****************************************************************************
** Form implementation generated from reading ui file 'uidialoglibrary.ui'
**
**   Created : Sun Feb 18 09:13:25 2007
**        by : Varol Okan, using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#include <qdir.h>
#include <qtimer.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qfileinfo.h>
#include <qcombobox.h>
#include <qlineedit.h>
//#include <q3iconview.h>   //ooo
#include <QListWidget>        //xxx
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qstringlist.h>
#include <qapplication.h>
//#include <q3progressbar.h>    //ooo
#include <QProgressBar> //xxx
//Added by qt3to4:
//#include <Q3GridLayout>   //ooo
#include <QGridLayout> //xxx
#include <QPixmap>

#include "CONFIG.h"
#include "global.h"
#include "dialoglibrary.h"

bool DialogLibrary::m_bCreateButtonMask = true;

//DialogLibrary::LibraryPart::LibraryPart ( Q3IconView *pView, QString qsPath ) //ooo
DialogLibrary::LibraryPart::LibraryPart ( QListWidget *pView, QString qsPath )   //xxx
{
  pIconView     = pView;
  qsLibraryPath = qsPath;
}

//DialogLibrary::DialogLibrary ( QWidget *pParent, const char *pName, bool bModal, Qt::WFlags flags )		//ooo
DialogLibrary::DialogLibrary ( QWidget *pParent )
  //: uiDialogLibrary  ( pParent, pName, bModal, flags )	//ooo
  : QDialog ( pParent )						//xxx
{
  setupUi(this);	//xxx
  initMe ( );
}

DialogLibrary::~DialogLibrary ( )
{
  int t;
  for ( t=0; t<(int)m_listLibrary.count ( ); t++ ) 
    delete m_listLibrary[t];
}

void DialogLibrary::initMe ( )
{
  // build all library tabs.
  int      t;
  QDir     theDir;
  QString  qsPrefixDir, qsDirName;
  QStringList listDirs, listFiles;

  qsPrefixDir = QString ("%1/share/qdvdauthor/buttons").arg ( Global::qsSystemPath );
  if ( !  theDir.exists ( qsPrefixDir ) )
    return;

  m_iWidth  = 120;
  m_iHeight = 120;
  m_pCheckButtonMask->setChecked ( m_bCreateButtonMask );

  //QWidget *pTab = m_pTabWidget->page ( 0 );   //ooo
  QWidget *pTab = m_pTabWidget->widget ( 0 ); //xxx
  while  ( pTab ) {
    delete pTab;
    //pTab = m_pTabWidget->page ( 0 );  //ooo
    pTab = m_pTabWidget->widget ( 0 );    //xxx
  }

  //theDir.cd ( qsPrefixDir, TRUE );	//ooo
  theDir.cd ( qsPrefixDir );		//xxx
  listDirs = theDir.entryList ( QDir::Dirs, QDir::Name );
  if ( listDirs.count ( ) < 3 ) // 3 = this dir / parent dir / background file
    return;

  // The following widgets will create th progress dialog on the fly.
  QDialog       progressDialog  ( NULL );
  //Q3GridLayout  *pProgressLayout = new Q3GridLayout  ( &progressDialog ); //, 1, 1 ); //, 11, 6, "progressWidgetLayout" );    //ooo
  QGridLayout  *pProgressLayout = new QGridLayout  ( &progressDialog );  //xxx
  //Q3ProgressBar *pProgressBar    = new Q3ProgressBar ( &progressDialog ); //ooo
  QProgressBar *pProgressBar    = new QProgressBar ( &progressDialog );   //xxx
  pProgressLayout->addWidget( pProgressBar, 0, 0 );
  progressDialog.resize( QSize(537, 50).expandedTo ( progressDialog.minimumSizeHint ( ) ) );
  progressDialog.show  ( );

  for ( t=0; t<(int)listDirs.count ( ); t++ )  {
    // Here we go through all directories 
    qsDirName = listDirs[t];
    if ( ( qsDirName == ".") || ( qsDirName == "..") )
      continue;

    //progressDialog.setCaption ( tr ( "Creating preview for buttons : %1" ).arg ( listDirs[t] ) ); //ooo
    progressDialog.setWindowTitle ( tr ( "Creating preview for buttons : %1" ).arg ( listDirs[t] ) );   //xxx

    // Next we need to get the file list of the found directory
    QString qsPath = qsPrefixDir + "/" + qsDirName;
    theDir.cd ( qsPath );
    listFiles = theDir.entryList ( QDir::Files, QDir::Name );
    createTab ( qsDirName, qsPath, listFiles );

    //pProgressBar->setProgress ( (int)((float)t / listDirs.count ( ) * 100.0) );   //ooo
    pProgressBar->setValue ( (int)((float)t / listDirs.count ( ) * 100.0) ); //xxx
    //qApp->processEvents ( 100 ); // do some event processing ...				//ooo
    qApp->processEvents ( QEventLoop::AllEvents, 100 ); // do some event processing ...		//xxx
  }
  connect ( m_pButtonRefresh,   SIGNAL ( clicked ( ) ), this, SLOT ( slotRefresh ( ) ) );
  connect ( m_pCheckButtonMask, SIGNAL ( clicked ( ) ), this, SLOT ( slotChecked ( ) ) );
  QTimer::singleShot ( 200, this, SLOT ( slotAfterInit ( ) ) );
}

void DialogLibrary::createTab ( QString qsDirName, QString qsPath, QStringList &listFiles )
{
  int t;
  if ( listFiles.count ( ) < 1 )
    return;

  // Okay, ready to create the tab ... 
  QFileInfo fileInfo;
  QString qsFileName;
  QSize grid ( 10, 10 );
  //QWidget     *pTab      = new QWidget     ( m_pTabWidget, "pTab" );  //ooo
  QWidget     *pTab      = new QWidget     ( m_pTabWidget );    //xxx
  //Q3GridLayout *pLayout   = new Q3GridLayout ( pTab, 1, 1, 4, 2, "pLayout" ); //ooo
  QGridLayout *pLayout   = new QGridLayout ( pTab );   //xxx
  //Q3IconView   *pIconView = new Q3IconView   ( pTab, "pIconViewLibrary" );    //ooo
  QListWidget   *pIconView = new QListWidget   ( pTab );  //xxx
  LibraryPart *pNewPart  = new LibraryPart ( pIconView, qsPath );
  m_listLibrary.append ( pNewPart );

  pLayout->addWidget        ( pIconView,  0, 0 );
  //pIconView->setAutoArrange ( true  );    //ooo
  //m_pTabWidget->insertTab   ( pTab,  qsDirName ); //ooo
  m_pTabWidget->addTab   ( pTab,  qsDirName );   //xxx

  for ( t=0; t<(int)listFiles.count ( ); t++ ) {
    qsFileName = qsPath + "/" + listFiles[t];
    QPixmap thePix;
    QImage  theImage ( qsFileName );

    if ( theImage.isNull ( ) )
      continue;
    /*
    QFileInfo fileInfo ( listFiles[t] );
    QString qs = qsPath + "/" + fileInfo.baseName ( ) + ".png";
    printf ( "<%s>\n", qs.ascii () );

    setTransparentColor     ( theImage );
    theImage.save ( qs, "PNG" );
    */
    if ( ( theImage.width ( ) > m_iWidth ) || ( theImage.height ( ) > m_iHeight ) )
      //theImage = theImage.smoothScale ( m_iWidth, m_iHeight, Qt::KeepAspectRatio );   //ooo
      theImage = theImage.scaled ( m_iWidth, m_iHeight, Qt::KeepAspectRatio );     //xxx

    setTransparentColor     ( theImage );
    thePix.convertFromImage ( theImage );

    //new Q3IconViewItem ( pIconView, listFiles[t], thePix );   //ooo
    new QListWidgetItem ( thePix, listFiles[t], pIconView ); //xxx
  }

  //pIconView->arrangeItemsInGrid ( grid, TRUE );   //ooo
  pIconView->sortItems ( Qt::AscendingOrder );      //xxx
  //pIconView->sort ( );    //oooo
}

void DialogLibrary::slotAfterInit ( )
{
  // Somehow the first IconView does not arrange in a grid.
  // so we have to force it to arrange
  if ( m_listLibrary.count ( ) < 1 )
    return;

  LibraryPart *pLibraryPart = m_listLibrary [ 0 ];
  //pLibraryPart->pIconView->sort ( true ); //oooo
}

void DialogLibrary::slotChecked ( ) 
{
  m_bCreateButtonMask = m_pCheckButtonMask->isChecked ( );
}

void DialogLibrary::slotRefresh ( )
{
  bool bOkay;
  int t, iStretchMode;
  QDir         theDir;
  QFileInfo    fileInfo;
  QString      qsFileName;
  QStringList  listFiles;
  //Q3IconView   *pCurrentView = NULL;  //ooo
  QListWidget   *pCurrentView = NULL;    //xxx
  LibraryPart *pLibraryPart = NULL;
  //int          iCurrentTab = m_pTabWidget->currentPageIndex ( );  //ooo
  int          iCurrentTab = m_pTabWidget->currentIndex ( );    //xxx
  QSize        grid ( 10, 10 );
  if ( iCurrentTab <(int)m_listLibrary.count ( ) )
    pLibraryPart = m_listLibrary [ iCurrentTab ];

  if ( ! pLibraryPart )
    return;

  pCurrentView = pLibraryPart->pIconView;
  pCurrentView->clear ( );

  m_iWidth = m_pEditWidth->text ( ).toInt ( &bOkay );
  if ( ! bOkay )
    m_iWidth = 120;

  m_iHeight = m_pEditHeight->text ( ).toInt ( &bOkay );
  if ( ! bOkay )
    m_iHeight = 120;

  //iStretchMode = m_pComboStretch->currentItem ( );    //ooo
  iStretchMode = m_pComboStretch->currentIndex ( ); //xxx
  if ( iStretchMode == 0 )
    //iStretchMode = QImage::ScaleMin;		//ooo
    iStretchMode = Qt::KeepAspectRatio;		//xxx
  else if ( iStretchMode == 1 )
    //iStretchMode = QImage::ScaleMax;			//ooo
    iStretchMode = Qt::KeepAspectRatioByExpanding;	//xxx
  else if ( iStretchMode == 2 )
    //iStretchMode = QImage::ScaleFree;			//ooo
    iStretchMode = Qt::IgnoreAspectRatio;		//xxx

  theDir.cd ( pLibraryPart->qsLibraryPath );
  listFiles = theDir.entryList ( QDir::Files, QDir::Name );

  for ( t=0; t<(int)listFiles.count ( ); t++ ) {
    qsFileName = pLibraryPart->qsLibraryPath + "/" + listFiles[t];
    QPixmap thePix;
    QImage  theImage ( qsFileName );

    if ( theImage.isNull ( ) )
      continue;

    if ( ( theImage.width ( ) > m_iWidth ) || ( theImage.height ( ) > m_iHeight ) )
      //theImage = theImage.smoothScale ( m_iWidth, m_iHeight, (Qt::AspectRatioMode)iStretchMode ); //ooo
      theImage = theImage.scaled ( m_iWidth, m_iHeight, (Qt::AspectRatioMode)iStretchMode );   //xxx

    setTransparentColor     ( theImage );
    thePix.convertFromImage ( theImage );

    //new Q3IconViewItem ( pCurrentView, listFiles[t], thePix );    //ooo
    new QListWidgetItem ( thePix, listFiles[t], pCurrentView );  //xxx
  }

  //pCurrentView->arrangeItemsInGrid ( grid, TRUE );    //ooo
  pCurrentView->sortItems ( Qt::AscendingOrder );      //xxx
}

void DialogLibrary::setTransparentColor ( QImage &theImage )
{
  // QPixmap do not handle transparency, so we replace the tranparent parts here with the
  // color designated to be transparent in QDVDAuthor.
  int x, y, iWidth, iHeight;
  QRgb thePixel;

  iWidth  = theImage.width  ( );
  iHeight = theImage.height ( );
  for ( y=0; y < iHeight; y++)	{
    for (x=0; x < iWidth; x++)	{
      thePixel = theImage.pixel ( x, y );
      if ( ( thePixel & 0xFF000000 ) < 0x10000000 ) // See if this pixel is marked transparent.
	theImage.setPixel ( x, y, (uint)qRgba ( TRANSPARENT_COLOR, 0 ) ); // Transparent Color
    }
  }
}

void DialogLibrary::accept ( )
{
  hide ( );
}
