/***************************************************************************
    dialogmovie.h
                             -------------------
    begin                : March 2015
    copyright            : (c) 2015 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

#ifndef DIALOGMOVIE_H
#define DIALOGMOVIE_H

//#include <q3listview.h>   //ooo
#include <QListWidget>  //xxx
#include <QPainter> //xxx
#include <QTreeWidget>  //xxx

#include "sourcefileentry.h"
#include "ui_uidialogmovie.h"
#include "buttonobject.h"

class MovieObject;
class DVDMenu;
class QDVDAuthor;
class MediaInterface;
class StartStopControl;

//class ListViewColorItem : public Q3ListViewItem   //ooo
/*class ListViewColorItem : public QListWidgetItem    //xxx
{
public:
  //ListViewColorItem (Q3ListView *, Rgba, QString, QString l2=QString::null, QString l3=QString::null, QString l4=QString::null,   //ooo
		     //QString l5=QString::null, QString l6=QString::null, QString l7=QString::null, QString l8=QString::null);   //ooo
  ListViewColorItem (QListWidget *, Rgba    );  //xxx

  //virtual void paintCell ( QPainter *, const QColorGroup &, int, int, int );  //ooo
  virtual void paintCell ( QPainter *, const QPalette &, int, int, int );   //xxx
private:
  Rgba m_theColor;
};*/    //ooo

class DialogMovie : public QDialog, public Ui::uiDialogMovie		//xxx
{
	Q_OBJECT
public:
  //DialogMovie(QWidget *p=NULL, const char *n=NULL, Qt::WFlags f=0);	//ooo
  DialogMovie(QWidget *pParent=NULL);					//xxx
 ~DialogMovie();

  void initMe(SourceFileInfo  *, const void *, QDVDAuthor * );
  void initMe(SourceFileEntry *);
  void initMe(MovieObject     *);
  void initMe(DVDMenu         *);	//oooo
  
  bool transcodeEnabled ( );
  void initTranscodeTab ( );
  
  SourceFileInfo *sourceFileInfo ( );
  
protected slots:
  virtual void timerEvent       ( QTimerEvent * );
  virtual void slotNewVolume    ( int );
  virtual void accept           ( );
  virtual void slotBlink        ( );
  virtual void slotWidth        ( );
  virtual void slotHeight       ( );
  virtual void slotPlay         ( );
  virtual void slotStop         ( );
  virtual void slotSetThumbnail ( );
  virtual void slotStart        ( );
  virtual void slotEnd          ( );
  virtual void slotTranscode    ( );
  virtual void slotEncodeNow    ( );
  
  virtual void slotImportChapter( );
  virtual void slotAddChapter   ( );
  virtual void slotDelChapters  ( );
  virtual void slotAutoChapters ( );
  virtual void slotAnimation    ( );
  virtual void slotSizeDialog   ( );
  virtual void slotEditMediaInfo( );
  //virtual void slotCurrentChanged ( Q3ListBoxItem *); //ooo
  virtual void slotCurrentChanged ( QListWidgetItem *);   //xxx

  virtual void slotNewPosition    ( int, const QString &);  
  virtual void slotSliderValues   ( float, float );
  virtual void slotSliderReleased ( bool );
  
  virtual void slotVideoOutChanged        (const QString &);
  virtual void slotVideoResolutionChanged (const QString &);
  virtual void slotVideoRateChanged       (const QString &);
  virtual void slotVideoTypeChanged       (const QString &);
  virtual void slotVideoAspectChanged     (const QString &);
  virtual void slotVideoBitrateChanged    (const QString &);
  virtual void slotAudioOutChanged        (const QString &);
  virtual void slotAudioTypeChanged       (const QString &);
  virtual void slotAudioBitrateChanged    (const QString &);
  
  virtual void slotSetStartStop       ( );
  virtual void slotSetMediaInfo       ( );
  virtual void slotInitMediaInterface ( );
  virtual void slotSameAsMenuLength   ( );
  virtual void slotCheckStart         ( );
  virtual void slotCheckEnd           ( );
  virtual void slotLoop               ( );
  virtual void slotMenuLoop           ( );
  virtual void slotTransition         ( );
  
  virtual void slotBrowseColorKey ( );
  
  virtual void slotAddAudio       ( );
  virtual void slotEditAudio      ( );
  virtual void slotDeleteAudio    ( );
  virtual void slotAddSubtitle    ( );
  virtual void slotEditSubtitle   ( );
  virtual void slotDeleteSubtitle ( );
  bool subtitleDialog  ( int &, QString & );
  //virtual void slotAudioSelectionChanged    ( Q3ListViewItem * ); //ooo
  virtual void slotAudioSelectionChanged    ( QTreeWidgetItem *, int );  //xxx
  //virtual void slotSubtitleSelectionChanged ( Q3ListViewItem * ); //ooo
  virtual void slotSubtitleSelectionChanged ( QTreeWidgetItem *, int );   //xxx
  
  virtual void slotSetSelectedItem( );
  virtual void slotSubLangChanged ( bool );
  
signals:
  void signalSetThumbnail ( long );
  
private:
  QString keepClean    ( const QString  & );
  void setStartStop    ( bool             );
  void addChapter      ( QString &        );
  void initMediaInterface ( DVDMenu    * );
  void initAudioTab    ( SourceFileInfo *, DVDMenu *p=NULL );
  void setHeader       ( SourceFileInfo * );
  bool sanityCheckSubtitleTrack( int   &, QString & );
  void addSubtitle     ( QString, int, QList<Subtitles::entry *> &, QString );	//oxx
  void deleteSubtitle  ( int );
  void createAudioList (     );
  void applyTransitions(     );
  QTime maxEndTime     (     );
  QTime duration       (     );
  TranscodeInterface *checkRightAudioFormat ( QString & );
  
private:
  int               m_iTransitionForAll; // -1==doNothing / 0=remove all transitions / 1=set all transitions
  QRect             m_rectGeometry;
  QString           m_qsFileName;
  QString           m_qsPosition;
  int               m_iMovieLength;
  QWidget          *m_pTranscodeTab;
  //Q3ListViewItem    *m_pSelectItem;	//ooo
  QTreeWidgetItem    *m_pSelectItem;	//xxx
  MediaInterface   *m_pMediaInterface;
  StartStopControl *m_pStartStopControl;
  SourceFileInfo    m_sourceFileInfo;
  SourceFileEntry  *m_pParentSourceFileEntry;
  MovieObject      *m_pMovieObject;
  DVDMenu          *m_pDVDMenu;
  QStringList       m_listButtonTransitions;
  ButtonTransition  m_allTransitions;

  // the following is only used for the initializaion part
  const void       *m_pExistingEngine;
};

#endif // DIALOGMOVIE_H
