/****************************************************************************
** Interface to the GUI.
**
**   Created : Thu Jan 18 22:48:00 2007
**        by : Varol Okan using XEmacs
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef __DIALOGTHUMBNAIL_H__
#define __DIALOGTHUMBNAIL_H__

#include <qimage.h>

#include "qplayer/mediascanner.h"
//Added by qt3to4:
//#include <Q3ValueList>		//oxx
#include <QTimerEvent>
#include <QTreeWidget>  //xxx
#include <QListWidget>  //xxx
//#include "uidialogthumbnail.h"	//ooo
#include "ui_uidialogthumbnail.h"	//xxx

class QDVDAuthor;
class SourceFileInfo;
class SourceFileEntry;

//class DialogThumbnail : public uiDialogThumbnail			//ooo
class DialogThumbnail : public QDialog, public Ui::uiDialogThumbnail	//xxx
{
  Q_OBJECT

  class ThumbnailRequest : public ExecuteJob {
  public:
    //ThumbnailRequest ( DialogThumbnail *, Q3IconViewItem *, QString, long );  //ooo
    ThumbnailRequest ( DialogThumbnail *, QListWidgetItem *, QString, long );    //xxx
    virtual ~ThumbnailRequest ( );

    virtual bool response ( );

    //Q3IconViewItem   *pOwnerItem; //ooo
    QListWidgetItem   *pOwnerItem;   //xxx
    DialogThumbnail *pParent;
  };
  // When the image is rendered the returned data is temp stored in this struct
  // to be executed in timerEvent.
  class WorkWaiting
  {
  public:
     //WorkWaiting ( Q3IconViewItem *, QImage *, QString ); //ooo
     WorkWaiting ( QListWidgetItem *, QImage *, QString );
    ~WorkWaiting ( );

    //Q3IconViewItem *pItem;    //ooo
    QListWidgetItem *pItem;  //xxx
    QImage        *pImage;
    QString        qsFileName;
  };

 public: // public strctures ...
  class TextAttr
  {
  public:
     TextAttr ( ) { backgroundColor=0; foregroundColor=0; };
    ~TextAttr ( ) { };

    QString qsText;
    QFont   font;
    QRgb    backgroundColor; // including transparency
    QRgb    foregroundColor; // including transparency
  };
  class FrameAttr
  {
  public:
     FrameAttr ( ) { iStyle=Qt::SolidLine; iWidth=4; iJoin=Qt::MiterJoin; color=0; };
    ~FrameAttr ( ) { };
    int  iStyle;
    int  iWidth;
    int  iJoin;
    QRgb color;
  };

public:
  //DialogThumbnail ( QDVDAuthor *p=NULL, const char *n=0, Qt::WFlags f=0 );	//ooo
  DialogThumbnail ( QWidget *pParent = 0);					//xxx
  virtual ~DialogThumbnail ( );

  void initSourceFileEntry( SourceFileEntry * );
  void initSourceFileInfo ( SourceFileInfo  *, QString & );
  //void initWork           ( Q3IconViewItem   *, QImage  *, QString ); //ooo
  void initWork           ( QListWidgetItem   *, QImage  *, QString );//xxx
  //bool updateItem         ( Q3IconViewItem   *, QImage  *, QString ); //ooo
  bool updateItem         ( QListWidgetItem   *, QImage  *, QString );   //xxx
  virtual void show           ( );

  static TextAttr  *textAttr  ( );
  static FrameAttr *frameAttr ( );

protected slots:
  virtual void slotFont          ( );
  virtual void slotFrame         ( );
  virtual void slotReload        ( );
  virtual void slotRefresh       ( );
  virtual void slotSizePressed   ( );
  virtual void slotSizeReleased  ( );
  virtual void slotSpaceReleased ( );
  virtual void slotTextType      ( int );
  virtual void slotSizeChanged   ( int );
  virtual void slotSpaceChanged  ( int );
  //virtual void slotChapterChanged( Q3ListBoxItem * ); //ooo
  virtual void slotChapterChanged( QListWidgetItem * );   //xxx

protected:
  virtual void timerEvent ( QTimerEvent * );

  bool    getBufferedThumbnail        (      );
  void    refresh                     ( bool );
  void    refreshEntry                ( bool );
  //void    setItemText ( Q3IconViewItem *, int );  //ooo
  void    setItemText ( QListWidgetItem *, int );    //xxx
  //QString getChapter  ( Q3IconViewItem *      );  //ooo
  QString getChapter  ( QListWidgetItem *      );    //xxx
  //Q3IconViewItem *createCurrentItem    ( bool );  //ooo
  QListWidgetItem *createCurrentItem    ( bool );    //xxx
  //Q3IconViewItem *createCurrentItem    ( SourceFileInfo *, bool, QString );   //ooo
  QListWidgetItem *createCurrentItem    ( SourceFileInfo *, bool, QString ); //xxx

  // Replacement for SourceFileInfo / SourceFileEntry vars
  bool    haveSource     ( );
  int     chapterCount   ( );
  //void    chapterChanged ( Q3ListBoxItem * ); //ooo
  void    chapterChanged ( QListWidgetItem * ); //xxx
  QString chapter        ( int );
  SourceFileInfo *getInfoFromChapterNumber ( int );
  int             getChapterNumberFromKey  ( QString );

private:
  static TextAttr  m_textAttr;
  static FrameAttr m_frameAttr;

  SourceFileEntry *m_pSourceFileEntry;
  SourceFileInfo  *m_pSourceFileInfo;
  QImage           m_image;
  QString          m_qsActionString;
  uint             m_iProgress;
  uint             m_iCurrentChapter;
  uint             m_iThumbnailStretchMode;
  uint             m_iThumbnailWidth;
  uint             m_iThumbnailHeight;

  int              m_iSliderWidthStart;
  int              m_iSliderHeightStart;
  QList<WorkWaiting *> m_listOfWorkToDo;	//oxx
};

#endif // __DIALOGTHUMBNAIL_H__

