/***************************************************************************
    dvdmenu.h
                             -------------------
                             
    begin                : March 2015
    copyright            : (c) 2015 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
    
  This class generates the command line for dvdauthor.
  Current Version of DVDAUTHOR used is 0.67
  You can find dvdauthor under http://dvdauthor.sourceforge.net/
    
****************************************************************************/

#ifndef MENU_H
#define MENU_H

// For compilation speed ???
#include <QTabWidget>

#include <QDateTime>
//#include <QObject>
#include <QWidget>
#include <QPixmap>
#include <QToolBar>
#include <QMouseEvent>		//xxx

//#include "qdvdauthor.h"	//xxx

#include "rgba.h"
#include "global.h"
#include "xml_dvdauthor.h"
#include "dialogrenderpreview.h"	//xxx

#define VMGM_LABEL "Main Menu VMGM"

class QGridLayout;
class QDomElement;
class QDomNode;
class QTimer;

class MenuPreview;
class MovieObject;
class ButtonObject;
class UndoBuffer;
class SourceFileEntry;
class SourceFileInfo;
class StructureItem;
class Audio;

// Container class to encapsulate all variables for the DVDMenu - class
class CDVDMenuInterface
{
public:
  CDVDMenuInterface ();
  ~CDVDMenuInterface ();
  void initMe ();
  
  enum { StretchToFit = 0, StretchBlackBorders, StretchCutOff };

  bool writeProjectFile ( QDomElement & );
  bool readProjectFile  ( QDomNode &, float );
  CDVDMenuInterface & operator = ( CDVDMenuInterface & );
  bool operator == ( CDVDMenuInterface & );
  
  // variables.
  bool bModified;
  bool bIsSubMenu;
  QString qsMenuName;
  QList<Audio *>listSoundEntries; // Note, Audio::fileName == DisplayName of the SourceFileEntry		//oxx

  // the following entries belong to the movie background
  QString qsMovieFileName;
  bool    bMovieBackgroundHasSound;
  QTime   timeOffset;
  QTime   timeDuration;
  // The following var is the background image or screenshot of the Movie ...
  QString qsBackgroundFileName;
  
  QString qsSelectedMaskFileName;
  QString qsHighlightedMaskFileName;
  QString qsResizeAlgo;
  QString qsAnimation;
  int     iStretchType;	// StretchToFit, BlackBorders, CutOffset
  QSize   posOffset;
  int     iFormat;
  int     iWidth;
  int     iHeight;
  int     iTitleset;
  int     iMenu;
  QString qsRatio;
  
  // generated by importdvdauthor.cpp::buildMenuFromPgc()
  // Note vob_struct.pause == "[multi|once]" is used as flag if once or all the time.
  QList <CXmlDVDAuthor::vob_struct *>listIntroVobs;	//ooo
  QList <CXmlDVDAuthor::vob_struct *>listExtroVobs;	//ooo
  QString qsPre;
  QString qsPause;
  QString qsPost;
  
  QPixmap backgroundImage;
  QPixmap highlightedMask;
  QPixmap selectedMask;
  Rgba    pgcColors[MAX_MASK_COLORS];
};

//class DVDMenu : public QObject  //ooo
class DVDMenu : public QWidget  //xxx
{
  Q_OBJECT
protected:
  DVDMenu ();	//ooo
public:
  // Constructor / destructor
  //DVDMenu ( QDVDAuthor * );	//ooo
  DVDMenu ( QDVDAuthor */*parent = 0*/ );
  virtual ~DVDMenu ( );
  
  //bool createContextMenu  ( QPoint);	//xxx

public slots:
  virtual void slotAddBackground       ( );
  virtual void slotAddSound            ( );
  virtual void slotDroppedSomething    ( uint );
  virtual void slotCreatedMovieObject  ( MovieObject *, bool );
  virtual void slotUpdateStructure     ( );
  virtual void slotRequestSourceFiles  ( );
  virtual void slotRequestSubMenus     ( );
  virtual void slotMaskColorChanged    ( Rgba, Rgba );
  virtual void slotVisibleRegion       ( bool );
  virtual void slotRenderFrame         ( );
  virtual void slotEditTimeline        ( );
  virtual void slotBackgroundFromDialog( long );

public:  // public functions
  bool readProjectFile  (QDomNode &, float );
  bool writeProjectFile (QDomElement &);
  
  CDVDMenuInterface *getInterface   ( );
  StructureItem *createStructure    ( StructureItem * );
  QDVDAuthor *getDVDAuthor          ( );
  QList<ButtonObject *>        &getButtons          ( );				//oxx
  QList<MovieObject *>         &getMovieObjects     ( );				//ooo
  QList<SourceFileEntry *>     &getSourceFileEntries( bool b=true );
  QList<SourceFileInfo *>      &getSourceFileInfos  ( );
  SourceFileEntry    *getEntryFromButtonAction ( QString & );
  SourceFileInfo     *getInfoFromButtonAction  ( QString & );
  DVDMenu            *getMenuFromButtonAction  ( QString & );
  UndoBuffer  *getUndoBuffer        ( );
  MenuPreview *getMenuPreview       ( );
  void    updateDVDMenu             ( bool b=true );
  QString checkDuration             ( );
  QString checkDuration             ( bool &, bool & );
  QString name                      ( );
  Rgba    getColor                  ( int );
  DVDMenu *clone                    ( );
  void    updateDVDMenu             ( QString );
  void    createMask                ( QString &, int, bool b=false );
  void    setTabLabel               ( QString & );
  int     getFormat                 ( int iWidth, int iHeight );
  void    appendSourceFileEntry     ( SourceFileEntry * );
  void    removeSourceFileEntry     ( SourceFileEntry * );
  void    removeSourceEntry         ( QString & );
  void    removeBackgroundAudio     ( QString &, bool );
  bool    isSourceEntryUsed         ( QString & );
  void    replaceSourceDisplayName  ( QString &, QString & );
  void    replaceMenuName           ( QString &, QString & );
  void    modifyColor               ( uint, Rgba, bool b=false );
  void    refresh                   ( );
  void    createTransitionsXml      ( );
  bool    isMovieMenu               ( );
  bool    isEmpty                   ( );
  long    framesToRender            ( );
  float   fps                       ( );
  void    renderMenu                ( );
  void    changeSize                ( );
  void    initBackground            ( QString & );
  QString checkButtonsOverlapping   ( );
  
protected: // Private functions ...
  void    addBackground             ( QString &, QString *p=NULL, bool b=false );
  void    readBackgroundFile        ( QString & );
  //void    CreateTab                 (  );			//xxx
  void    CreateTab                 ( QTabWidget * );		//ooo

protected:
  // helper functions ...
  void setMask (QString &, uint);
  void displayMask (uint);
  
protected:
  QWidget	*m_pDVDMenuTab;
  QGridLayout	*m_pTabLayout;
  QGridLayout	*m_pLayout1;
  QGridLayout	*m_pLayout3;
  MenuPreview	*m_pPixmapMenu;
  
  CDVDMenuInterface m_DVDMenuInterface;
  StructureItem    *m_pStructureItem;
  
  QPixmap m_highlightedMask;
  QPixmap m_selectedMask;
  DialogRenderPreview *m_pDialogRenderPreview;		//xxx
  long m_iTotalFramesToRender;
  long m_iCurrentFrameToRender;
  
  //void mousePressEvent	   	( QMouseEvent * );	//xxx
  //void mouseReleaseEvent	( QMouseEvent * );	//xxx
};

class VMGMenu : public DVDMenu
{
  Q_OBJECT
  VMGMenu ();		//ooo
public:
  VMGMenu ( QDVDAuthor *pDVDAuthor );		//ooo
  //VMGMenu ( );
  ~VMGMenu ();
  
private:
  void CreateToolBar (QDVDAuthor *pDVDAuthor);
  void CreateMenuEntry (QDVDAuthor *pDVDAuthor);
private:
  /*QAction *m_pActionCreateDVD;
  QAction *m_pActionAddAudio;
  QAction *m_pActionAddBackgrnd;
  QAction *m_pActionAddVideo;   //xxx
  QAction *m_pActionAddSlide;
  QAction *m_pActionAddMenuSlide;*/ //ooo
  QAction *m_pActionToolbarCreateDVD;
  QAction *m_pActionToolbarAddBackgrnd;
  QAction *m_pActionToolbarAddVideo;    //xxx  
  QAction *m_pActionToolbarAddAudio;
  QAction *m_pActionToolbarAddSlide;
  QAction *m_pActionToolbarAddMenuSlide;
  
  QAction *m_pActionAddBackground;

  QToolBar   *m_pToolBar;
  //QPopupMenu *m_pDVDMenuMenu; //ooo
  QMenu *m_pDVDMenuMenu;    //xxx
};

#endif // MENU_H

