/***************************************************************************
    importchapter.cpp
                             -------------------
                             
    begin                : March 2015
    copyright            : (c) 2015 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
    
   This file holds the implementation of the import filter for the chapter 
   markers.
    
****************************************************************************/

#include <qfile.h>
#include <qobject.h>
//#include <q3filedialog.h> //ooo
#include <QFileDialog>  //xxx
//Added by qt3to4:
//#include <Q3TextStream>   //ooo
#include <QTextStream>  //xxx

#include "global.h"
#include "utils.h"
#include "importchapter.h"

namespace Import
{

Chapter::Chapter ( )
{
}

Chapter::~Chapter ( )
{
}

bool Chapter::import ()
{
  //QString qsImportFile = Q3FileDialog::getOpenFileName ( Global::qsCurrentPath, QObject::tr("Chapter files (*.chapter *.CHAPTER *.xml *.XML *.txt *.TXT)"), NULL, QObject::tr("Open Chapter File") ); //ooo
  QString qsImportFile = QFileDialog::getOpenFileName(NULL, QObject::tr ( "Open Chapter File" ), Global::qsCurrentPath, QObject::tr("Chapter files (*.chapter *.CHAPTER *.xml *.XML *.txt *.TXT)"));					//xxx  

  // Sanity check .. Did te user choose a new project file ?
  if ( qsImportFile.isNull ( ) )
    return false;

  return readFile ( qsImportFile );
}

bool Chapter::readFile ( QString &fileName )
{
  // Assign the file
  int      t, iType = -1;
  Utils       theUtils;
  QString     line;
  QStringList chapterList;

  QFile projectFile ( fileName );
  if ( ! projectFile.open ( QIODevice::ReadOnly ) )
    return false;
  
  //Q3TextStream chapterStream ( &projectFile );    //ooo
  QTextStream chapterStream ( &projectFile );   //xxx
  // 1 ) 0,0:0:14.0,0:0:22.0
  // 2 ) 00:00:00:00  -> DVDLab  style
  // 3 ) 00:00:00.000 -> Default style

  do {
    line  = chapterStream.readLine ( );
    // here we decide which version we have...
    if ( iType == -1 ) {
      //if ( line.find ( ',' ) > -1 )   //ooo
      if ( line.indexOf ( ',' ) > -1 )  //xxx
	iType = 1; // 0,0:0:14.0,0:0:22.0
      else if ( line.contains ( ':' ) == 3 )
	iType = 2; // 00:00:00:00
      //else if ( line.find ( '.' ) > -1 )  //ooo
      else if ( line.indexOf ( '.' ) > -1 ) //xxx
	iType = 3; // 00:00:00.000
      else if ( line.contains ( ':' ) == 2 )
	iType = 3; // 00:00:00
      else {
	line = chapterStream.readLine ( );
	continue;
      }
    }

    if ( 1 == iType ) {
      //QStringList temp = QStringList::split ( ',', line );  //ooo
      QStringList temp = line.split ( ',' );    //xxx
      for ( t=0; t<(int)temp.count ( ); t++ )
	chapterList.append ( theUtils.formatChapter ( temp[t] ) );
    }
	else if ( 2 == iType )  {
		if ( line.contains   ( ':' ) == 3 )  {
			//t = line.findRev ( ':' );  //ooo
            t = line.lastIndexOf ( ':' );   //xxx
			line[t] = '.';
		}
		chapterList.append ( theUtils.formatChapter ( line ) );
	}
    else if ( 1  < iType )
      chapterList.append ( theUtils.formatChapter ( line ) );

  } while ( ! chapterStream.atEnd    ( ) );

  projectFile.close ( );
  m_listOfChapters = chapterList;
  return true;
}

QStringList &Chapter::getChapterList ( )
{
  return m_listOfChapters;
}

}; // End of namespace Import
