/****************************************************************************
  ** Import::DVDAuthor
  **
  **   Created : 
  **        by : Varol Okan using kate editor
  ** Copyright : (c) Varol Okan
  **   License : GPL v 2.0
  **
  ****************************************************************************/

#ifndef __IMPORT_DVDAUTHOR_H__
#define __IMPORT_DVDAUTHOR_H__

//#include <q3valuelist.h>	//oxx

class SourceFileEntry;
class CXmlDVDAuthor;
class CXmlSpumux;
class VMGMenu;
class DVDMenu;
class ImageObject;

namespace Import
{

class DVDAuthor
{
public:
   DVDAuthor ( QDVDAuthor * );
  ~DVDAuthor ();
  
  bool                          import               ();
  void                          clear          ( bool );
  QList<DVDMenu *>         takeDVDMenus         ();				//oxx
  VMGMenu                      *takeVMGMenu          ();
  QList<SourceFileEntry *> takeSourceFileEntries();				//oxx
  bool buildFromDVDAuthorXML ( CXmlDVDAuthor *, QList<CXmlSpumux *> &);		//oxx

private:
  bool buildFromVMGM         ( CXmlDVDAuthor::vmgm_struct     * );
  bool buildFromTitleset     ( CXmlDVDAuthor::titleset_struct * );
  bool buildFromMenus        ( CXmlDVDAuthor::menus_struct    *, VMGMenu *p=NULL );
  bool buildMenuFromPgc      ( CXmlDVDAuthor::pgc_struct      *, VMGMenu *p=NULL );
  bool buildButtonFromPgc    ( CXmlDVDAuthor::button_struct   *, DVDMenu * );
  bool buildTitleFromPgc     ( CXmlDVDAuthor::pgc_struct      * );
  bool buildFromTitles       ( CXmlDVDAuthor::titles_struct   * );

  bool buildFromSpumuxXML    ( CXmlSpumux * );
  DVDMenu *findMenuFromSpumux( CXmlSpumux * );
  DVDMenu *findMenuFromSubpicture ( CXmlSpumux::subpictures_struct * );
  DVDMenu *findMenuFromStream( CXmlSpumux::stream_struct * );
  DVDMenu *findMenuFromSpu   ( CXmlSpumux::spu_struct * );
  DVDMenu *addSpuInfoToMenu  ( CXmlSpumux::spu_struct *, DVDMenu * );

  void          validateButtons         ( DVDMenu * );
  ButtonObject *findXMLButtonInList     ( QList<ButtonObject *> &, CXmlSpumux::button_struct * );	//oxx
  ImageObject  *getButtonImageFromLayer ( DVDMenu *, QRect &, QString );
  CXmlSpumux::button_struct *findButtonObjectInArray ( CXmlSpumux::button_struct **, ButtonObject * );

private:
  QDVDAuthor                   *m_pDVDAuthor;
  QList<DVDMenu *>         m_listDVDMenus;		//oxx
  VMGMenu                      *m_pVMGMenu;
  QList<SourceFileEntry *> m_listSourceFileEntries;	//oxx
  int                           m_iCurrentTitleset;
};

}

#endif // __IMPORT_DVDAUTHOR_H__
