/***************************************************************************
    importsub.cpp
                             -------------------
                             
    begin                : March 2015
    copyright            : (c) 2015 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
    
   This file holds the implementation of the import filter for the sub
   subtitles file format as generated by dv2sub ( http://dv2sub.sf.net )
    
****************************************************************************/

#include <qobject.h>
#include <qregexp.h>
//#include <q3filedialog.h>	//ooo
#include <QFileDialog>		//xxx
#include <QTime>		//xxx
//Added by qt3to4:
//#include <Q3TextStream>	//ooo
#include <QTextStream>		//xxx

#include "global.h"
#include "importsub.h"

namespace Import
{

Sub::Sub ()
{
  m_fFPS = 29.97f; // default to NTSC fps
}

Sub::~Sub ()
{
  for (uint t=0;t<(uint)m_listOfEntries.count(); t++)
    delete m_listOfEntries[t];
  m_listOfEntries.clear ();
}

bool Sub::import ( float fFPS )
{
  m_fFPS = fFPS;
  //QString qsImportFile = Q3FileDialog::getOpenFileName ( Global::qsCurrentPath, QObject::tr("Subtitle files (*.sub *.SUB)"), NULL, QObject::tr("Open Subtitles File") );	//ooo
  QString qsImportFile = QFileDialog::getOpenFileName ( NULL, QObject::tr("Open Subtitles File"), Global::qsCurrentPath,  QObject::tr("Subtitle files (*.sub *.SUB)"));		//xxx

  // Sanity check .. Did te user choose a new project file ?
  if (qsImportFile.isNull ())
    return true;

  return readFile ( qsImportFile, fFPS );
}

bool Sub::readFile ( QString &fileName, float fFPS )
{
  m_fFPS = fFPS;
  // Assign the file
  Subtitles::entry *pEntry;
  QString line, qsStart, qsStop, qsSubtitle;
  int     iIndex, cb1, cb2, cb3, cb4;;
  QFile  projectFile ( fileName );
  if ( ! projectFile.open ( QIODevice::ReadOnly ) )
    return false;
  
  //Q3TextStream subStream( &projectFile );	//ooo
  QTextStream subStream( &projectFile );	//xxx

  iIndex = 0;
  line = subStream.readLine ( );
  while ( !subStream.atEnd  ( ) ) {
    //cb1 = line.find ( '{' );		//ooo
    cb1 = line.indexOf ( '{' );		//xxx
    //cb2 = line.find ( '}' );		//ooo
    cb2 = line.indexOf ( '}' );		//xxx
    //cb3 = line.find ( '{', cb2+1 );	//ooo
    cb3 = line.indexOf ( '{', cb2+1 );	//xxx
    //cb4 = line.find ( '}', cb2+1 );	//ooo
    cb4 = line.indexOf ( '}', cb2+1 );  //xxx
    if ( ( cb1 > -1 ) && ( cb2 > -1 ) && ( cb3 > -1 ) && ( cb4 > -1 ) ) {
      qsStart = line.mid ( cb1+1, cb2-cb1-1 );
      qsStop  = line.mid ( cb3+1, cb4-cb3-1 );
      qsSubtitle= line.right ( line.length () - cb4 - 1 );
      if ( ! qsSubtitle.isEmpty ( ) ) {
	pEntry = new Subtitles::entry;
	pEntry->iIndex = iIndex ++;
	pEntry->qsTimeStart = formatTimestamp   ( qsStart );
	pEntry->qsTimeStop  = formatTimestamp   ( qsStop  );
	pEntry->iTimeStart  = getTimeFromString ( pEntry->qsTimeStart );
	pEntry->iTimeStop   = getTimeFromString ( pEntry->qsTimeStop  );
	pEntry->qsText      = qsSubtitle;
	m_listOfEntries.append ( pEntry );
      }
    }
    line = subStream.readLine ( );
  }

  projectFile.close();
  return true;
}

QString Sub::formatTimestamp ( QString &qsFrameNumber )
{
  QString qsTimestamp;
  QTime theTime;
  bool bOkay;
  long iMSeconds;
  int  iFrameNumber = qsFrameNumber.toInt ( &bOkay );
  if ( ! bOkay )
    return qsTimestamp;

  iMSeconds   = (long) ( (float)iFrameNumber / m_fFPS * 1000.0 );
  theTime     = theTime.addMSecs ( iMSeconds );
  qsTimestamp = theTime.toString ( "hh:mm:ss.zzz" );

  return qsTimestamp;
}

long Sub::getTimeFromString ( QString &qsTime )
{
  long  iMSeconds = -1;
  QTime theTime;
  iMSeconds = (long)theTime.msecsTo ( QTime::fromString ( qsTime ) );

  return iMSeconds;
}

}; // End of namespace Import
