/***************************************************************************
    menupreview.h
                             -------------------
                             
    begin                : March 2015
    copyright            : (c) 2015 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
    
   This class generates the command line for dvdauthor.
   Current Version of DVDAUTHOR used is 0.67
   You can find dvdauthor under http://dvdauthor.sourceforge.net/
    
****************************************************************************/

#ifndef MENUPREVIEW_H
#define MENUPREVIEW_H

#define DRAGGED_IMAGE_NAME "draggedImage.png"

#include <QDropEvent>
#include <QMimeData>    //xxx
#include <QMouseEvent>
#include <QDragEnterEvent>

#include "selectionobject.h"		//xxx
#include "buttonpreview.h"
#include "menuobject.h"

//class Q3IconViewItem;   //ooo
//class QListWidgetItem;   //xxx
class QTreeWidgetItem;   //xxx
class ButtonObject;
class DialogButton;
class MovieObject;
class SourceFileEntry;

class MenuPreview : public ButtonPreview
{
  Q_OBJECT
  // m_iCreatreObjectStyle
  enum { TypeNone=0, FrameType, TextType, ImageType, MovieType, CollectionType };
  // m_iPointerState
  enum { StateUnknown=0, StateNormal, StateMoveSelected, StateReadyToCreate, StateCreating, StateSelecting, StateSelected };
public:
  // type of what has dropped on this MenuPreview
  enum { DroppedDontKnow=0, DroppedMovie, DroppedImage, DroppedText, DroppedImageAndText, DroppedMovieAndText, DroppedChapter, DroppedPants };

  //MenuPreview ( QWidget * parent, const char * name = 0, Qt::WindowFlags f = 0 );	//ooo
  MenuPreview ( QWidget * parent = nullptr);							//xxx
  ~MenuPreview ( );
  void clear   ( Rgba * );
  void initMe  ( Rgba * );
  MenuPreview &operator = ( MenuPreview & );
  
  void respondSourceFiles ( QList<SourceFileEntry *> );		//oxx
  void respondSubMenus    ( QStringList );
  
  bool readProjectFile    ( QDomNode    & );
  bool writeProjectFile   ( QDomElement & );
  bool createContextMenu  ( QPoint);
  
  void setIsSubMenu       ( bool );
  MenuObject *readObject  ( QDomNode &objectNode );
  
  void setVisibleRegion   ( bool );
  void setImageButton     ( bool );
  void createAnimationData( QString &, long );	//ooo
  
  void          connectStdSlots ( MenuObject *, bool );
  ButtonObject *defineAsButton  ( MenuObject *, bool b=true );	//oooo
  
  MenuObject *createFrameObject      ( bool b=true );
  MenuObject *createTextObject       ( bool b=true );
  MenuObject *createImageObject      ( bool b=true );
  MenuObject *createMovieObject      ( bool b=true );
  MenuObject *createButtonObject     ( bool b=true );
  
  //int iX;   //xxx
  //int iY;   //xxx
 
public slots:
  virtual void slotAddFrameObject        ( );
  virtual void slotAddTextObject         ( );
  virtual void slotAddImageObject        ( );
  virtual void slotAddMovieObject        ( );
  virtual void slotUpdateStructure       ( );
  virtual void slotUpdatePixmap          ( );
  virtual void slotAddOverlay            ( MenuObject   * );
  virtual void slotAddShadow             ( MenuObject   * );
  virtual void slotDefineAsButton        ( MenuObject   * );
  virtual void slotDeleteObject          ( MenuObject   * );
  virtual void slotUndoObject            ( MenuObject   * );
  virtual void slotModifyObject          ( MenuObject   * );
  virtual void slotUnbutton              ( ButtonObject * );
  virtual void slotCreateButtonDialog    ( ButtonObject * );
  virtual void slotEmitDeleteMe          ( );
  virtual void slotDestroyedButtonDialog ( );
  
signals:
  void signalUpdateStructure    ( );
  void signalRequestSourceFiles ( );
  void signalRequestSubMenus    ( );
  void signalDeleteMe           ( );
  void signalDroppedSomething   ( uint );
  void signalMaskColorChanged   ( Rgba, Rgba );
  void signalCreatedMovieObject ( MovieObject  *, bool );
  
protected:
  virtual void mousePressEvent	   	( QMouseEvent * );
  virtual void mouseReleaseEvent	( QMouseEvent * );
  virtual void mouseMoveEvent 	    ( QMouseEvent * );
  virtual void paintEvent           ( QPaintEvent * );       //xxx

  // Drag'n drop stuff
  virtual void dropEvent      ( QDropEvent      * );
  virtual void dragEnterEvent ( QDragEnterEvent * );
  
  QString &newButtonName ( );
  
private:	// Private functions ...
  MenuObject *insertDraggedObject     ( QDropEvent *, QImage  & );
  MenuObject *insertDraggedImage      ( QDropEvent *, QImage  &, bool b=true );
  MenuObject *insertDraggedMovie      ( QDropEvent *, QImage  &, long i=0, bool b=true );
  MenuObject *insertDraggedThumbnail  ( QDropEvent *, QImage  & );
  //MenuObject *insertDraggedChapter    ( QDropEvent *, Q3IconViewItem * ); //ooo
  //MenuObject *insertDraggedChapter    ( QDropEvent *, QListWidgetItem * );   //xxx
  MenuObject *insertDraggedChapter    ( QDropEvent *, QTreeWidgetItem * );   //xxx
  //void        insertDraggedChapters   ( QDropEvent *, QList<Q3IconViewItem *> & );	//oxx
  //void        insertDraggedChapters   ( QDropEvent *, QList<QListWidgetItem *> & );	//xxx
  void        insertDraggedChapters   ( QDropEvent *, QList<QTreeWidgetItem *> & );	//xxx
  MenuObject *insertDraggedText       ( QDropEvent *, QString &, bool b=true );
  MenuObject *insertDraggedSourceInfo ( QDropEvent *, QImage  & );// ButtonObject

  QString     getMovieFileName        ( MovieObject*, QStringList & );
  void        checkSelection          ( );  
  bool        isAnimationData         ( QString & );
  
private:
  QPixmap m_doubleBuffer;
  int     m_iCreateObjectStyle;  // What object, text, image, frame, or movie ?
  int     m_iPointerState;
  bool    m_bImageButton;        // Should we create ImageButton objects or MovieButtons when dropping ?
  QRect   m_rectCurrentObject;
  bool    m_bIsSubMenu;
  bool    m_bIsMovieMenu;
  Rgba   *m_pPgcColors;
  DialogButton   *m_pDialogButton;	//ooo
  SelectionObject m_selectionObject;	//ooo
  int iX;   //xxx
  int iY;   //xxx
  QMouseEvent *p_Event; //xxx
};

#endif // MENUPREVIEW_H

