/****************************************************************************
** OneClickWizard
**
**   Created : Tue Apr 23 12:09:08 2008
**        by : Varol Okan using Kate
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
**
****************************************************************************/

#ifndef ONECLICKWIZARD_H
#define ONECLICKWIZARD_H

#include <QListWidget>            //xxx

#include "dialogfiles.h"
#include "plugins/interface.h"
//#include "uioneclickwizard.h"		//ooo
#include "ui_uioneclickwizard.h"	//xxx
//Added by qt3to4:
//#include <Q3BoxLayout>    //ooo
#include <QBoxLayout>       //xxx
//#include <Q3ValueList>	//oxx

//class Q3BoxLayout;    //ooo
class QBoxLayout;       //xxx
//class Q3ListBox;  //ooo
class QListWidget;    //xxx
class QScrollArea;              //xxx
class QListWidgetItem;          //xxx

class SourceFileEntry;
class CXmlSlideshow;

namespace Input
{

//class OneClickWizard : public uiOneClickWizard			//ooo
class OneClickWizard : public QWizard, public Ui::uiOneClickWizard	//xxx
{
    Q_OBJECT

    class Group  {
    public:
      Group ( );
      CXmlSlideshow   *pSlideshow;
      SourceFileEntry *pSourceFileEntry;
    };
public:
    //OneClickWizard ( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );	//ooo
    OneClickWizard ( QWidget* parent = 0 );									//xxx
    virtual ~OneClickWizard ( );

    bool initMe ( );

protected:
    int  loadPlugins       ( QString & );
    QString uniqueGroupName( QString );
    void play              ( QString );
    bool loadPlugin        ( uint );
    void deleteGroups      ( );
    void unloadPlugin      ( );
    void checkControls     ( );
    GroupView *addGroup    ( SourceFileEntry * );
    GroupView *addGroup    ( CXmlSlideshow   * );
    void addSourceToGroup  ( GroupView       * );
    void toSourceGroup     ( );
    void groupsToPlugin    ( );
    void createScrollView  ( );

    void sourceFileToPlugin ( Plugin::SourceGroup *, SourceFileEntry * );
    void slideshowToPlugin  ( Plugin::SourceGroup *, CXmlSlideshow   * );

protected slots:
    virtual void accept                 ( );
    virtual void slotHelp               ( );
    virtual void slotBrowseTemp         ( );
    virtual void slotBrowseDVD          ( );
    virtual void slotGroupUp            ( );
    virtual void slotGroupDown          ( );
    virtual void slotGroupDelete        ( );
    virtual void slotGroupRename        ( );
    virtual void slotAddVideos          ( );
    virtual void slotAddImages          ( );
    virtual void slotResizeScrollView   ( );
    virtual void slotCurrentGroup       ( int  );
    virtual void slotChangePlugin       ( int  );
    virtual void slotCreateISO          ( bool );
    virtual void slotBurnDVD            ( bool );
    virtual void slotProjectName        ( const QString & );
    //virtual void slotGroupContextMenu   ( Q3ListViewItem *, const QPoint &, int );    //ooo
    virtual void slotGroupContextMenu   ( QListWidgetItem * );  //xxx
    //virtual void slotSourceToSourceGroup( Q3ListBoxItem  * ); //ooo
    virtual void slotSourceToSourceGroup( QListWidgetItem  * ); //xxx

private:
    QStringList m_listOfPlugins;
    int         m_iCurrentPlugin;
    bool        m_bCanClose;
    bool        m_bChangeProjectPath;

    void       *m_pLibrary;
    destroy_t  *m_pDestroyFunction;
    QWidget    *m_pConfigWidget;
    //Q3ListBox   *m_pVirtualFolderDialog;  //ooo
    QListWidget   *m_pVirtualFolderDialog;  //xxx
    //Q3BoxLayout *m_pLayoutMain;   //ooo
    QBoxLayout *m_pLayoutMain; //xxx
    Plugin::Interface  *m_pPlugin;

    QList<Group *> m_listOfGroups;	//oxx

    // GUI elements in the scroll view
    QToolBox    *m_pToolBoxGroups;
    //Q3ScrollView *m_pScrollView;  //xxx
    QScrollArea *m_pScrollView;       //xxx
};

}; // end namespace Input

#endif // ONECLICKWIZARD_H
