/*****************************************************************************
 ** After the User has selected and grouped all Images, and Videos, we'll have a list of groups.
 **
 ** To create a DVD structure from this list the following information should be provided.
 ** 
 ** General :
 **  - Plugin to use for DVD creation
 **  - type ( NTSC/PAL )
 **  - Max # menu buttons
 **  - Project Name
 **  - temp path 
 **
 ** Group :
 **  - Type ( Slideshow / Videos )
 **  - Name of the Group
 **  - Create Chapter menu(s) -yes/no-
 **  - Date from - to of material within the group
 **  - Source files
 **  - Audio File(s) for Slideshow
 **
 ** Source Files :  ( Slideshow already in VOB + Chapters )
 **  - File Name
 **  - Start Date - End Date
 **
 ** NOTE: Slideshow information is profided as video file(s). 
 **       I.e. The individual images are already converted int VOBs.
 **
 *****************************************************************************/

#ifndef __PLUGIN_SIMPLEDVD_H__
#define __PLUGIN_SIMPLEDVD_H__

//#include <q3valuelist.h>	//oxx
////Added by qt3to4:		//ooo
//#include <Q3HBoxLayout>   //ooo
#include <QHBoxLayout>  //xxx
#include <QLabel>

#include "run.h"
#include "../interface.h"

//#include "ui_uicomplexdvd.h"   //xxx
#include "configwidget.h"   //xxx

class uiControls;
//class Q3ProgressDialog;   //ooo
class QProgressDialog;  //xxx
//class Q3HBoxLayout;   //ooo
class QHBoxLayout;  //xxx
class QRadioButton;
class QLabel;
class QComboBox;
//class Q3GroupBox; //ooo
class QGroupBox;    //xxx

namespace Plugin
{

class ComplexDVD : public Interface   //ooo
//class ComplexDVD : public Interface, public Ui::uiControls   //xxx
{
  Q_OBJECT

  class ScriptGui
  {
    // Container to hold the widgets per script or this plugin
  public:
    //ScriptGui ( Q3GroupBox *, QString, QString , bool, bool, bool );  //ooo
    ScriptGui ( QGroupBox *, QString, QString , bool, bool, bool ); //xxx
    virtual ~ScriptGui ( );

    QString       m_qsScript; // Including absolute path
    QString       m_qsMainLink;
    bool          m_bCategory;
    bool          m_bTheme;
    bool          m_bIsImage;
    //Q3GroupBox    *m_pParent; //ooo
    QGroupBox    *m_pParent;    //xxx

    //Q3HBoxLayout  *m_pLayoutScriptTitle;  //ooo
    QHBoxLayout  *m_pLayoutScriptTitle; //xxx
    QRadioButton *m_pRadioScript;
    QLabel       *m_pLabelScript;
    //Q3HBoxLayout  *m_pLayoutScriptSelection;  //ooo
    QHBoxLayout  *m_pLayoutScriptSelection; //xxx
    QLabel       *m_pLabelScriptCategory;
    QComboBox    *m_pComboScriptCategory;
    QLabel       *m_pLabelScriptTheme;
    QComboBox    *m_pComboScriptTheme;
  };
  class exe : public Run
  {
  public:
             exe ( );
    virtual ~exe ( );

    virtual int  start  ( QStringList *pEnv=0 );
    virtual void stdOut ( QString & );
    QString getOutput ( );
    QString m_qsOutput;
  };

public:
           ComplexDVD ( );
  virtual ~ComplexDVD ( );

  virtual QWidget *getConfigWidget ( QWidget * );
  virtual bool execute ( );

protected slots:
  virtual void slotInitTimer     ( );
  virtual void slotRandomImages  ( bool );
  virtual void slotCheckedScript ( );
  virtual void slotComboCategory ( int );

protected:
  //QString getMenuXML      ( Q3ValueList<SourceGroup *> &, int, int & );	//ooo
  QString getMenuXML      ( QList<SourceGroup *> &, int, int & );		//xxx
  QString getMenuButtons  ( bool, bool, int );
  QString getDuration     ( QString & );
  QRect   scaleScreenshot ( QString  &, int, int );
  QString getImgCmd       ( QString & );
  void    getRandomBackground ( );
  void    createMainMenu      ( );

  int             m_iNrOfMenus;
  //uiControls     *m_pConfigWidget;    //ooo
  ConfigWidget     *m_pConfigWidget;        //xxx
  QList<int> m_listNumberOfImages;	//oxx

private:
  void createFromScript ( QString );

private: // Private data
  QString m_qsScriptsPath; // Path where the scripts should reside.
  QList<ScriptGui *> m_listScriptsGui;		//oxx
  ScriptGui      *m_pActiveGui;
  ComplexDVD::exe m_execute;
}; // end class SimpleDVD

};  // End namespace Plugin

#endif // __PLUGIN_SIMPLEDVD_H__

