/*****************************************************************************
 ** After the User has selected and grouped all Images, and Videos, we'll have a list of groups.
 **
 ** To create a DVD structure from this list the following information should be provided.
 ** 
 ** General :
 **  - Plugin to use for DVD creation
 **  - type ( NTSC/PAL )
 **  - Max # menu buttons
 **  - Project Name
 **  - temp path 
 **
 ** Group :
 **  - Type ( Slideshow / Videos )
 **  - Name of the Group
 **  - Create Chapter menu(s) -yes/no-
 **  - Date from - to of material within the group
 **  - Source files
 **  - Audio File(s) for Slideshow
 **
 ** Source Files :  ( Slideshow already in VOB + Chapters )
 **  - File Name
 **  - Start Date - End Date
 **
 ** NOTE: Slideshow information is profided as video file(s). 
 **       I.e. The individual images are already converted int VOBs.
 **
 *****************************************************************************/

#ifndef __PLUGIN_SIMPLEDVD_H__
#define __PLUGIN_SIMPLEDVD_H__

#include "../interface.h"
//Added by qt3to4:
//#include <Q3ValueList>	//oxx

#include "ui_uisimpledvd.h"   //xxx

namespace Plugin
{

class SimpleDVD : public Interface, public Ui::uiSimpleDVD
{
  Q_OBJECT

public:
           SimpleDVD ( );
  virtual ~SimpleDVD ( );

  virtual QWidget *getConfigWidget ( QWidget * );
  virtual bool execute ( );

protected:
  QString getMenuXML      ( QList<SourceGroup *> &, int, int & );	//oxx
  QRect   scaleScreenshot ( QString  &, int, int );
  QString getMenuButtons  ( bool, bool, int );

  int m_iNrOfMenus;
}; // end class SimpleDVD

};  // End namespace Plugin

#endif // __PLUGIN_SIMPLEDVD_H__
