/****************************************************************************
** vim: ts=4 sw=4 noet
**
** DialogConfigure class
**
**   Created : Tue Sep 21 14:46:17 2010
**        by : Zsolt Branyiczky
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
****************************************************************************/

#include <QtGui>
#include <QMessageBox>  //xxx

#include "dialogconfigure.h"
#include "engines/mediainterface.h"
#include "mediacreator.h"

DialogConfigure::DialogConfigure(QWidget *pParent)
	: QDialog(pParent)
{
	setupUi(this);
    
    connect ( buttonOK,                 SIGNAL ( clicked ( ) ),                  this, SLOT ( accept      ( ) ) );  //xxx
    connect ( buttonCancel,             SIGNAL ( clicked ( ) ),                  this, SLOT ( reject      ( ) ) );  //xxx
    connect ( m_pComboPreferredEngine,  SIGNAL ( activated ( const QString& ) ), this, SLOT ( slotPreferredEngine ( const QString& ) ) );  //xxx
    connect ( m_pButtonEngineSetup,     SIGNAL ( clicked ( ) ),                  this, SLOT ( slotSetupEngine() ) );  //xxx
    connect ( m_pButtonEngineInfo,      SIGNAL ( clicked ( ) ),                  this, SLOT ( slotEngineInfo() ) );  //xxx
}

void DialogConfigure::slotPreferredEngine( const QString &newEngine )
{
	static bool bOneTimeFlag = true;
	MediaCreator::setPreferredEngine (newEngine);
	if (bOneTimeFlag)
		QMessageBox::information (NULL, "Attention", "You have to re-start QPlayer for the changes to take effect.", QMessageBox::Ok);
	bOneTimeFlag = false;
}

//void DialogConfigure::exec()  //ooo
int DialogConfigure::exec()    //xxx
{
	QStringList listEngines = MediaCreator::getAvailableEngines();
	int t=0;
	// Sanity check if the requested engine is supported.
	for (t=0;t<listEngines.count();t++)	{
		//m_pComboPreferredEngine->insertItem (QString (listEngines[t]));		//ooo
		m_pComboPreferredEngine->addItem (QString (listEngines[t]));			//xxx
	}
	//m_pComboPreferredEngine->setCurrentText (MediaCreator::preferredEngine());		//ooo
	int index = m_pComboPreferredEngine->findText(MediaCreator::preferredEngine());		//xxx
	m_pComboPreferredEngine->setCurrentIndex(index);					//xxx
	//QDialog::exec(); //ooo
    return QDialog::exec(); //xxx
}

void DialogConfigure::slotEngineInfo()
{
	QString qsEngineName (m_pComboPreferredEngine->currentText());
	QString qsDescription(MediaCreator::getEngineDescription (qsEngineName));
	qsEngineName += tr(" Description");
	QMessageBox::information (NULL, qsEngineName, qsDescription, QMessageBox::Ok);
}

void DialogConfigure::slotSetupEngine()
{
	MediaInterface *pInterface = (MediaInterface *)m_pMediaInterface;
	if (pInterface)
		pInterface->setupDialog ();
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void DialogConfigure::languageChange()
{
    retranslateUi(this);
}

