/****************************************************************************
** Interface to the GUI.
**
**   Created : Mon May 30 22:48:00 2006
**        by : Varol Okan using xemacs
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
**
****************************************************************************/

#ifndef TEMPLATEDOWNLOAD_H
#define TEMPLATEDOWNLOAD_H

#include <qdom.h>
#include <qimage.h>
//#include <q3urloperator.h>    //ooo
#include <QUrl> //xxx
//Added by qt3to4:
//#include <Q3CString>  //ooo
//#include <Q3PtrList>  //ooo
#include <QListIterator>    //xxx
#include <QProcess>     //xxx
#include <QNetworkAccessManager>    //xxx
#include <QNetworkRequest>  //xxx
#include <QNetworkReply>    //xxx

// the designer created GUI.
//#include "uitemplatedownload.h"	//ooo
#include "ui_uitemplatedownload.h"	//xxx

#define TEMPLATES_DOCTYPE             ""
// Here we define all attributes for the structures.
#define TEMPLATES_TEMPLATES           "Templates"
#define TEMPLATES_ENTRY               "Entry"

#define TEMPLATES_ENTRY_DESCRIPTION   "Description"
#define TEMPLATES_ENTRY_THUMBNAIL     "Thumbnail"
#define TEMPLATES_ENTRY_LOCATION      "Location"

#define TEMPLATES_ATTRIB_NAME         "name"
#define TEMPLATES_ATTRIB_TYPE         "type"
#define TEMPLATES_ATTRIB_SIZE         "size"

//class Q3Process;  //ooo
//class QProcess; //xxx
//class QNetworkAccessManager //xxx

//class TemplateDownload : public uiTemplateDownload				//ooo
class TemplateDownload : public QDialog, public Ui::uiTemplateDownload		//xxx
{
  Q_OBJECT
protected:
  class Xml
  {
  public:
    class Entry {
    public:
       Entry ( );
      ~Entry ( ) { };

      QString qsName;
      QString qsType; // either static, animated or transition
      QString qsDescription;
      QString qsThumbnail;
      int     iThumbnailSize;
      QImage  theThumbnail;
      QString qsLocation;
      int     iLocationSize;
      bool    bSelectedForInstall;
    };

     Xml ( ) { };
    ~Xml ( ) { clear ( ); };

    bool parseXml  ( QString & );

    Entry  *entry  ( int i );
    int entryCount ( ){ return  (int)m_listOfEntries.count(   ); };
    void    clear  ( );

  private:
    //Q3PtrList<Entry> m_listOfEntries; //ooo
    QList<Entry*> m_listOfEntries;   //xxx
  };

public:
	 //TemplateDownload (QWidget * parent=NULL, const char * name = 0, Qt::WFlags f = 0 );		//ooo
	 TemplateDownload (QWidget * pParent = 0);							//xxx
	~TemplateDownload ();

private:
	void resetDialog       ( );
	void parseIndexFile    ( );
	void createThumbnail   ( );
	void createThumbnails  ( );
	bool verifyUrl         ( QString & );
	void displayStatus     ( QString & );
	void installToSystem   ( QString &, bool );
	void lockDialog        ( bool );
	void downloadTemplate  ( int );
	void installTemplates  ( );
	void downloadThumbnail ( int );
	void downloadThumbnails( );
	// For the second tab
	void createSelection   ( );

protected slots:
	virtual void slotConnect  ( );
	virtual void slotNext     ( );
	virtual void slotHelp     ( );
	virtual void slotDownload ( );

	//virtual void slotNetworkStart    ( Q3NetworkOperation * );   //ooo
    virtual void slotNetworkStart    ( QNetworkAccessManager * );   //xxx
	//virtual void slotNetworkFinished ( Q3NetworkOperation * );   //ooo
    virtual void slotNetworkFinished ( QNetworkReply * );   //xxx
	//virtual void slotNetworkData     ( const QByteArray &, Q3NetworkOperation * );   //ooo
    virtual void slotNetworkData     ( );   //xxx
	//virtual void slotNetworkProgress ( int, int, Q3NetworkOperation * ); //ooo
    virtual void slotNetworkProgress ( qint64, qint64 ); //xxx
	virtual void slotReadFromProcess ( );
	virtual void slotProcessExited   ( );
    virtual void slotError ( QNetworkReply::NetworkError ); //xxx

protected:
	QString      m_qsIndexFile; // XML file from server describing available templates.
	//Q3UrlOperator m_Network; //ooo
	QNetworkAccessManager m_Network;    //xxx
	QNetworkReply        *m_reply;   //xxx
	//Q3Process    *m_pNewProcess; //ooo
    QProcess    *m_pNewProcess; //xxx
	//Q3CString     m_bytes;   //ooo
    QString      m_bytes;   //xxx
	int          m_iStage;     // get index.xml, DL thumbnails ...
	int          m_iCurrentEntry;
	long         m_iCurrentBytes;
	long         m_iTotalBytes;
	Xml          m_xml;
};

#endif // TEMPLATEDOWNLOAD_H

