Object.defineProperty(exports, "__esModule", { value: true });
exports.close = exports.flush = exports.captureMinidump = exports.showReportDialog = exports.init = exports.ElectronIntegrations = exports.NodeIntegrations = exports.NetTransport = exports.MainBackend = exports.MainClient = exports.withScope = exports.setUser = exports.setTags = exports.setTag = exports.setExtras = exports.setExtra = exports.setContext = exports.Scope = exports.Hub = exports.getCurrentHub = exports.getHubFromCarrier = exports.configureScope = exports.captureMessage = exports.captureEvent = exports.captureException = exports.addBreadcrumb = exports.addGlobalEventProcessor = exports.Status = exports.Severity = void 0;
var tslib_1 = require("tslib");
var types_1 = require("@sentry/types");
Object.defineProperty(exports, "Severity", { enumerable: true, get: function () { return types_1.Severity; } });
Object.defineProperty(exports, "Status", { enumerable: true, get: function () { return types_1.Status; } });
var core_1 = require("@sentry/core");
Object.defineProperty(exports, "addGlobalEventProcessor", { enumerable: true, get: function () { return core_1.addGlobalEventProcessor; } });
Object.defineProperty(exports, "addBreadcrumb", { enumerable: true, get: function () { return core_1.addBreadcrumb; } });
Object.defineProperty(exports, "captureException", { enumerable: true, get: function () { return core_1.captureException; } });
Object.defineProperty(exports, "captureEvent", { enumerable: true, get: function () { return core_1.captureEvent; } });
Object.defineProperty(exports, "captureMessage", { enumerable: true, get: function () { return core_1.captureMessage; } });
Object.defineProperty(exports, "configureScope", { enumerable: true, get: function () { return core_1.configureScope; } });
Object.defineProperty(exports, "getHubFromCarrier", { enumerable: true, get: function () { return core_1.getHubFromCarrier; } });
Object.defineProperty(exports, "getCurrentHub", { enumerable: true, get: function () { return core_1.getCurrentHub; } });
Object.defineProperty(exports, "Hub", { enumerable: true, get: function () { return core_1.Hub; } });
Object.defineProperty(exports, "Scope", { enumerable: true, get: function () { return core_1.Scope; } });
Object.defineProperty(exports, "setContext", { enumerable: true, get: function () { return core_1.setContext; } });
Object.defineProperty(exports, "setExtra", { enumerable: true, get: function () { return core_1.setExtra; } });
Object.defineProperty(exports, "setExtras", { enumerable: true, get: function () { return core_1.setExtras; } });
Object.defineProperty(exports, "setTag", { enumerable: true, get: function () { return core_1.setTag; } });
Object.defineProperty(exports, "setTags", { enumerable: true, get: function () { return core_1.setTags; } });
Object.defineProperty(exports, "setUser", { enumerable: true, get: function () { return core_1.setUser; } });
Object.defineProperty(exports, "withScope", { enumerable: true, get: function () { return core_1.withScope; } });
var core_2 = require("@sentry/core");
var minimal_1 = require("@sentry/minimal");
var node_1 = require("@sentry/node");
var client_1 = require("./client");
var integrations_1 = require("./integrations");
var net_1 = require("./transports/net");
var client_2 = require("./client");
Object.defineProperty(exports, "MainClient", { enumerable: true, get: function () { return client_2.MainClient; } });
var backend_1 = require("./backend");
Object.defineProperty(exports, "MainBackend", { enumerable: true, get: function () { return backend_1.MainBackend; } });
var net_2 = require("./transports/net");
Object.defineProperty(exports, "NetTransport", { enumerable: true, get: function () { return net_2.NetTransport; } });
var node_2 = require("@sentry/node");
Object.defineProperty(exports, "NodeIntegrations", { enumerable: true, get: function () { return node_2.Integrations; } });
exports.ElectronIntegrations = { Electron: integrations_1.Electron, OnUncaughtException: integrations_1.OnUncaughtException };
/**
 * Init call to node, if no transport is set, we use net of electron
 * @param options ElectronOptions
 */
function init(options) {
    var electronIntegrations = node_1.defaultIntegrations.filter(function (integration) { return integration.name !== 'OnUncaughtException'; });
    if (options.defaultIntegrations === undefined) {
        options.defaultIntegrations = tslib_1.__spreadArray(tslib_1.__spreadArray([], tslib_1.__read(electronIntegrations)), [
            // eslint-disable-next-line @typescript-eslint/unbound-method
            new integrations_1.OnUncaughtException({ onFatalError: options.onFatalError }),
            new integrations_1.Electron(),
        ]);
    }
    core_2.initAndBind(client_1.MainClient, tslib_1.__assign({ transport: net_1.NetTransport }, options));
}
exports.init = init;
/**
 * This function does nothing, call it in the renderer
 */
function showReportDialog() {
    // noop
}
exports.showReportDialog = showReportDialog;
/**
 * Uploads a native crash dump (Minidump) to Sentry.
 *
 * @param path The relative or absolute path to the minidump.
 * @param event Optional event payload to attach to the minidump.
 */
function captureMinidump(path, event) {
    if (event === void 0) { event = {}; }
    minimal_1._callOnClient('captureMinidump', path, event);
}
exports.captureMinidump = captureMinidump;
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
function flush(timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var client;
        return tslib_1.__generator(this, function (_a) {
            client = core_2.getCurrentHub().getClient();
            if (client) {
                return [2 /*return*/, client.flush(timeout)];
            }
            return [2 /*return*/, Promise.reject(false)];
        });
    });
}
exports.flush = flush;
/**
 * A promise that resolves when all current events have been sent.
 * If you provide a timeout and the queue takes longer to drain the promise returns false.
 *
 * @param timeout Maximum time in ms the client should wait.
 */
function close(timeout) {
    return tslib_1.__awaiter(this, void 0, void 0, function () {
        var client;
        return tslib_1.__generator(this, function (_a) {
            client = core_2.getCurrentHub().getClient();
            if (client) {
                return [2 /*return*/, client.close(timeout)];
            }
            return [2 /*return*/, Promise.reject(false)];
        });
    });
}
exports.close = close;
//# sourceMappingURL=index.js.map