import { BaseBackend } from '@sentry/core';
import { Event, EventHint, Scope, Severity } from '@sentry/types';
import { CommonBackend, ElectronOptions } from '../common';
/**
 * We store the IPC interface on window so it's the same for both regular and isolated contexts
 */
declare global {
    interface Window {
        __SENTRY_IPC__: {
            sendScope: (scope: Scope) => void;
            sendEvent: (event: Event) => void;
            pingMain: (success: () => void) => void;
        } | undefined;
    }
}
/** Backend implementation for Electron renderer backends. */
export declare class RendererBackend extends BaseBackend<ElectronOptions> implements CommonBackend<ElectronOptions> {
    /** Creates a new Electron backend instance. */
    constructor(options: ElectronOptions);
    /**
     * @inheritDoc
     */
    eventFromException(exception: any, hint?: EventHint): PromiseLike<Event>;
    /**
     * @inheritDoc
     */
    eventFromMessage(message: string, level?: Severity, hint?: EventHint): PromiseLike<Event>;
    /**
     * @inheritDoc
     */
    sendEvent(event: Event): void;
    /**
     * Attaches IPC methods to window and uses contextBridge when available
     */
    private _hookIPC;
    /**
     * Sends the scope to the main process once it updates.
     */
    private _setupScopeListener;
    /** Returns whether native reports are enabled. */
    private _isNativeEnabled;
    /** Activates the Electron CrashReporter. */
    private _installNativeHandler;
    /** Checks if the main processes is available and logs a warning if not. */
    private _pingMainProcess;
}
//# sourceMappingURL=backend.d.ts.map