/** The git errors which can be parsed from failed git commands. */
export declare enum GitError {
    BadConfigValue = 0,
    SSHKeyAuditUnverified = 1,
    SSHAuthenticationFailed = 2,
    SSHPermissionDenied = 3,
    HTTPSAuthenticationFailed = 4,
    RemoteDisconnection = 5,
    HostDown = 6,
    RebaseConflicts = 7,
    MergeConflicts = 8,
    HTTPSRepositoryNotFound = 9,
    SSHRepositoryNotFound = 10,
    PushNotFastForward = 11,
    BranchDeletionFailed = 12,
    DefaultBranchDeletionFailed = 13,
    RevertConflicts = 14,
    EmptyRebasePatch = 15,
    NoMatchingRemoteBranch = 16,
    NoExistingRemoteBranch = 17,
    NothingToCommit = 18,
    NoSubmoduleMapping = 19,
    SubmoduleRepositoryDoesNotExist = 20,
    InvalidSubmoduleSHA = 21,
    LocalPermissionDenied = 22,
    InvalidMerge = 23,
    InvalidRebase = 24,
    NonFastForwardMergeIntoEmptyHead = 25,
    PatchDoesNotApply = 26,
    BranchAlreadyExists = 27,
    BadRevision = 28,
    NotAGitRepository = 29,
    CannotMergeUnrelatedHistories = 30,
    LFSAttributeDoesNotMatch = 31,
    BranchRenameFailed = 32,
    PathDoesNotExist = 33,
    InvalidObjectName = 34,
    OutsideRepository = 35,
    LockFileAlreadyExists = 36,
    NoMergeToAbort = 37,
    LocalChangesOverwritten = 38,
    UnresolvedConflicts = 39,
    GPGFailedToSignData = 40,
    ConflictModifyDeletedInBranch = 41,
    PushWithFileSizeExceedingLimit = 42,
    HexBranchNameRejected = 43,
    ForcePushRejected = 44,
    InvalidRefLength = 45,
    ProtectedBranchRequiresReview = 46,
    ProtectedBranchForcePush = 47,
    ProtectedBranchDeleteRejected = 48,
    ProtectedBranchRequiredStatus = 49,
    PushWithPrivateEmail = 50,
    ConfigLockFileAlreadyExists = 51,
    RemoteAlreadyExists = 52,
    TagAlreadyExists = 53,
    MergeWithLocalChanges = 54,
    RebaseWithLocalChanges = 55,
    MergeCommitNoMainlineOption = 56,
    UnsafeDirectory = 57,
    PathExistsButNotInRef = 58
}
/** A mapping from regexes to the git error they identify. */
export declare const GitErrorRegexes: {
    [regexp: string]: GitError;
};
/**
 * The error code for when git cannot be found. This most likely indicates a
 * problem with dugite itself.
 */
export declare const GitNotFoundErrorCode = "git-not-found-error";
/** The error code for when the path to a repository doesn't exist. */
export declare const RepositoryDoesNotExistErrorCode = "repository-does-not-exist-error";
