" VIM Syntax file for txr
" Kaz Kylheku <kaz@kylheku.com>

" INSTALL-HOWTO:
"
" 1. Create the directory .vim/syntax in your home directory and
"    put the files txr.vim and tl.vim into this directory.
" 2. In your .vimrc, add this command to associate *.txr, *.tl and *.tlo
"    files with the txr and tl filetypes:
"    :au BufRead,BufNewFile *.txr set filetype=txr | set lisp
"    :au BufRead,BufNewFile *.tl,*.tlo set filetype=tl | set lisp
"
" If you want syntax highlighting to be on automatically (for any language)
" you need to add ":syntax on" in your .vimrc also. But you knew that already!
"
" This file is generated by the genvim.txr script in the TXR source tree.

syn case match
syn spell toplevel

setlocal iskeyword=a-z,A-Z,48-57,!,$,%,&,*,+,-,<,=,>,?,\\,_,~,/,^

syn keyword tl_keyword contained %e% %fun% %pi% *
syn keyword tl_keyword contained *args* *args-eff* *args-full* *child-env*
syn keyword tl_keyword contained *doc-url* *filters* *full-args* *gensym-counter*
syn keyword tl_keyword contained *hash-seed* *lib-version* *listener-greedy-eval-p* *listener-hist-len*
syn keyword tl_keyword contained *listener-multi-line-p* *listener-pprint-p* *listener-sel-inclusive-p* *load-hooks*
syn keyword tl_keyword contained *load-path* *load-search-dirs* *match-macro* *opt-level*
syn keyword tl_keyword contained *package* *package-alist* *param-macro* *place-clobber-expander*
syn keyword tl_keyword contained *place-delete-expander* *place-macro* *place-update-expander* *pprint-flo-format*
syn keyword tl_keyword contained *print-base* *print-circle* *print-flo-digits* *print-flo-format*
syn keyword tl_keyword contained *print-flo-precision* *print-json-format* *random-state* *random-warmup*
syn keyword tl_keyword contained *read-bad-json* *read-unknown-structs* *rec-source-loc* *stddebug*
syn keyword tl_keyword contained *stderr* *stdin* *stdlog* *stdnull*
syn keyword tl_keyword contained *stdout* *struct-clause-expander* *trace-output* *tree-fun-whitelist*
syn keyword tl_keyword contained *txr-version* *unhandled-hook* + -
syn keyword tl_keyword contained / /= : :abandoned
syn keyword tl_keyword contained :abs :addr :all :android
syn keyword tl_keyword contained :apf :append :args :atime
syn keyword tl_keyword contained :auto :awk-again :awk-file :awk-rec
syn keyword tl_keyword contained :begin :begin-file :blksize :blocks
syn keyword tl_keyword contained :bool :byte-oriented :cdigit :chars
syn keyword tl_keyword contained :cint :close :continue :counter
syn keyword tl_keyword contained :cspace :ctime :cword-char :cygnal
syn keyword tl_keyword contained :cygwin :dec :decline :delegate
syn keyword tl_keyword contained :dev :digit :downcase :end
syn keyword tl_keyword contained :end-file :env :eq-based :eql-based
syn keyword tl_keyword contained :equal-based :explicit-no :fallback :fd
syn keyword tl_keyword contained :fence :fields :filter :fini
syn keyword tl_keyword contained :finish :float :form :from-current
syn keyword tl_keyword contained :from-end :from-start :from_html :frombase64
syn keyword tl_keyword contained :frombase64url :fromhtml :frompercent :fromurl
syn keyword tl_keyword contained :fun :function :gap :gid
syn keyword tl_keyword contained :greedy :hex :hextoint :inf
syn keyword tl_keyword contained :inherit :init :ino :inp
syn keyword tl_keyword contained :inputs :instance :into :key
syn keyword tl_keyword contained :let :lfilt :lines :linux
syn keyword tl_keyword contained :list :lists :local :longest
syn keyword tl_keyword contained :macos :mandatory :mass-delegate :match
syn keyword tl_keyword contained :maxgap :maxtimes :method :mid
syn keyword tl_keyword contained :mingap :mintimes :mode :mtime
syn keyword tl_keyword contained :name :named :next-spec :nlink
syn keyword tl_keyword contained :noclose :nothrow :oct :openbsd
syn keyword tl_keyword contained :outf :outp :output :owner
syn keyword tl_keyword contained :perms :postfini :postinit :prio
syn keyword tl_keyword contained :rdev :real-time :reflect :repeat-spec
syn keyword tl_keyword contained :resolve :rfilt :set :set-file
syn keyword tl_keyword contained :shortest :size :solaris :solaris10
syn keyword tl_keyword contained :space :standard :static :str
syn keyword tl_keyword contained :string :symacro :symlinks :text
syn keyword tl_keyword contained :times :tlist :to_html :tobase64
syn keyword tl_keyword contained :tobase64url :tofloat :tohtml :tohtml*
syn keyword tl_keyword contained :toint :tonumber :topercent :tourl
syn keyword tl_keyword contained :uid :unknown :upcase :use
syn keyword tl_keyword contained :use-from :use-syms :userdata :var
syn keyword tl_keyword contained :vars :weak-and :weak-keys :weak-or
syn keyword tl_keyword contained :weak-vals :whole :word-char :wrap
syn keyword tl_keyword contained < <= = >
syn keyword tl_keyword contained >= abort abs abs-path-p
syn keyword tl_keyword contained acons acons-new aconsql-new acos
syn keyword tl_keyword contained acosh add-suffix ado af-inet
syn keyword tl_keyword contained af-inet6 af-unix af-unspec ai-addrconfig
syn keyword tl_keyword contained ai-all ai-canonname ai-numerichost ai-numericserv
syn keyword tl_keyword contained ai-passive ai-v4mapped alet align
syn keyword tl_keyword contained alignof alist-nremove alist-remove all
syn keyword tl_keyword contained allocate-struct and andf ap
syn keyword tl_keyword contained apf append append* append-each
syn keyword tl_keyword contained append-each* append-each-prod append-each-prod* append-match-products
syn keyword tl_keyword contained append-matches apply aret array
syn keyword tl_keyword contained arraysize ash asin asinh
syn keyword tl_keyword contained assert assoc assq assql
syn keyword tl_keyword contained at-exit-call at-exit-do-not-call atan atan2
syn keyword tl_keyword contained atanh atom awk base-name
syn keyword tl_keyword contained base64-decode base64-decode-buf base64-encode base64-stream-dec
syn keyword tl_keyword contained base64-stream-enc base64url-decode base64url-decode-buf base64url-encode
syn keyword tl_keyword contained base64url-stream-dec base64url-stream-enc bchar be-double
syn keyword tl_keyword contained be-float be-int16 be-int32 be-int64
syn keyword tl_keyword contained be-uint16 be-uint32 be-uint64 bignum-len
syn keyword tl_keyword contained bignump bindable bit bitset
syn keyword tl_keyword contained blkcnt-t blksize-t block block*
syn keyword tl_keyword contained bool boundp bracket break-str
syn keyword tl_keyword contained brkint bs0 bs1 bsdly
syn keyword tl_keyword contained bstr bstr-d bstr-s buf
syn keyword tl_keyword contained buf-alloc-size buf-carray buf-compress buf-d
syn keyword tl_keyword contained buf-decompress buf-get-char buf-get-cptr buf-get-double
syn keyword tl_keyword contained buf-get-float buf-get-i16 buf-get-i32 buf-get-i64
syn keyword tl_keyword contained buf-get-i8 buf-get-int buf-get-long buf-get-short
syn keyword tl_keyword contained buf-get-u16 buf-get-u32 buf-get-u64 buf-get-u8
syn keyword tl_keyword contained buf-get-uchar buf-get-uint buf-get-ulong buf-get-ushort
syn keyword tl_keyword contained buf-int buf-list buf-put-buf buf-put-char
syn keyword tl_keyword contained buf-put-cptr buf-put-double buf-put-float buf-put-i16
syn keyword tl_keyword contained buf-put-i32 buf-put-i64 buf-put-i8 buf-put-int
syn keyword tl_keyword contained buf-put-long buf-put-short buf-put-u16 buf-put-u32
syn keyword tl_keyword contained buf-put-u64 buf-put-u8 buf-put-uchar buf-put-uint
syn keyword tl_keyword contained buf-put-ulong buf-put-ushort buf-set-length buf-str
syn keyword tl_keyword contained buf-trim buf-uint bufp build
syn keyword tl_keyword contained build-list buildn built-in-type-p butlast
syn keyword tl_keyword contained butlastn caaaaar caaaadr caaaar
syn keyword tl_keyword contained caaadar caaaddr caaadr caaar
syn keyword tl_keyword contained caadaar caadadr caadar caaddar
syn keyword tl_keyword contained caadddr caaddr caadr caar
syn keyword tl_keyword contained cadaaar cadaadr cadaar cadadar
syn keyword tl_keyword contained cadaddr cadadr cadar caddaar
syn keyword tl_keyword contained caddadr caddar cadddar caddddr
syn keyword tl_keyword contained cadddr caddr cadr call
syn keyword tl_keyword contained call-clobber-expander call-delete-expander call-finalizers call-super-fun
syn keyword tl_keyword contained call-super-method call-update-expander callf car
syn keyword tl_keyword contained carray carray-blank carray-buf carray-buf-sync
syn keyword tl_keyword contained carray-cptr carray-dup carray-free carray-get
syn keyword tl_keyword contained carray-getz carray-int carray-list carray-own
syn keyword tl_keyword contained carray-pun carray-put carray-putz carray-ref
syn keyword tl_keyword contained carray-refset carray-replace carray-set-length carray-sub
syn keyword tl_keyword contained carray-type carray-uint carray-vec carrayp
syn keyword tl_keyword contained caseq caseq* caseql caseql*
syn keyword tl_keyword contained casequal casequal* cat-files cat-str
syn keyword tl_keyword contained cat-streams cat-vec catch catch*
syn keyword tl_keyword contained catch** catenated-stream-p catenated-stream-push cbaud
syn keyword tl_keyword contained cbaudex cdaaaar cdaaadr cdaaar
syn keyword tl_keyword contained cdaadar cdaaddr cdaadr cdaar
syn keyword tl_keyword contained cdadaar cdadadr cdadar cdaddar
syn keyword tl_keyword contained cdadddr cdaddr cdadr cdar
syn keyword tl_keyword contained cddaaar cddaadr cddaar cddadar
syn keyword tl_keyword contained cddaddr cddadr cddar cdddaar
syn keyword tl_keyword contained cdddadr cdddar cddddar cdddddr
syn keyword tl_keyword contained cddddr cdddr cddr cdr
syn keyword tl_keyword contained ceil ceil-rem chain chand
syn keyword tl_keyword contained char chdir chmod chmod-rec
syn keyword tl_keyword contained chown chown-rec chr-digit chr-int
syn keyword tl_keyword contained chr-isalnum chr-isalpha chr-isascii chr-isblank
syn keyword tl_keyword contained chr-iscntrl chr-isdigit chr-isgraph chr-islower
syn keyword tl_keyword contained chr-isprint chr-ispunct chr-isspace chr-isunisp
syn keyword tl_keyword contained chr-isupper chr-isxdigit chr-num chr-str
syn keyword tl_keyword contained chr-str-set chr-tolower chr-toupper chr-xdigit
syn keyword tl_keyword contained chrp clamp clear-dirty clear-error
syn keyword tl_keyword contained clear-mask clear-struct clearhash clocal
syn keyword tl_keyword contained clock-t clockid-t close close-lazy-streams
syn keyword tl_keyword contained close-stream closedir closelog closure
syn keyword tl_keyword contained cmp-str cmspar coded-length collect-each
syn keyword tl_keyword contained collect-each* collect-each-prod collect-each-prod* comb
syn keyword tl_keyword contained command-get command-get-buf command-get-json command-get-jsons
syn keyword tl_keyword contained command-get-lines command-get-string command-put command-put-buf
syn keyword tl_keyword contained command-put-json command-put-jsons command-put-lines command-put-string
syn keyword tl_keyword contained compare-swap compile compile-defr-warning compile-error
syn keyword tl_keyword contained compile-file compile-only compile-toplevel compile-update-file
syn keyword tl_keyword contained compile-warning compl-span-str cond conda
syn keyword tl_keyword contained condlet cons conses conses*
syn keyword tl_keyword contained consp constantp contain[s] copy
syn keyword tl_keyword contained copy-alist copy-buf copy-carray copy-cons
syn keyword tl_keyword contained copy-cptr copy-file copy-files copy-fun
syn keyword tl_keyword contained copy-hash copy-list copy-path-rec copy-search-tree
syn keyword tl_keyword contained copy-str copy-struct copy-tnode copy-tree
syn keyword tl_keyword contained copy-tree-iter copy-vec cos cosh
syn keyword tl_keyword contained count count-if count-until-match countq
syn keyword tl_keyword contained countql countqual cptr cptr-buf
syn keyword tl_keyword contained cptr-carray cptr-cast cptr-free cptr-get
syn keyword tl_keyword contained cptr-int cptr-null cptr-obj cptr-out
syn keyword tl_keyword contained cptr-size-hint cptr-type cptr-zap cptrp
syn keyword tl_keyword contained cr0 cr1 cr2 cr3
syn keyword tl_keyword contained crc32 crc32-stream crdly cread
syn keyword tl_keyword contained crtscts crypt cs5 cs6
syn keyword tl_keyword contained cs7 cs8 csize cstopb
syn keyword tl_keyword contained cum-norm-dist cxr cyr daemon
syn keyword tl_keyword contained dec defer-warning defex deffi
syn keyword tl_keyword contained deffi-cb deffi-cb-unsafe deffi-struct deffi-sym
syn keyword tl_keyword contained deffi-type deffi-union deffi-var define-accessor
syn keyword tl_keyword contained define-modify-macro define-option-struct define-param-expander define-place-macro
syn keyword tl_keyword contained define-struct-clause define-struct-prelude defmacro defmatch
syn keyword tl_keyword contained defmeth defpackage defparm defparml
syn keyword tl_keyword contained defplace defset defstruct defsymacro
syn keyword tl_keyword contained defun defun-match defvar defvarl
syn keyword tl_keyword contained del delay delcons delete-package
syn keyword tl_keyword contained dev-t diff digits digpow
syn keyword tl_keyword contained dir-name dirstat disassemble display-width
syn keyword tl_keyword contained divides dlclose dlopen dlsym
syn keyword tl_keyword contained dlsym-checked dlvsym dlvsym-checked do
syn keyword tl_keyword contained doc dohash doloop doloop*
syn keyword tl_keyword contained dotimes double downcase-str drop
syn keyword tl_keyword contained drop-until drop-while dt-blk dt-chr
syn keyword tl_keyword contained dt-dir dt-fifo dt-lnk dt-reg
syn keyword tl_keyword contained dt-sock dt-unknown dump-compiled-objects dump-deferred-warnings
syn keyword tl_keyword contained dup dupfd dwim e2big
syn keyword tl_keyword contained eacces each each* each-false
syn keyword tl_keyword contained each-match each-match-product each-prod each-prod*
syn keyword tl_keyword contained each-true eaddrinuse eaddrnotavail eafnosupport
syn keyword tl_keyword contained eagain ealready ebadf ebadmsg
syn keyword tl_keyword contained ebusy ecanceled ecaseq ecaseq*
syn keyword tl_keyword contained ecaseql ecaseql* ecasequal ecasequal*
syn keyword tl_keyword contained echild echo echoctl echoe
syn keyword tl_keyword contained echok echoke echonl echoprt
syn keyword tl_keyword contained econnaborted econnrefused econnreset edeadlk
syn keyword tl_keyword contained edestaddrreq edom edquot eexist
syn keyword tl_keyword contained efault efbig ehostunreach eidrm
syn keyword tl_keyword contained eighth eilseq einprogress eintr
syn keyword tl_keyword contained einval eio eisconn eisdir
syn keyword tl_keyword contained elemsize elemtype eloop emfile
syn keyword tl_keyword contained emlink empty emsgsize emultihop
syn keyword tl_keyword contained enametoolong endgrent endp endpwent
syn keyword tl_keyword contained ends-with enetdown enetreset enetunreach
syn keyword tl_keyword contained enfile enobufs enodata enodev
syn keyword tl_keyword contained enoent enoexec enolck enolink
syn keyword tl_keyword contained enomem enomsg enoprotoopt enospc
syn keyword tl_keyword contained enosr enostr enosys enotconn
syn keyword tl_keyword contained enotdir enotempty enotrecoverable enotsock
syn keyword tl_keyword contained enotsup enotty ensure-dir enum
syn keyword tl_keyword contained enumed env env-fbind env-fbindings
syn keyword tl_keyword contained env-hash env-next env-vbind env-vbindings
syn keyword tl_keyword contained enxio eopnotsupp eoverflow eownerdead
syn keyword tl_keyword contained eperm epipe eproto eprotonosupport
syn keyword tl_keyword contained eprototype eq eql equal
syn keyword tl_keyword contained equot erange erofs errno
syn keyword tl_keyword contained error espipe esrch estale
syn keyword tl_keyword contained etime etimedout etxtbsy etypecase
syn keyword tl_keyword contained eval eval-only evenp ewouldblock
syn keyword tl_keyword contained exception-subtype-map exception-subtype-p exdev exec
syn keyword tl_keyword contained exit exit* exp expand
syn keyword tl_keyword contained expand* expand-left expand-right expand-with-free-refs
syn keyword tl_keyword contained expt exptmod extproc f$
syn keyword tl_keyword contained f-dupfd f-dupfd-cloexec f-getfd f-getfl
syn keyword tl_keyword contained f-getlk f-rdlck f-setfd f-setfl
syn keyword tl_keyword contained f-setlk f-setlkw f-unlck f-wrlck
syn keyword tl_keyword contained f^ f^$ false fboundp
syn keyword tl_keyword contained fcntl fd-cloexec ff0 ff1
syn keyword tl_keyword contained ffdly ffi ffi-alignof ffi-arraysize
syn keyword tl_keyword contained ffi-call ffi-elemsize ffi-elemtype ffi-get
syn keyword tl_keyword contained ffi-in ffi-make-call-desc ffi-make-closure ffi-offsetof
syn keyword tl_keyword contained ffi-out ffi-put ffi-put-into ffi-size
syn keyword tl_keyword contained ffi-type-compile ffi-type-operator-p ffi-type-p ffi-typedef
syn keyword tl_keyword contained fifth file-append file-append-buf file-append-json
syn keyword tl_keyword contained file-append-jsons file-append-lines file-append-string file-get
syn keyword tl_keyword contained file-get-buf file-get-json file-get-jsons file-get-lines
syn keyword tl_keyword contained file-get-string file-place-buf file-put file-put-buf
syn keyword tl_keyword contained file-put-json file-put-jsons file-put-lines file-put-string
syn keyword tl_keyword contained fileno fill-buf fill-buf-adjust fill-carray
syn keyword tl_keyword contained fill-obj fill-vec filter-equal filter-string-tree
syn keyword tl_keyword contained finalize find find-frame find-frames
syn keyword tl_keyword contained find-frames-by-mask find-if find-max find-max-key
syn keyword tl_keyword contained find-min find-min-key find-package find-struct-type
syn keyword tl_keyword contained find-symbol find-symbol-fb find-true first
syn keyword tl_keyword contained fixnum-max fixnum-min fixnump flatcar
syn keyword tl_keyword contained flatcar* flatten flatten* flet
syn keyword tl_keyword contained flip flipargs flo-dig flo-down
syn keyword tl_keyword contained flo-epsilon flo-get-round-mode flo-int flo-max
syn keyword tl_keyword contained flo-max-dig flo-min flo-near flo-set-round-mode
syn keyword tl_keyword contained flo-str flo-up flo-zero float
syn keyword tl_keyword contained floatp floor floor-rem flow
syn keyword tl_keyword contained flush-stream flusho fmakunbound fmt
syn keyword tl_keyword contained fnm-casefold fnm-extmatch fnm-leading-dir fnm-noescape
syn keyword tl_keyword contained fnm-pathname fnm-period fnmatch for
syn keyword tl_keyword contained for* force force-break fork
syn keyword tl_keyword contained format fourth fr$ fr^
syn keyword tl_keyword contained fr^$ from frr fsblkcnt-t
syn keyword tl_keyword contained fsfilcnt-t fstat ftw ftw-actionretval
syn keyword tl_keyword contained ftw-chdir ftw-continue ftw-d ftw-depth
syn keyword tl_keyword contained ftw-dnr ftw-dp ftw-f ftw-mount
syn keyword tl_keyword contained ftw-ns ftw-phys ftw-skip-siblings ftw-skip-subtree
syn keyword tl_keyword contained ftw-sl ftw-sln ftw-stop fun
syn keyword tl_keyword contained fun-fixparam-count fun-optparam-count fun-variadic func-get-env
syn keyword tl_keyword contained func-get-form func-get-name func-set-env functionp
syn keyword tl_keyword contained gcd gen gen-hash-seed generate
syn keyword tl_keyword contained gensym gequal get-buf-from-stream get-byte
syn keyword tl_keyword contained get-char get-clobber-expander get-delete-expander get-error
syn keyword tl_keyword contained get-error-str get-frames get-hash-userdata get-indent
syn keyword tl_keyword contained get-indent-mode get-json get-jsons get-line
syn keyword tl_keyword contained get-line-as-buf get-lines get-list-from-stream get-obj
syn keyword tl_keyword contained get-sig-handler get-stack-limit get-string get-string-from-stream
syn keyword tl_keyword contained get-update-expander getaddrinfo getegid getenv
syn keyword tl_keyword contained geteuid getgid getgrent getgrgid
syn keyword tl_keyword contained getgrnam getgroups gethash getitimer
syn keyword tl_keyword contained getopts getpid getppid getpwent
syn keyword tl_keyword contained getpwnam getpwuid getresgid getresuid
syn keyword tl_keyword contained getrlimit getuid gid-t ginterate
syn keyword tl_keyword contained giterate glob glob-altdirfunc glob-brace
syn keyword tl_keyword contained glob-err glob-mark glob-nocheck glob-noescape
syn keyword tl_keyword contained glob-nomagic glob-nosort glob-onlydir glob-period
syn keyword tl_keyword contained glob-tilde glob-tilde-check go grade
syn keyword tl_keyword contained greater group-by group-map group-reduce
syn keyword tl_keyword contained gun handle handle* handler-bind
syn keyword tl_keyword contained hash hash-alist hash-begin hash-construct
syn keyword tl_keyword contained hash-count hash-diff hash-eql hash-equal
syn keyword tl_keyword contained hash-from-alist hash-from-pairs hash-invert hash-isec
syn keyword tl_keyword contained hash-keys hash-keys-of hash-list hash-next
syn keyword tl_keyword contained hash-pairs hash-peek hash-proper-subset hash-reset
syn keyword tl_keyword contained hash-revget hash-subset hash-symdiff hash-uni
syn keyword tl_keyword contained hash-update hash-update-1 hash-userdata hash-values
syn keyword tl_keyword contained hash-zip hashp have hlet
syn keyword tl_keyword contained hlet* html-decode html-encode html-encode*
syn keyword tl_keyword contained hupcl iapply icanon icrnl
syn keyword tl_keyword contained id-t identity identity* ido
syn keyword tl_keyword contained iexten if if-match ifa
syn keyword tl_keyword contained iff iffi iflet ignbrk
syn keyword tl_keyword contained igncr ignerr ignpar ignwarn
syn keyword tl_keyword contained imaxbel improper-plist-to-alist in in-package
syn keyword tl_keyword contained in-range in-range* in6addr-any in6addr-loopback
syn keyword tl_keyword contained in6addr-str inaddr-any inaddr-loopback inaddr-str
syn keyword tl_keyword contained inc inc-indent inc-indent-abs indent-code
syn keyword tl_keyword contained indent-data indent-foff indent-off inhash
syn keyword tl_keyword contained inlcr ino-t inpck int
syn keyword tl_keyword contained int-buf int-carray int-chr int-cptr
syn keyword tl_keyword contained int-flo int-ptr-t int-str int16
syn keyword tl_keyword contained int32 int64 int8 integerp
syn keyword tl_keyword contained intern intern-fb interp-fun-p interpose
syn keyword tl_keyword contained intmax-t inv-cum-norm invoke-catch ip
syn keyword tl_keyword contained ipf ipproto-ip ipproto-ipv6 ipproto-tcp
syn keyword tl_keyword contained ipproto-udp ipv6-join-group ipv6-leave-group ipv6-multicast-hops
syn keyword tl_keyword contained ipv6-multicast-if ipv6-multicast-loop ipv6-unicast-hops ipv6-v6only
syn keyword tl_keyword contained iread isatty isec isecp
syn keyword tl_keyword contained isig isqrt istrip iter-begin
syn keyword tl_keyword contained iter-item iter-more iter-reset iter-step
syn keyword tl_keyword contained iterable itimer-prof itimer-real itimer-virtual
syn keyword tl_keyword contained iuclc iutf8 ixany ixoff
syn keyword tl_keyword contained ixon join join-with json
syn keyword tl_keyword contained juxt keep-if keep-if* keep-match-products
syn keyword tl_keyword contained keep-matches keepq keepql keepqual
syn keyword tl_keyword contained key key-t keyword-package keywordp
syn keyword tl_keyword contained kill labels lambda lambda-match
syn keyword tl_keyword contained last lazy-str lazy-str-force lazy-str-force-upto
syn keyword tl_keyword contained lazy-str-get-trailing-list lazy-stream-cons lazy-stringp lchown
syn keyword tl_keyword contained lcm lcons lcons-car lcons-cdr
syn keyword tl_keyword contained lcons-fun lconsp ldiff ldo
syn keyword tl_keyword contained le-double le-float le-int16 le-int32
syn keyword tl_keyword contained le-int64 le-uint16 le-uint32 le-uint64
syn keyword tl_keyword contained left len length length-buf
syn keyword tl_keyword contained length-carray length-list length-str length-str-<
syn keyword tl_keyword contained length-str-<= length-str-> length-str->= length-vec
syn keyword tl_keyword contained lequal less let let*
syn keyword tl_keyword contained lexical-fun-p lexical-lisp1-binding lexical-var-p lib-version
syn keyword tl_keyword contained link lisp-parse list list*
syn keyword tl_keyword contained list-carray list-seq list-str list-vec
syn keyword tl_keyword contained list-vector listp lnew lnew*
syn keyword tl_keyword contained load load-for load-time loff-t
syn keyword tl_keyword contained log log-alert log-auth log-authpriv
syn keyword tl_keyword contained log-cons log-crit log-daemon log-debug
syn keyword tl_keyword contained log-emerg log-err log-info log-ndelay
syn keyword tl_keyword contained log-notice log-nowait log-odelay log-perror
syn keyword tl_keyword contained log-pid log-user log-warning log10
syn keyword tl_keyword contained log2 logand logcount logior
syn keyword tl_keyword contained lognot logtest logtrunc logxor
syn keyword tl_keyword contained long long-suffix longlong lop
syn keyword tl_keyword contained lset lstat lutimes m$
syn keyword tl_keyword contained m^ m^$ mac-env-param-bind mac-param-bind
syn keyword tl_keyword contained macro-ancestor macro-form-p macro-time macroexpand
syn keyword tl_keyword contained macroexpand-1 macroexpand-1-lisp1 macroexpand-1-place macroexpand-lisp1
syn keyword tl_keyword contained macroexpand-match macroexpand-params macroexpand-place macroexpand-struct-clause
syn keyword tl_keyword contained macrolet madv-dodump madv-dofork madv-dontdump
syn keyword tl_keyword contained madv-dontfork madv-dontneed madv-free madv-hugepage
syn keyword tl_keyword contained madv-hwpoison madv-keeponfork madv-mergeable madv-nohugepage
syn keyword tl_keyword contained madv-normal madv-random madv-remove madv-sequential
syn keyword tl_keyword contained madv-unmergeable madv-willneed madv-wipeonfork madvise
syn keyword tl_keyword contained major make-buf make-buf-stream make-byte-input-stream
syn keyword tl_keyword contained make-catenated-stream make-env make-hash make-lazy-cons
syn keyword tl_keyword contained make-lazy-struct make-like make-package make-random-state
syn keyword tl_keyword contained make-similar-hash make-similar-tree make-string-byte-input-stream make-string-input-stream
syn keyword tl_keyword contained make-string-output-stream make-strlist-input-stream make-strlist-output-stream make-struct
syn keyword tl_keyword contained make-struct-delegate-stream make-struct-type make-sym make-time
syn keyword tl_keyword contained make-time-utc make-trie make-union make-zstruct
syn keyword tl_keyword contained makedev makunbound map-anon map-fixed
syn keyword tl_keyword contained map-growsdown map-huge-mask map-huge-shift map-hugetlb
syn keyword tl_keyword contained map-locked map-nonblock map-noreserve map-populate
syn keyword tl_keyword contained map-private map-shared map-stack mapcar
syn keyword tl_keyword contained mapcar* mapdo mapf maphash
syn keyword tl_keyword contained mappend mappend* maprend maprod
syn keyword tl_keyword contained maprodo mask match match-case
syn keyword tl_keyword contained match-ecase match-error match-fboundp match-fun
syn keyword tl_keyword contained match-regex match-regex-right match-regst match-regst-right
syn keyword tl_keyword contained match-str match-str-tree max mboundp
syn keyword tl_keyword contained md5 md5-begin md5-end md5-hash
syn keyword tl_keyword contained md5-stream member member-if memp
syn keyword tl_keyword contained memq memql memqual meq
syn keyword tl_keyword contained meql mequal merge merge-delete-package
syn keyword tl_keyword contained meth method min minor
syn keyword tl_keyword contained minusp mismatch mkdir mkdtemp
syn keyword tl_keyword contained mkfifo mknod mkstemp mkstring
syn keyword tl_keyword contained mlet mmakunbound mmap mod
syn keyword tl_keyword contained mode-t mprotect ms-async ms-invalidate
syn keyword tl_keyword contained ms-sync msync mul-each mul-each*
syn keyword tl_keyword contained mul-each-prod mul-each-prod* multi multi-sort
syn keyword tl_keyword contained munmap n-choose-k n-perm-k nand
syn keyword tl_keyword contained nandf nconc neg neq
syn keyword tl_keyword contained neql nequal new new*
syn keyword tl_keyword contained nexpand-left nil nilf ninth
syn keyword tl_keyword contained nl0 nl1 nldly nlink-t
syn keyword tl_keyword contained noflsh none nor norf
syn keyword tl_keyword contained not notf nreconc nreverse
syn keyword tl_keyword contained nrot nshuffle nsort nth
syn keyword tl_keyword contained nthcdr nthlast null nullify
syn keyword tl_keyword contained num-chr num-str numberp nzerop
syn keyword tl_keyword contained o-accmode o-append o-async o-cloexec
syn keyword tl_keyword contained o-creat o-direct o-directory o-noatime
syn keyword tl_keyword contained o-noctty o-nofollow o-nonblock o-path
syn keyword tl_keyword contained o-rdonly o-rdwr o-sync o-trunc
syn keyword tl_keyword contained o-wronly oand obtain obtain*
syn keyword tl_keyword contained obtain*-block obtain-block ocrnl oddp
syn keyword tl_keyword contained ofdel off-t offsetof ofill
syn keyword tl_keyword contained olcuc onlcr onlret onocr
syn keyword tl_keyword contained op open-command open-directory open-file
syn keyword tl_keyword contained open-fileno open-files open-files* open-pipe
syn keyword tl_keyword contained open-process open-socket open-socket-pair open-subprocess
syn keyword tl_keyword contained open-tail opendir openlog opip
syn keyword tl_keyword contained opost opt opthelp opthelp-conventions
syn keyword tl_keyword contained opthelp-types or orf pack
syn keyword tl_keyword contained package-alist package-fallback-list package-foreign-symbols package-local-symbols
syn keyword tl_keyword contained package-name package-symbols packagep pad
syn keyword tl_keyword contained page-size pairlis parenb parmrk
syn keyword tl_keyword contained parodd parse-errors partition partition*
syn keyword tl_keyword contained partition-by partition-if path-blkdev-p path-cat
syn keyword tl_keyword contained path-chrdev-p path-components-safe path-dir-empty path-dir-p
syn keyword tl_keyword contained path-equal path-executable-to-me-p path-exists-p path-file-p
syn keyword tl_keyword contained path-mine-p path-my-group-p path-newer path-older
syn keyword tl_keyword contained path-pipe-p path-private-to-me-p path-read-writable-to-me-p path-readable-to-me-p
syn keyword tl_keyword contained path-safe-sticky-dir path-same-object path-search path-sep-chars
syn keyword tl_keyword contained path-setgid-p path-setuid-p path-sock-p path-sticky-p
syn keyword tl_keyword contained path-strictly-private-to-me-p path-symlink-p path-writable-to-me-p pdec
syn keyword tl_keyword contained pendin perm pic pid-t
syn keyword tl_keyword contained pinc pipe place-form-p placelet
syn keyword tl_keyword contained placelet* plist-to-alist plusp poll
syn keyword tl_keyword contained poll-err poll-in poll-nval poll-out
syn keyword tl_keyword contained poll-pri poll-rdband poll-rdhup poll-wrband
syn keyword tl_keyword contained poly pop pop-after-load portable-abs-path-p
syn keyword tl_keyword contained pos pos-if pos-max pos-min
syn keyword tl_keyword contained posq posql posqual pppred
syn keyword tl_keyword contained ppred pprinl pprint pprof
syn keyword tl_keyword contained pred prinl print prod
syn keyword tl_keyword contained prof prog prog* prog1
syn keyword tl_keyword contained prog2 progn promisep prop
syn keyword tl_keyword contained proper-list-p proper-listp prot-exec prot-growsdown
syn keyword tl_keyword contained prot-growsup prot-none prot-read prot-write
syn keyword tl_keyword contained pset ptr ptr-in ptr-in-d
syn keyword tl_keyword contained ptr-out ptr-out-d ptr-out-s ptrdiff-t
syn keyword tl_keyword contained pub:txr-sym pure-rel-path-p purge-deferred-warning push
syn keyword tl_keyword contained push-after-load pushhash pushnew put-buf
syn keyword tl_keyword contained put-byte put-carray put-char put-json
syn keyword tl_keyword contained put-jsonl put-jsons put-line put-lines
syn keyword tl_keyword contained put-obj put-string put-strings pwd
syn keyword tl_keyword contained qquote qref quantile quip
syn keyword tl_keyword contained quote r$ r^ r^$
syn keyword tl_keyword contained raise rand random random-buf
syn keyword tl_keyword contained random-fixnum random-float random-float-incl random-sample
syn keyword tl_keyword contained random-state-get-vec random-state-p range range*
syn keyword tl_keyword contained range-regex rangep rassoc rassq
syn keyword tl_keyword contained rassql rcomb rcons read
syn keyword tl_keyword contained read-once read-until-match readdir readlink
syn keyword tl_keyword contained real-time-stream-p realpath record-adapter reduce-left
syn keyword tl_keyword contained reduce-right ref refset regex-compile
syn keyword tl_keyword contained regex-from-trie regex-optimize regex-parse regex-prefix-match
syn keyword tl_keyword contained regex-source regexp register-exception-subtypes register-tentative-def
syn keyword tl_keyword contained regsub rehome-sym reject rel-path
syn keyword tl_keyword contained relate release-deferred-warnings remhash remove-if
syn keyword tl_keyword contained remove-if* remove-path remove-path-rec remq
syn keyword tl_keyword contained remq* remql remql* remqual
syn keyword tl_keyword contained remqual* rename-path repeat replace
syn keyword tl_keyword contained replace-buf replace-env replace-list replace-str
syn keyword tl_keyword contained replace-struct replace-tree-iter replace-vec reset-struct
syn keyword tl_keyword contained rest ret retf return
syn keyword tl_keyword contained return* return-from revappend reverse
syn keyword tl_keyword contained rfind rfind-if right rlcp
syn keyword tl_keyword contained rlcp-tree rlet rlim-infinity rlim-saved-cur
syn keyword tl_keyword contained rlim-saved-max rlimit-as rlimit-core rlimit-cpu
syn keyword tl_keyword contained rlimit-data rlimit-fsize rlimit-nofile rlimit-stack
syn keyword tl_keyword contained rlist rlist* rmdir rmember
syn keyword tl_keyword contained rmember-if rmemq rmemql rmemqual
syn keyword tl_keyword contained rmismatch rot rotate round
syn keyword tl_keyword contained round-rem rperm rplaca rplacd
syn keyword tl_keyword contained rpoly rpos rpos-if rposq
syn keyword tl_keyword contained rposql rposqual rr rra
syn keyword tl_keyword contained rsearch rslot rtld-deepbind rtld-global
syn keyword tl_keyword contained rtld-lazy rtld-local rtld-nodelete rtld-noload
syn keyword tl_keyword contained rtld-now run s-ifblk s-ifchr
syn keyword tl_keyword contained s-ifdir s-ififo s-iflnk s-ifmt
syn keyword tl_keyword contained s-ifreg s-ifsock s-irgrp s-iroth
syn keyword tl_keyword contained s-irusr s-irwxg s-irwxo s-irwxu
syn keyword tl_keyword contained s-isgid s-isuid s-isvtx s-iwgrp
syn keyword tl_keyword contained s-iwoth s-iwusr s-ixgrp s-ixoth
syn keyword tl_keyword contained s-ixusr save-exe sbit scan-until-match
syn keyword tl_keyword contained search search-all search-regex search-regst
syn keyword tl_keyword contained search-str search-str-tree second seek-cur
syn keyword tl_keyword contained seek-end seek-set seek-stream select
syn keyword tl_keyword contained self-load-path self-path separate seq-begin
syn keyword tl_keyword contained seq-next seq-reset seqp set
syn keyword tl_keyword contained set-diff set-hash-userdata set-indent set-indent-mode
syn keyword tl_keyword contained set-key set-left set-mask set-max-depth
syn keyword tl_keyword contained set-max-length set-package-fallback-list set-right set-sig-handler
syn keyword tl_keyword contained set-stack-limit setegid setenv seteuid
syn keyword tl_keyword contained setgid setgrent setgroups sethash
syn keyword tl_keyword contained setitimer setlogmask setpwent setresgid
syn keyword tl_keyword contained setresuid setrlimit setuid seventh
syn keyword tl_keyword contained sh sha256 sha256-begin sha256-end
syn keyword tl_keyword contained sha256-hash sha256-stream shift short
syn keyword tl_keyword contained short-suffix shuffle shut-rd shut-rdwr
syn keyword tl_keyword contained shut-wr sig-abrt sig-alrm sig-atomic-t
syn keyword tl_keyword contained sig-bus sig-check sig-chld sig-cont
syn keyword tl_keyword contained sig-fpe sig-hup sig-ill sig-int
syn keyword tl_keyword contained sig-io sig-iot sig-kill sig-pipe
syn keyword tl_keyword contained sig-poll sig-prof sig-pwr sig-quit
syn keyword tl_keyword contained sig-segv sig-stkflt sig-stop sig-sys
syn keyword tl_keyword contained sig-term sig-trap sig-tstp sig-ttin
syn keyword tl_keyword contained sig-ttou sig-urg sig-usr1 sig-usr2
syn keyword tl_keyword contained sig-vtalrm sig-winch sig-xcpu sig-xfsz
syn keyword tl_keyword contained sign-extend signum sin sinh
syn keyword tl_keyword contained sixth size-t size-vec sizeof
syn keyword tl_keyword contained slet slot slotp slots
syn keyword tl_keyword contained slotset so-acceptconn so-broadcast so-debug
syn keyword tl_keyword contained so-dontroute so-error so-keepalive so-linger
syn keyword tl_keyword contained so-oobinline so-rcvbuf so-rcvlowat so-rcvtimeo
syn keyword tl_keyword contained so-reuseaddr so-sndbuf so-sndlowat so-sndtimeo
syn keyword tl_keyword contained so-type sock-accept sock-bind sock-cloexec
syn keyword tl_keyword contained sock-connect sock-dgram sock-family sock-listen
syn keyword tl_keyword contained sock-nonblock sock-opt sock-peer sock-recv-timeout
syn keyword tl_keyword contained sock-send-timeout sock-set-opt sock-set-peer sock-shutdown
syn keyword tl_keyword contained sock-stream sock-type sockaddr-str socklen-t
syn keyword tl_keyword contained sol-socket some some-false some-true
syn keyword tl_keyword contained sort sort-group source-loc source-loc-str
syn keyword tl_keyword contained span-str special-operator-p special-var-p spl
syn keyword tl_keyword contained splice split split* split-str
syn keyword tl_keyword contained split-str-set spln sqrt square
syn keyword tl_keyword contained ssize-t sspl sssucc ssucc
syn keyword tl_keyword contained starts-with stat static-slot static-slot-ensure
syn keyword tl_keyword contained static-slot-home static-slot-p static-slot-set stdlib
syn keyword tl_keyword contained str str-buf str-d str-in6addr
syn keyword tl_keyword contained str-in6addr-net str-inaddr str-inaddr-net str-s
syn keyword tl_keyword contained str-seq str< str<= str=
syn keyword tl_keyword contained str> str>= stream-get-prop stream-set-prop
syn keyword tl_keyword contained streamp strerror string-extend string-finish
syn keyword tl_keyword contained string-get-code string-lt string-set-code stringp
syn keyword tl_keyword contained strsignal struct struct-from-args struct-from-plist
syn keyword tl_keyword contained struct-get-initfun struct-get-postinitfun struct-set-initfun struct-set-postinitfun
syn keyword tl_keyword contained struct-type struct-type-name struct-type-p structp
syn keyword tl_keyword contained sub sub-buf sub-list sub-str
syn keyword tl_keyword contained sub-tree sub-vec subq subql
syn keyword tl_keyword contained subqual subst subtypep succ
syn keyword tl_keyword contained sum sum-each sum-each* sum-each-prod
syn keyword tl_keyword contained sum-each-prod* super super-method suspend
syn keyword tl_keyword contained swap symacrolet symbol-function symbol-macro
syn keyword tl_keyword contained symbol-name symbol-package symbol-value symbolp
syn keyword tl_keyword contained symdiff symlink sys:%backpatch-high16% sys:%backpatch-low16%
syn keyword tl_keyword contained sys:%big-endian% sys:%bin-op% sys:%bin-ops% sys:%block-using-funs%
syn keyword tl_keyword contained sys:%call-op% sys:%const-foldable% sys:%const-foldable-funs% sys:%dbg-command-env%
syn keyword tl_keyword contained sys:%effect-free% sys:%effect-free-funs% sys:%eval-cache% sys:%functional%
syn keyword tl_keyword contained sys:%functional-funs% sys:%gcall-op% sys:%lev-bits% sys:%lev-size%
syn keyword tl_keyword contained sys:%max-lambda-fixed-args% sys:%max-lev% sys:%max-lev-idx% sys:%max-sm-lev%
syn keyword tl_keyword contained sys:%max-sm-lev-idx% sys:%max-v-lev% sys:%nary-ops% sys:%oc-code%
syn keyword tl_keyword contained sys:%oc-hash% sys:%oc-list-builder% sys:%package-manip% sys:%param-info%
syn keyword tl_keyword contained sys:%quip-rand-state% sys:%quips% sys:%shuffled-quips% sys:%sm-lev-bits%
syn keyword tl_keyword contained sys:%sm-lev-size% sys:%test-funs% sys:%test-funs-neg% sys:%test-funs-ops%
syn keyword tl_keyword contained sys:%test-funs-pos% sys:%test-inv% sys:%test-opcode% sys:%tlo-ver%
syn keyword tl_keyword contained sys:*dedup* sys:*emit* sys:*eval* sys:*in-compilation-unit*
syn keyword tl_keyword contained sys:*lazy-streams* sys:*load-recursive* sys:*load-time* sys:*match-form*
syn keyword tl_keyword contained sys:*op-ctx* sys:*pl-env* sys:*pl-form* sys:*struct-prelude*
syn keyword tl_keyword contained sys:*struct-prelude-alists* sys:*top-level* sys:*trace-hash* sys:*trace-level*
syn keyword tl_keyword contained sys:*unchecked-calls* sys:abscond* sys:abscond-from sys:add-neg-parens
syn keyword tl_keyword contained sys:analyze-argtypes sys:analyze-params sys:apply sys:arith-each
syn keyword tl_keyword contained sys:asm-error sys:assumed-fun sys:autoload-try-fun sys:awk%--rng
syn keyword tl_keyword contained sys:awk%--rng+ sys:awk%--rng- sys:awk%-rng+ sys:awk%rng+
syn keyword tl_keyword contained sys:awk-code-move-check sys:awk-error sys:awk-expander sys:awk-field-name-code
syn keyword tl_keyword contained sys:awk-fun-let sys:awk-fun-shadowing-env sys:awk-mac-let sys:awk-redir
syn keyword tl_keyword contained sys:awk-symac-let sys:awk-test sys:b* sys:b+
syn keyword tl_keyword contained sys:b- sys:b/ sys:b< sys:b<=
syn keyword tl_keyword contained sys:b= sys:b=> sys:b> sys:bad-slot-syntax
syn keyword tl_keyword contained sys:bind-mac-check sys:bind-mac-error sys:bindable-check sys:bits
syn keyword tl_keyword contained sys:bits-to-obj sys:blk sys:build-expander sys:capture-cont
syn keyword tl_keyword contained sys:catch sys:check sys:check-end sys:check-slot
syn keyword tl_keyword contained sys:check-struct sys:check-sym sys:circref sys:comma-positions
syn keyword tl_keyword contained sys:compat sys:compile-and-match sys:compile-as-match sys:compile-atom-match
syn keyword tl_keyword contained sys:compile-cons-structure sys:compile-exprs-match sys:compile-file-conditionally sys:compile-hash-match
syn keyword tl_keyword contained sys:compile-loop-match sys:compile-match sys:compile-new-var-match sys:compile-not-match
syn keyword tl_keyword contained sys:compile-or-match sys:compile-predicate-match sys:compile-range-match sys:compile-require-match
syn keyword tl_keyword contained sys:compile-scan-match sys:compile-struct-match sys:compile-var-match sys:compile-vec-match
syn keyword tl_keyword contained sys:compile-with-match sys:compiler-emit-warnings sys:conv sys:conv-expand
syn keyword tl_keyword contained sys:conv-expand-sym sys:conv-let sys:ctx-form sys:ctx-name
syn keyword tl_keyword contained sys:dbg-all sys:dbg-backtrace sys:dbg-clear sys:dbg-enable
syn keyword tl_keyword contained sys:dbg-restore sys:dbg-set sys:dbg-step sys:debugger
syn keyword tl_keyword contained sys:dedup sys:dedup-labels sys:deffi-cb-expander sys:define-method
syn keyword tl_keyword contained sys:defset-expander sys:defset-expander-simple sys:detached-run sys:dig
syn keyword tl_keyword contained sys:disassemble-cdf sys:dlib-expr sys:do-conv sys:do-copy-obj
syn keyword tl_keyword contained sys:do-path-test sys:do-tweak-obj sys:doc-syms sys:dump-to-tlo
syn keyword tl_keyword contained sys:dvbind sys:dwim-del sys:dwim-set sys:dyn-size
syn keyword tl_keyword contained sys:each-match-expander sys:each-op sys:early-peephole sys:enc-small-op
syn keyword tl_keyword contained sys:ensure-op-arg sys:env-to-let sys:eq-comparable sys:eql-comparable
syn keyword tl_keyword contained sys:eval-cache-emit-warnings sys:eval-err sys:expand-and sys:expand-arith-each-prod
syn keyword tl_keyword contained sys:expand-bind-mac-params sys:expand-defmacro sys:expand-defsymacro sys:expand-defun
syn keyword tl_keyword contained sys:expand-defvarl sys:expand-dohash sys:expand-doloop sys:expand-each
syn keyword tl_keyword contained sys:expand-each-prod sys:expand-each-prod* sys:expand-handle sys:expand-lambda-match
syn keyword tl_keyword contained sys:expand-neg-parens sys:expand-param-macro sys:expand-params sys:expand-pic
syn keyword tl_keyword contained sys:expand-pic-align sys:expand-pic-num sys:expand-pic-num-commas sys:expand-quasi
syn keyword tl_keyword contained sys:expand-quasi-args sys:expand-quasi-match sys:expand-quasi-mods sys:expand-sym-ref
syn keyword tl_keyword contained sys:expr sys:fbind sys:find-parent sys:fixed-point
syn keyword tl_keyword contained sys:flatten-or sys:fmt-flex sys:fmt-join sys:fmt-simple
syn keyword tl_keyword contained sys:for-op sys:gc sys:gc-set-delta sys:get-buf-common
syn keyword tl_keyword contained sys:get-fun-getter-setter sys:get-mb sys:get-param-info sys:get-place-macro
syn keyword tl_keyword contained sys:get-var-list sys:get-vars sys:get-vb sys:getopts-error
syn keyword tl_keyword contained sys:handle-bad-syntax sys:hlet-expand sys:if-to-cond sys:ign-notfound
syn keyword tl_keyword contained sys:in6addr-condensed-text sys:insert-commas sys:is-label sys:l1-setq
syn keyword tl_keyword contained sys:l1-val sys:lambda-apply-transform sys:lambda-excess-apply-list sys:lambda-short-apply-list
syn keyword tl_keyword contained sys:lambda-too-few-args sys:lambda-too-many-args sys:lbind sys:lisp1-setq
syn keyword tl_keyword contained sys:lisp1-value sys:list-builder-flets sys:list-from-vm-desc sys:load-time-lit
syn keyword tl_keyword contained sys:loc sys:loosen sys:mac-env-flatten sys:make-anon-package
syn keyword tl_keyword contained sys:make-command-env sys:make-copy-path-opts sys:make-struct-lit sys:make-struct-type
syn keyword tl_keyword contained sys:mark-special sys:match-pat-error sys:meth-lambda sys:misleading-ref-check
syn keyword tl_keyword contained sys:name-str sys:new-expander sys:new-type sys:non-triv-pat-p
syn keyword tl_keyword contained sys:null-reg sys:obtain-impl sys:op-alpha-rename sys:op-ensure-rec
syn keyword tl_keyword contained sys:op-expand sys:op-meta-p sys:op-rec-p sys:open-compile-streams
syn keyword tl_keyword contained sys:open-url sys:operand-to-exp sys:operand-to-sym sys:opip-expand
syn keyword tl_keyword contained sys:opt-dash sys:opt-err sys:orig-form sys:os-symbol
syn keyword tl_keyword contained sys:param-check sys:parse-compound-operand sys:parse-lambda-match-clause sys:parse-operand
syn keyword tl_keyword contained sys:pat-len sys:path-access sys:path-examine sys:path-simplify
syn keyword tl_keyword contained sys:path-split sys:path-test-mode sys:path-test-type sys:path-volume
syn keyword tl_keyword contained sys:pic-join-opt sys:placelet-1 sys:print-backtrace sys:propagate-ancestor
syn keyword tl_keyword contained sys:propagate-perms sys:prune-missing-inits sys:qquote sys:quasi
syn keyword tl_keyword contained sys:quasilist sys:r-s-let-expander sys:reduce-constant sys:reduce-lisp
syn keyword tl_keyword contained sys:reduce-or sys:reg-expand-nongreedy sys:register-opcode sys:register-simple-accessor
syn keyword tl_keyword contained sys:repl sys:rewrite sys:rewrite-case sys:rplaca
syn keyword tl_keyword contained sys:rplacd sys:rslotset sys:rt-assert-fail sys:rt-defmacro
syn keyword tl_keyword contained sys:rt-defsymacro sys:rt-defun sys:rt-defv sys:rt-defvarl
syn keyword tl_keyword contained sys:rt-load-for sys:rt-pprof sys:safe-abs-path sys:safe-const-eval
syn keyword tl_keyword contained sys:safe-const-reduce sys:safe-constantp sys:set-hash-traversal-limit sys:set-macro-ancestor
syn keyword tl_keyword contained sys:setq sys:setqf sys:simplify-or sys:slot-types
syn keyword tl_keyword contained sys:small-op-p sys:small-op-to-sym sys:splice sys:static-slot-types
syn keyword tl_keyword contained sys:str-inaddr-net-impl sys:struct-lit sys:stuff-key-params sys:subst-preserve
syn keyword tl_keyword contained sys:switch sys:sym-clobber-expander sys:sym-delete-expander sys:sym-update-expander
syn keyword tl_keyword contained sys:system-symbol-p sys:top-fb sys:top-mb sys:top-vb
syn keyword tl_keyword contained sys:tr* sys:trace sys:trace-canonicalize-name sys:trace-enter
syn keyword tl_keyword contained sys:trace-leave sys:trace-redefine-check sys:transform-qquote sys:translate-hash-bang
syn keyword tl_keyword contained sys:tree-construct sys:trfm sys:true-const-p sys:txr-case-impl
syn keyword tl_keyword contained sys:typecase-expander sys:unquote sys:untrace sys:upenv
syn keyword tl_keyword contained sys:uw-block sys:uw-captured-block sys:uw-catch sys:uw-cont-copy
syn keyword tl_keyword contained sys:uw-eval sys:uw-expand sys:uw-fcall sys:uw-guard
syn keyword tl_keyword contained sys:uw-handle sys:uw-menv sys:var sys:var-pat-p
syn keyword tl_keyword contained sys:vars-check sys:vm-closure-desc sys:vm-closure-entry sys:vm-desc-bytecode
syn keyword tl_keyword contained sys:vm-desc-datavec sys:vm-desc-nlevels sys:vm-desc-nregs sys:vm-desc-symvec
syn keyword tl_keyword contained sys:vm-execute-toplevel sys:vm-make-desc sys:wdwrap sys:when-exprs-match
syn keyword tl_keyword contained sys:with-disabled-debugging sys:with-dyn-lib-check syslog system-package
syn keyword tl_keyword contained t tab0 tab1 tab2
syn keyword tl_keyword contained tab3 tabdly tagbody tailp
syn keyword tl_keyword contained take take-until take-while tan
syn keyword tl_keyword contained tanh tb tc tcdrain
syn keyword tl_keyword contained tcflow tcflush tcgetattr tciflush
syn keyword tl_keyword contained tcioff tcioflush tcion tcoflush
syn keyword tl_keyword contained tcooff tcoon tcp-nodelay tcsadrain
syn keyword tl_keyword contained tcsaflush tcsanow tcsendbreak tcsetattr
syn keyword tl_keyword contained tentative-def-exists tenth test-clear test-clear-dirty
syn keyword tl_keyword contained test-dec test-dirty test-inc test-neq-set-indent-mode
syn keyword tl_keyword contained test-set test-set-indent-mode tf third
syn keyword tl_keyword contained throw throwf time time-fields-local
syn keyword tl_keyword contained time-fields-utc time-nsec time-parse time-parse-local
syn keyword tl_keyword contained time-parse-utc time-string-local time-string-utc time-struct-local
syn keyword tl_keyword contained time-struct-utc time-t time-usec tmpfile
syn keyword tl_keyword contained tnode tnodep to tofloat
syn keyword tl_keyword contained tofloatz toint tointz tojson
syn keyword tl_keyword contained tok tok-str tok-where tokn
syn keyword tl_keyword contained tostop tostring tostringp touch
syn keyword tl_keyword contained tprint trace transpose tree
syn keyword tl_keyword contained tree-begin tree-bind tree-case tree-clear
syn keyword tl_keyword contained tree-count tree-del-min tree-del-min-node tree-delete
syn keyword tl_keyword contained tree-delete-node tree-delete-specific-node tree-find tree-insert
syn keyword tl_keyword contained tree-insert-node tree-lookup tree-lookup-node tree-min
syn keyword tl_keyword contained tree-min-node tree-next tree-peek tree-reset
syn keyword tl_keyword contained tree-root treep trie-add trie-compress
syn keyword tl_keyword contained trie-lookup-begin trie-lookup-feed-char trie-value-at trim-left
syn keyword tl_keyword contained trim-long-suffix trim-path-seps trim-right trim-short-suffix
syn keyword tl_keyword contained trim-str true trunc trunc-rem
syn keyword tl_keyword contained truncate-stream tuples tuples* txr-case
syn keyword tl_keyword contained txr-exe-path txr-if txr-parse txr-path
syn keyword tl_keyword contained txr-version txr-when typecase typedef
syn keyword tl_keyword contained typeof typep ubit uchar
syn keyword tl_keyword contained uid-t uint uint-buf uint-carray
syn keyword tl_keyword contained uint-ptr-t uint16 uint32 uint64
syn keyword tl_keyword contained uint8 uintmax-t ulong ulonglong
syn keyword tl_keyword contained umask umeth umethod uname
syn keyword tl_keyword contained unget-byte unget-char uni unintern
syn keyword tl_keyword contained union union-get union-in union-members
syn keyword tl_keyword contained union-out union-put uniq unique
syn keyword tl_keyword contained unless unquote unsetenv until
syn keyword tl_keyword contained until* untrace unuse-package unuse-sym
syn keyword tl_keyword contained unwind-protect upcase-str upd update
syn keyword tl_keyword contained uref url-decode url-encode use
syn keyword tl_keyword contained use-package use-sym user-package ushort
syn keyword tl_keyword contained usl usleep uslot utimes
syn keyword tl_keyword contained val vdiscard vec vec-carray
syn keyword tl_keyword contained vec-list vec-push vec-seq vec-set-length
syn keyword tl_keyword contained vecref vector vector-list vectorp
syn keyword tl_keyword contained veof veol veol2 verase
syn keyword tl_keyword contained vintr vkill vlnext vm-fun-p
syn keyword tl_keyword contained vmin void vquit vreprint
syn keyword tl_keyword contained vstart vstop vsusp vswtc
syn keyword tl_keyword contained vt0 vt1 vtdly vtime
syn keyword tl_keyword contained vwerase w-continued w-coredump w-exitstatus
syn keyword tl_keyword contained w-ifcontinued w-ifexited w-ifsignaled w-ifstopped
syn keyword tl_keyword contained w-nohang w-stopsig w-termsig w-untraced
syn keyword tl_keyword contained wait wchar weave when
syn keyword tl_keyword contained when-match whena whenlet where
syn keyword tl_keyword contained while while* while-match while-match-case
syn keyword tl_keyword contained while-true-match-case whilet width width-check
syn keyword tl_keyword contained window-map window-mapdo window-mappend wint-t
syn keyword tl_keyword contained with-clobber-expander with-compilation-unit with-delete-expander with-dyn-lib
syn keyword tl_keyword contained with-gensyms with-hash-iter with-in-buf-stream with-in-string-byte-stream
syn keyword tl_keyword contained with-in-string-stream with-objects with-out-buf-stream with-out-string-stream
syn keyword tl_keyword contained with-out-strlist-stream with-resources with-slots with-stream
syn keyword tl_keyword contained with-update-expander wrap wrap* wstr
syn keyword tl_keyword contained wstr-d wstr-s xcase yield
syn keyword tl_keyword contained yield-from zap zarray zchar
syn keyword tl_keyword contained zero-fill zerop zip znew
syn match txr_nested_error "[^\t ]\+" contained
syn match txr_variable "[*]\?[ \t]*[A-Za-z_][A-Za-z_0-9]*" contained
syn match txr_splicevar "[ \t,*@]*[A-Za-z_][A-Za-z_0-9]*" contained
syn match txr_metanum "\(@[ \t]*\)\+[0-9]\+"
syn match txr_badesc "\\." contained
syn match txr_escat "\\@" contained
syn match txr_stresc "\\[abtnvfre\\ "`']" contained
syn match txr_numesc "\\x[0-9A-Fa-f]\+;\?" contained
syn match txr_numesc "\\[0-7]\+;\?" contained
syn match txr_regesc "\\[abtnvfre\\ /sSdDwW()\|.*?+~&%\[\]\-]" contained

syn match tl_error "#[^HSRTN]"

syn match txr_chr "#\\x[0-9A-Fa-f]\+"
syn match txr_chr "#\\o[0-7]\+"
syn match txr_chr "#\\[^ \t\nA-Za-z_0-9]"
syn match txr_chr "#\\[A-Za-z_0-9]\+"
syn match txr_ncomment ";.*"

syn match txr_hashbang "\%^#!.*"

syn match txr_qat "\(@[ \t]*\)" nextgroup=txr_splicevar,txr_metanum,txr_qbracevar,txr_list,txr_bracket,txr_escat,txr_stresc,txr_numesc,txr_badesc contained
syn match txr_dot "\." contained
syn match txr_ident "[A-Za-z_0-9!$%&*+\-<=>?\\_~]*[A-Za-z_!$%&*+\-<=>?\\_~^][A-Za-z_0-9!$%&*+\-<=>?\\_~^]*" contained
syn match tl_ident "[:][A-Za-z_0-9!$%&*+\-<=>?\\_~^/]\+"
syn match txr_braced_ident "[:][A-Za-z_0-9!$%&*+\-<=>?\\_~^/]\+" contained
syn match tl_ident "[A-Za-z_0-9!$%&*+\-<=>?\\_~/]\+[A-Za-z_0-9!$%&*+\-<=>?\\_~^/#]*"
syn match txr_pnum "#[xob][+\-]\?[A-Za-z_0-9,]\+" contains=txr_xnum,txr_bnum,txr_onum
syn match txr_xnum "#x[+\-]\?\([0-9A-Fa-f][,0-9A-Fa-f]*[0-9A-Fa-f]\|[0-9A-Fa-f]\)" containedin=txr_pnum contained
syn match txr_onum "#o[+\-]\?\([0-7][,0-7]*[0-7]\|[0-7]\)" containedin=txr_pnum contained
syn match txr_bnum "#b[+\-]\?\([01][,01]*[01]\|[01]\)" containedin=txr_pnum contained
syn match txr_num "[+\-]\?\([0-9][,0-9]*[0-9]\|[0-9]\)\?[.]\([0-9][,0-9]*[0-9]\|[0-9]\)\([eE][+\-]\?[0-9]\+\)\?"
syn match txr_num "[+\-]\?\([0-9][,0-9]*[0-9]\|[0-9]\)[.]\?\([eE][+\-]\?[0-9]\+\)"
syn match txr_badnum "[+\-]\?\([0-9][,0-9]*[0-9]\|[0-9]\)\?[.]\([0-9][,0-9]*[0-9]\|[0-9]\)\([A-DF-Za-dfz_!$%&*+\-<=>?\\_~^/#]\|[eE][^+\-0-9]\|[eE][+/-]\?$\|[eE][+\-][^0-9]\)"
syn match txr_badnum "[+\-]\?\([0-9][,0-9]*[0-9]\|[0-9]\)[.]\?\([A-DF-Za-dfz_!$%&*+\-<=>?\\_~^/#]\|[eE][^+\-0-9]\|[eE][+/-]\?$\|[eE][+\-][^0-9]\)"
syn match tl_ident ":"
syn match tl_splice "[ \t,]\|,[*]"

syn match txr_unquote "," contained
syn match txr_splice ",\*" contained
syn match txr_quote "'"
syn match txr_quote "\^"
syn match txr_dotdot "\.\." contained
syn match txr_metaat "@"

syn match txr_buf_error "[^']" contained
syn match txr_buf_interior "\([0-9A-Fa-f][\n\t ]*[0-9A-Fa-f]\|[\n\t ]\+\)" contained

syn region txr_bracevar contained matchgroup=Delimiter start="[*]\?{" matchgroup=Delimiter end="}" contains=txr_num,txr_pnum,tl_ident,tl_splice,tl_metanum,txr_metaat,txr_circ,txr_braced_ident,txr_dot,txr_dotdot,txr_string,txr_list,txr_bracket,txr_regex,tl_regex,txr_quasilit,txr_chr,txr_nested_error
syn region txr_qbracevar contained matchgroup=Delimiter start="[*]\?{" matchgroup=Delimiter end="}" contains=txr_num,txr_pnum,tl_ident,tl_splice,tl_metanum,txr_metaat,txr_circ,txr_braced_ident,txr_dot,txr_dotdot,txr_string,txr_list,txr_bracket,txr_regex,tl_regex,txr_quasilit,txr_chr,txr_nested_error
syn region txr_list matchgroup=Delimiter start="\(#[HSRTN]\?\)\?(" matchgroup=Delimiter end=")" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign,txr_ign_json,txr_list,txr_bracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,tl_error,txr_nested_error
syn region txr_bracket matchgroup=Delimiter start="\[" matchgroup=Delimiter end="\]" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign,txr_ign_json,txr_list,txr_bracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,tl_error,txr_nested_error
syn region txr_string start=+#\?\*\?"+ skip=+\\\n+ end=+["\n]+ contains=txr_stresc,txr_numesc,txr_badesc
syn region txr_quasilit start=+#\?\*\?`+ skip=+\\\n+ end=+[`\n]+ contains=txr_qat
syn region txr_regex start="/" skip=+\\\n+ end="[/\n]" contains=txr_regesc,txr_numesc,txr_badesc
syn region tl_regex start="#/" skip=+\\\n+ end="[/\n]" contains=txr_regesc,txr_numesc,txr_badesc
syn region txr_buf matchgroup=txr_buf start="#b'" end="'" contains=txr_buf_interior,txr_buf_error
syn region txr_ign matchgroup=Comment start="#;" end="[ \(\)\[\]]"me=e   contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign,txr_ign_json,txr_list,txr_bracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,tl_error,txr_nested_error
syn region txr_ign matchgroup=Comment start="#;[ \t',^@]*\(#[HSRTN]\?\)\?(" matchgroup=Comment end=")" contains=txr_ign_interior
syn region txr_ign matchgroup=Comment start="#;[ \t',^@]*\(#[HSRTNJ]\?\)\?\[" matchgroup=Comment end="\]" contains=txr_ign_interior
syn region txr_ign_json matchgroup=Comment start="#;[ \t',^@]*#J[~^]*{" matchgroup=Comment end="}" contains=txr_ign_interior
syn region txr_ign_json matchgroup=Comment start="#;[ \t',^@]*#J[~^]*\[" matchgroup=Comment end="\]" contains=txr_ign_interior
syn region txr_ign_json matchgroup=Comment start="#;[ \t',^@]*#J[~^]*(" matchgroup=Comment end=")" contains=txr_ign_interior
syn region txr_ign_interior contained matchgroup=Comment start="(" matchgroup=Comment end=")" contains=txr_ign_interior
syn region txr_ign_interior contained matchgroup=Comment start="\[" matchgroup=Comment end="\]" contains=txr_ign_interior
syn region txr_ign_interior contained matchgroup=Comment start="{" matchgroup=Comment end="}" contains=txr_ign_interior

syn match txr_jerr "." contained
syn match txr_jpunc "[,: \t\n]" contained
syn match txr_jesc "\\[bfnrt"\\/]" contained
syn match txr_juesc "\\u[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]" contained
syn match txr_jnum "-\?\(0\|[1-9][0-9]*\)\([.][0-9]\+\)\?\([Ee][+-]\?[0-9]\+\)\?" contained
syn match txr_jkeyword "true\|false\|null" contained

syn region txr_jatom matchgroup=Delimiter start="#J\^\?[\t\n ]*"rs=e end="[\t\n ]\|[\])}]"re=e-1 contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_junqtok contained matchgroup=Delimiter start="\~" end="[ \(\)\[\]{}]"re=s contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign,txr_ign_json,txr_list,txr_bracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,tl_error,txr_nested_error
syn region txr_junqlist contained matchgroup=Delimiter start="\~\*\?#\?(" end=")" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign,txr_ign_json,txr_list,txr_bracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,tl_error,txr_nested_error
syn region txr_junqbkt contained matchgroup=Delimiter start="\~\*\?\[" end="\]" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign,txr_ign_json,txr_list,txr_bracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,tl_error,txr_nested_error
syn region txr_jstring contained matchgroup=Delimiter start=+"+ end=+["\n]+ contains=txr_jesc,txr_juesc,txr_badesc
syn region txr_jarray matchgroup=Delimiter start="#J\^\?[\t\n ]*\[" matchgroup=Delimiter end="\]" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_jhash matchgroup=Delimiter start="#J\^\?[\t\n ]*{" matchgroup=Delimiter end="}" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_jarray_in contained matchgroup=Delimiter start="\[" end="\]" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_jhash_in contained matchgroup=Delimiter start="{" end="}" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr

syn match txr_circ "#[0-9]\+[#=]" contained

hi def link txr_at Special
hi def link txr_atstar Special
hi def link txr_atat Special
hi def link txr_qat Special
hi def link txr_comment Comment
hi def link txr_ncomment Comment
hi def link txr_hashbang Preproc
hi def link txr_contin Preproc
hi def link txr_char String
hi def link tl_keyword Type
hi def link txr_string String
hi def link txr_chr String
hi def link txr_quasilit String
hi def link txr_regex String
hi def link tl_regex String
hi def link txr_regdir String
hi def link txr_variable Identifier
hi def link txr_splicevar Identifier
hi def link txr_metanum Identifier
hi def link txr_escat Special
hi def link txr_stresc Special
hi def link txr_numesc Special
hi def link txr_regesc Special
hi def link txr_badesc Error
hi def link txr_ident Identifier
hi def link tl_ident Identifier
hi def link txr_num Number
hi def link txr_xnum Number
hi def link txr_bnum Number
hi def link txr_onum Number
hi def link txr_badnum Error
hi def link txr_pnum Error
hi def link txr_quote Special
hi def link txr_unquote Special
hi def link txr_splice Special
hi def link txr_dot Special
hi def link txr_dotdot Special
hi def link txr_metaat Special
hi def link txr_circ Special
hi def link txr_munqspl Special
hi def link tl_splice Special
hi def link txr_error Error
hi def link tl_error Error
hi def link txr_nested_error Error
hi def link txr_buf String
hi def link txr_buf_interior String
hi def link txr_buf_error Error
hi def link txr_ign_interior Comment
hi def link txr_ign Comment
hi def link txr_ign_json Comment

hi def link txr_jkeyword Type
hi def link txr_jnum Number
hi def link txr_jstring String
hi def link txr_jesc Special
hi def link txr_juesc Special
hi def link txr_jpunc Special
hi def link txr_jerr Error

let b:current_syntax = "lisp"

set lispwords=ado,alet,align,alignof,ap,append-each,append-each*,append-each-prod,append-each-prod*,append-match-products,append-matches,aret,array,arraysize,assert,awk,bit,block,block*,bool,buf,buf-d,build,buildn,carray,caseq,caseq*,caseql,caseql*,casequal,casequal*,catch,catch*,catch**,clear-mask,close-lazy-streams,collect-each,collect-each*,collect-each-prod,collect-each-prod*,compare-swap,compile-only,cond,conda,condlet,cptr,dec,defex,deffi,deffi-cb,deffi-cb-unsafe,deffi-struct,deffi-sym,deffi-type,deffi-union,deffi-var,define-accessor,define-modify-macro,define-option-struct,define-param-expander,define-place-macro,define-struct-clause,define-struct-prelude,defmacro,defmatch,defmeth,defpackage,defparm,defparml,defplace,defset,defstruct,defsymacro,defun,defun-match,defvar,defvarl,del,delay,do,dohash,doloop,doloop*,dotimes,each,each*,each-false,each-match,each-match-product,each-prod,each-prod*,each-true,ecaseq,ecaseq*,ecaseql,ecaseql*,ecasequal,ecasequal*,elemsize,elemtype,enum,enumed,equot,etypecase,eval-only,ffi,flet,flip,flow,for,for*,fun,gen,go,gun,handle,handle*,handler-bind,hlet,hlet*,ido,if,if-match,ifa,iflet,ignerr,ignwarn,in-package,ip,json,keep-match-products,keep-matches,labels,lambda,lambda-match,lcons,ldo,let,let*,lnew*,load-for,load-time,lop,lset,mac-env-param-bind,mac-param-bind,macro-time,macrolet,match,match-case,match-ecase,mlet,mul-each,mul-each*,mul-each-prod,mul-each-prod*,nand,new*,nor,obtain,obtain*,obtain*-block,obtain-block,offsetof,op,pack,pdec,pic,pinc,placelet,placelet*,pop,pop-after-load,pprof,prof,prog,prog*,prog1,prog2,progn,ptr,ptr-in,ptr-in-d,ptr-out,ptr-out-d,ptr-out-s,push,push-after-load,pushnew,ret,return,return-from,rlet,rslot,sbit,set-mask,sizeof,slet,some-false,some-true,splice,struct,sum-each,sum-each*,sum-each-prod,sum-each-prod*,suspend,symacrolet,sys:abscond-from,sys:arith-each,sys:awk-fun-let,sys:awk-mac-let,sys:awk-redir,sys:awk-symac-let,sys:blk,sys:catch,sys:conv,sys:conv-expand-sym,sys:dlib-expr,sys:dvbind,sys:each-op,sys:expr,sys:fbind,sys:fixed-point,sys:for-op,sys:ign-notfound,sys:l1-val,sys:lbind,sys:lisp1-value,sys:load-time-lit,sys:meth-lambda,sys:path-examine,sys:placelet-1,sys:rewrite-case,sys:splice,sys:struct-lit,sys:switch,sys:txr-case-impl,sys:unquote,sys:upenv,sys:var,sys:when-exprs-match,sys:with-disabled-debugging,tagbody,tb,tc,test-clear,test-dec,test-inc,test-set,trace,tree-bind,tree-case,txr-case,txr-if,txr-when,typecase,typedef,ubit,union,unless,unquote,until,until*,untrace,unwind-protect,upd,uref,when,when-match,whena,whenlet,while,while*,while-match,while-match-case,while-true-match-case,whilet,with-clobber-expander,with-compilation-unit,with-delete-expander,with-dyn-lib,with-gensyms,with-hash-iter,with-in-buf-stream,with-in-string-byte-stream,with-in-string-stream,with-objects,with-out-buf-stream,with-out-string-stream,with-out-strlist-stream,with-resources,with-slots,with-stream,with-update-expander,yield,yield-from,zap,zarray,znew,:method,:function,:init,:postinit,:fini
set comments=:\;\;\;,:\;\;,:\;
