/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javacc.jjtree.ASTBNFAction;
import org.javacc.jjtree.ASTBNFDeclaration;
import org.javacc.jjtree.ASTBNFNodeScope;
import org.javacc.jjtree.ASTBNFNonTerminal;
import org.javacc.jjtree.ASTBNFOneOrMore;
import org.javacc.jjtree.ASTBNFSequence;
import org.javacc.jjtree.ASTBNFTryBlock;
import org.javacc.jjtree.ASTBNFZeroOrMore;
import org.javacc.jjtree.ASTBNFZeroOrOne;
import org.javacc.jjtree.ASTCompilationUnit;
import org.javacc.jjtree.ASTExpansionNodeScope;
import org.javacc.jjtree.ASTGrammar;
import org.javacc.jjtree.ASTJavacodeBody;
import org.javacc.jjtree.ASTLHS;
import org.javacc.jjtree.ASTNodeDescriptor;
import org.javacc.jjtree.ASTProduction;
import org.javacc.jjtree.DefaultJJTreeVisitor;
import org.javacc.jjtree.IO;
import org.javacc.jjtree.JJTreeGlobals;
import org.javacc.jjtree.JJTreeNode;
import org.javacc.jjtree.JJTreeOptions;
import org.javacc.jjtree.JJTreeState;
import org.javacc.jjtree.Node;
import org.javacc.jjtree.NodeFiles;
import org.javacc.jjtree.NodeScope;
import org.javacc.jjtree.SimpleNode;
import org.javacc.jjtree.Token;
import org.javacc.jjtree.TokenUtils;
import org.javacc.parser.JavaCCGlobals;

public class JavaCodeGenerator
extends DefaultJJTreeVisitor {
    @Override
    public Object defaultVisit(SimpleNode node, Object data) {
        this.visit((JJTreeNode)node, data);
        return null;
    }

    @Override
    public Object visit(ASTGrammar node, Object data) {
        IO io = (IO)data;
        io.println("/*@bgen(jjtree) " + JavaCCGlobals.getIdString(JJTreeGlobals.toolList, new File(io.getOutputFileName()).getName()) + " */");
        io.print("/*@egen*/");
        return node.childrenAccept(this, io);
    }

    @Override
    public Object visit(ASTBNFAction node, Object data) {
        IO io = (IO)data;
        NodeScope ns = NodeScope.getEnclosingNodeScope(node);
        if (ns != null && !ns.isVoid()) {
            boolean needClose = true;
            Node sp = node.getScopingParent(ns);
            JJTreeNode n = node;
            while (true) {
                Node p;
                if ((p = n.jjtGetParent()) instanceof ASTBNFSequence || p instanceof ASTBNFTryBlock) {
                    if (n.getOrdinal() != p.jjtGetNumChildren() - 1) {
                        needClose = false;
                        break;
                    }
                } else if (p instanceof ASTBNFZeroOrOne || p instanceof ASTBNFZeroOrMore || p instanceof ASTBNFOneOrMore) {
                    needClose = false;
                    break;
                }
                if (p == sp) break;
                n = (JJTreeNode)p;
            }
            if (needClose) {
                JavaCodeGenerator.openJJTreeComment(io, null);
                io.println();
                this.insertCloseNodeAction(ns, io, this.getIndentation(node));
                JavaCodeGenerator.closeJJTreeComment(io);
            }
        }
        return this.visit((JJTreeNode)node, (Object)io);
    }

    @Override
    public Object visit(ASTBNFDeclaration node, Object data) {
        IO io = (IO)data;
        if (!node.node_scope.isVoid()) {
            String indent = "";
            if (TokenUtils.hasTokens(node)) {
                for (int i = 1; i < node.getFirstToken().beginColumn; ++i) {
                    indent = indent + " ";
                }
            } else {
                indent = "  ";
            }
            JavaCodeGenerator.openJJTreeComment(io, node.node_scope.getNodeDescriptorText());
            io.println();
            this.insertOpenNodeCode(node.node_scope, io, indent);
            JavaCodeGenerator.closeJJTreeComment(io);
        }
        return this.visit((JJTreeNode)node, (Object)io);
    }

    @Override
    public Object visit(ASTBNFNodeScope node, Object data) {
        IO io = (IO)data;
        if (node.node_scope.isVoid()) {
            return this.visit((JJTreeNode)node, (Object)io);
        }
        String indent = this.getIndentation(node.expansion_unit);
        JavaCodeGenerator.openJJTreeComment(io, node.node_scope.getNodeDescriptor().getDescriptor());
        io.println();
        this.tryExpansionUnit(node.node_scope, io, indent, node.expansion_unit);
        return null;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        IO io = (IO)data;
        Token t = node.getFirstToken();
        while (true) {
            if (t == JJTreeGlobals.parserImports && !JJTreeGlobals.nodePackageName.equals("") && !JJTreeGlobals.nodePackageName.equals(JJTreeGlobals.packageName)) {
                io.getOut().println("");
                io.getOut().println("import " + JJTreeGlobals.nodePackageName + ".*;");
            }
            if (t == JJTreeGlobals.parserImplements) {
                if (t.image.equals("implements")) {
                    node.print(t, io);
                    JavaCodeGenerator.openJJTreeComment(io, null);
                    io.getOut().print(" " + NodeFiles.nodeConstants() + ", ");
                    JavaCodeGenerator.closeJJTreeComment(io);
                } else {
                    JavaCodeGenerator.openJJTreeComment(io, null);
                    io.getOut().print("implements " + NodeFiles.nodeConstants());
                    JavaCodeGenerator.closeJJTreeComment(io);
                    node.print(t, io);
                }
            } else {
                node.print(t, io);
            }
            if (t == JJTreeGlobals.parserClassBodyStart) {
                JavaCodeGenerator.openJJTreeComment(io, null);
                JJTreeState.insertParserMembers(io);
                JavaCodeGenerator.closeJJTreeComment(io);
            }
            if (t == node.getLastToken()) {
                return null;
            }
            t = t.next;
        }
    }

    @Override
    public Object visit(ASTExpansionNodeScope node, Object data) {
        IO io = (IO)data;
        String indent = this.getIndentation(node.expansion_unit);
        JavaCodeGenerator.openJJTreeComment(io, node.node_scope.getNodeDescriptor().getDescriptor());
        io.println();
        this.insertOpenNodeAction(node.node_scope, io, indent);
        this.tryExpansionUnit(node.node_scope, io, indent, node.expansion_unit);
        ((ASTNodeDescriptor)node.jjtGetChild(1)).jjtAccept(this, io);
        return null;
    }

    @Override
    public Object visit(ASTJavacodeBody node, Object data) {
        IO io = (IO)data;
        if (node.node_scope.isVoid()) {
            return this.visit((JJTreeNode)node, (Object)io);
        }
        Token first = node.getFirstToken();
        String indent = "";
        for (int i = 4; i < first.beginColumn; ++i) {
            indent = indent + " ";
        }
        JavaCodeGenerator.openJJTreeComment(io, node.node_scope.getNodeDescriptorText());
        io.println();
        this.insertOpenNodeCode(node.node_scope, io, indent);
        this.tryTokenSequence(node.node_scope, io, indent, first, node.getLastToken());
        return null;
    }

    public Object visit(ASTLHS node, Object data) {
        IO io = (IO)data;
        NodeScope ns = NodeScope.getEnclosingNodeScope(node);
        Token first = node.getFirstToken();
        Token last = node.getLastToken();
        Token t = first;
        while (t != last.next) {
            TokenUtils.print(t, io, "jjtThis", ns.getNodeVariable());
            t = t.next;
        }
        return null;
    }

    public Object visit(JJTreeNode node, Object data) {
        IO io = (IO)data;
        if (node.getLastToken().next == node.getFirstToken()) {
            return null;
        }
        Token t1 = node.getFirstToken();
        Token t = new Token();
        t.next = t1;
        for (int ord = 0; ord < node.jjtGetNumChildren(); ++ord) {
            JJTreeNode n = (JJTreeNode)node.jjtGetChild(ord);
            while ((t = t.next) != n.getFirstToken()) {
                node.print(t, io);
            }
            n.jjtAccept(this, io);
            t = n.getLastToken();
        }
        while (t != node.getLastToken()) {
            t = t.next;
            node.print(t, io);
        }
        return null;
    }

    static void openJJTreeComment(IO io, String arg) {
        if (arg != null) {
            io.print("/*@bgen(jjtree) " + arg + " */");
        } else {
            io.print("/*@bgen(jjtree)*/");
        }
    }

    static void closeJJTreeComment(IO io) {
        io.print("/*@egen*/");
    }

    String getIndentation(JJTreeNode n) {
        return this.getIndentation(n, 0);
    }

    String getIndentation(JJTreeNode n, int offset) {
        String s = "";
        for (int i = offset + 1; i < n.getFirstToken().beginColumn; ++i) {
            s = s + " ";
        }
        return s;
    }

    void insertOpenNodeDeclaration(NodeScope ns, IO io, String indent) {
        this.insertOpenNodeCode(ns, io, indent);
    }

    void insertOpenNodeCode(NodeScope ns, IO io, String indent) {
        String parserArg;
        String type = ns.node_descriptor.getNodeType();
        String nodeClass = JJTreeOptions.getNodeClass().length() > 0 && !JJTreeOptions.getMulti() ? JJTreeOptions.getNodeClass() : type;
        NodeFiles.ensure(io, type);
        io.print(indent + nodeClass + " " + ns.nodeVar + " = ");
        String p = JJTreeOptions.getStatic() ? "null" : "this";
        String string = parserArg = JJTreeOptions.getNodeUsesParser() ? p + ", " : "";
        if (JJTreeOptions.getNodeFactory().equals("*")) {
            io.println("(" + nodeClass + ")" + nodeClass + ".jjtCreate(" + parserArg + ns.node_descriptor.getNodeId() + ");");
        } else if (JJTreeOptions.getNodeFactory().length() > 0) {
            io.println("(" + nodeClass + ")" + JJTreeOptions.getNodeFactory() + ".jjtCreate(" + parserArg + ns.node_descriptor.getNodeId() + ");");
        } else {
            io.println("new " + nodeClass + "(" + parserArg + ns.node_descriptor.getNodeId() + ");");
        }
        if (ns.usesCloseNodeVar()) {
            io.println(indent + "boolean " + ns.closedVar + " = true;");
        }
        io.println(indent + ns.node_descriptor.openNode(ns.nodeVar));
        if (JJTreeOptions.getNodeScopeHook()) {
            io.println(indent + "jjtreeOpenNodeScope(" + ns.nodeVar + ");");
        }
        if (JJTreeOptions.getTrackTokens()) {
            io.println(indent + ns.nodeVar + ".jjtSetFirstToken(getToken(1));");
        }
    }

    void insertCloseNodeCode(NodeScope ns, IO io, String indent, boolean isFinal) {
        String closeNode = ns.node_descriptor.closeNode(ns.nodeVar);
        io.println(indent + closeNode);
        if (ns.usesCloseNodeVar() && !isFinal) {
            io.println(indent + ns.closedVar + " = false;");
        }
        if (JJTreeOptions.getNodeScopeHook()) {
            int i = closeNode.lastIndexOf(",");
            io.println(indent + "if (jjtree.nodeCreated()) {");
            io.println(indent + " jjtreeCloseNodeScope(" + ns.nodeVar + ");");
            io.println(indent + "}");
        }
        if (JJTreeOptions.getTrackTokens()) {
            io.println(indent + ns.nodeVar + ".jjtSetLastToken(getToken(0));");
        }
    }

    void insertOpenNodeAction(NodeScope ns, IO io, String indent) {
        io.println(indent + "{");
        this.insertOpenNodeCode(ns, io, indent + "  ");
        io.println(indent + "}");
    }

    void insertCloseNodeAction(NodeScope ns, IO io, String indent) {
        io.println(indent + "{");
        this.insertCloseNodeCode(ns, io, indent + "  ", false);
        io.println(indent + "}");
    }

    private void insertCatchBlocks(NodeScope ns, IO io, Enumeration thrown_names, String indent) {
        if (thrown_names.hasMoreElements()) {
            io.println(indent + "} catch (Throwable " + ns.exceptionVar + ") {");
            if (ns.usesCloseNodeVar()) {
                io.println(indent + "  if (" + ns.closedVar + ") {");
                io.println(indent + "    jjtree.clearNodeScope(" + ns.nodeVar + ");");
                io.println(indent + "    " + ns.closedVar + " = false;");
                io.println(indent + "  } else {");
                io.println(indent + "    jjtree.popNode();");
                io.println(indent + "  }");
            }
            while (thrown_names.hasMoreElements()) {
                String thrown = (String)thrown_names.nextElement();
                io.println(indent + "  if (" + ns.exceptionVar + " instanceof " + thrown + ") {");
                io.println(indent + "    throw (" + thrown + ")" + ns.exceptionVar + ";");
                io.println(indent + "  }");
            }
            io.println(indent + "  throw (Error)" + ns.exceptionVar + ";");
        }
    }

    void tryTokenSequence(NodeScope ns, IO io, String indent, Token first, Token last) {
        io.println(indent + "try {");
        JavaCodeGenerator.closeJJTreeComment(io);
        Token t = first;
        while (t != last.next) {
            TokenUtils.print(t, io, "jjtThis", ns.nodeVar);
            t = t.next;
        }
        JavaCodeGenerator.openJJTreeComment(io, null);
        io.println();
        Enumeration thrown_names = ns.production.throws_list.elements();
        this.insertCatchBlocks(ns, io, thrown_names, indent);
        io.println(indent + "} finally {");
        if (ns.usesCloseNodeVar()) {
            io.println(indent + "  if (" + ns.closedVar + ") {");
            this.insertCloseNodeCode(ns, io, indent + "    ", true);
            io.println(indent + "  }");
        }
        io.println(indent + "}");
        JavaCodeGenerator.closeJJTreeComment(io);
    }

    private static void findThrown(NodeScope ns, Hashtable thrown_set, JJTreeNode expansion_unit) {
        String nt;
        ASTProduction prod;
        if (expansion_unit instanceof ASTBNFNonTerminal && (prod = (ASTProduction)JJTreeGlobals.productions.get(nt = expansion_unit.getFirstToken().image)) != null) {
            Enumeration e = prod.throws_list.elements();
            while (e.hasMoreElements()) {
                String t = (String)e.nextElement();
                thrown_set.put(t, t);
            }
        }
        for (int i = 0; i < expansion_unit.jjtGetNumChildren(); ++i) {
            JJTreeNode n = (JJTreeNode)expansion_unit.jjtGetChild(i);
            JavaCodeGenerator.findThrown(ns, thrown_set, n);
        }
    }

    void tryExpansionUnit(NodeScope ns, IO io, String indent, JJTreeNode expansion_unit) {
        io.println(indent + "try {");
        JavaCodeGenerator.closeJJTreeComment(io);
        expansion_unit.jjtAccept(this, io);
        JavaCodeGenerator.openJJTreeComment(io, null);
        io.println();
        Hashtable thrown_set = new Hashtable();
        JavaCodeGenerator.findThrown(ns, thrown_set, expansion_unit);
        Enumeration thrown_names = thrown_set.elements();
        this.insertCatchBlocks(ns, io, thrown_names, indent);
        io.println(indent + "} finally {");
        if (ns.usesCloseNodeVar()) {
            io.println(indent + "  if (" + ns.closedVar + ") {");
            this.insertCloseNodeCode(ns, io, indent + "    ", true);
            io.println(indent + "  }");
        }
        io.println(indent + "}");
        JavaCodeGenerator.closeJJTreeComment(io);
    }
}

