/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.core;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.KotlinExtensionsKt;
import org.http4k.core.Body;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\n\u0010\u001b\u001a\u00020\u0006H\u0096\u0080\u0004J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/http4k/core/MemoryBody;", "Lorg/http4k/core/Body;", "payload", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/ByteBuffer;)V", "", "(Ljava/lang/String;)V", "", "([B)V", "getPayload", "()Ljava/nio/ByteBuffer;", "text", "getText", "()Ljava/lang/String;", "text$delegate", "Lkotlin/Lazy;", "length", "", "getLength", "()Ljava/lang/Long;", "close", "", "stream", "Ljava/io/ByteArrayInputStream;", "getStream", "()Ljava/io/ByteArrayInputStream;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "http4k-core"})
public final class MemoryBody
implements Body {
    @NotNull
    private final ByteBuffer payload;
    @NotNull
    private final Lazy text$delegate;

    public MemoryBody(@NotNull ByteBuffer payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.payload = payload;
        this.text$delegate = LazyKt.lazy(() -> MemoryBody.text_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public ByteBuffer getPayload() {
        return this.payload;
    }

    public MemoryBody(@NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this(KotlinExtensionsKt.asByteBuffer(payload));
    }

    public MemoryBody(@NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        this(byteBuffer);
    }

    @Override
    @NotNull
    public String getText() {
        Lazy lazy = this.text$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public Long getLength() {
        return KotlinExtensionsKt.length(this.getPayload());
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public ByteArrayInputStream getStream() {
        byte[] byArray = this.getPayload().array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        byte[] byArray2 = byArray;
        int n = this.getPayload().position();
        int n2 = KotlinExtensionsKt.length(this.getPayload());
        return new ByteArrayInputStream(byArray2, n, n2);
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    @NotNull
    public final ByteBuffer component1() {
        return this.payload;
    }

    @NotNull
    public final MemoryBody copy(@NotNull ByteBuffer payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return new MemoryBody(payload);
    }

    public static /* synthetic */ MemoryBody copy$default(MemoryBody memoryBody, ByteBuffer byteBuffer, int n, Object object) {
        if ((n & 1) != 0) {
            byteBuffer = memoryBody.payload;
        }
        return memoryBody.copy(byteBuffer);
    }

    public int hashCode() {
        return this.payload.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemoryBody)) {
            return false;
        }
        MemoryBody memoryBody = (MemoryBody)other;
        return Intrinsics.areEqual((Object)this.payload, (Object)memoryBody.payload);
    }

    private static final String text_delegate$lambda$0(MemoryBody this$0) {
        return KotlinExtensionsKt.asString(this$0.getPayload());
    }
}

