/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.filter.cookie;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.http4k.core.cookie.Cookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/http4k/filter/cookie/LocalCookie;", "", "cookie", "Lorg/http4k/core/cookie/Cookie;", "created", "Ljava/time/Instant;", "<init>", "(Lorg/http4k/core/cookie/Cookie;Ljava/time/Instant;)V", "getCookie", "()Lorg/http4k/core/cookie/Cookie;", "getCreated", "()Ljava/time/Instant;", "isExpired", "", "now", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "http4k-core"})
@SourceDebugExtension(value={"SMAP\nclientCookies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 clientCookies.kt\norg/http4k/filter/cookie/LocalCookie\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class LocalCookie {
    @NotNull
    private final Cookie cookie;
    @NotNull
    private final Instant created;

    public LocalCookie(@NotNull Cookie cookie, @NotNull Instant created) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        this.cookie = cookie;
        this.created = created;
    }

    @NotNull
    public final Cookie getCookie() {
        return this.cookie;
    }

    @NotNull
    public final Instant getCreated() {
        return this.created;
    }

    public final boolean isExpired(@NotNull Instant now) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        Long l = this.cookie.getMaxAge();
        if (l != null) {
            long maxAge = ((Number)l).longValue();
            boolean bl2 = false;
            bl = Duration.between(this.created, now).getSeconds() >= maxAge;
        } else {
            Instant instant2 = this.cookie.getExpires();
            if (instant2 != null) {
                Instant expires = instant2;
                boolean bl3 = false;
                bl = Duration.between(this.created, now).getSeconds() > Duration.between(this.created, expires).getSeconds();
            } else {
                bl = null;
            }
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    @NotNull
    public final Cookie component1() {
        return this.cookie;
    }

    @NotNull
    public final Instant component2() {
        return this.created;
    }

    @NotNull
    public final LocalCookie copy(@NotNull Cookie cookie, @NotNull Instant created) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)created, (String)"created");
        return new LocalCookie(cookie, created);
    }

    public static /* synthetic */ LocalCookie copy$default(LocalCookie localCookie, Cookie cookie, Instant instant2, int n, Object object) {
        if ((n & 1) != 0) {
            cookie = localCookie.cookie;
        }
        if ((n & 2) != 0) {
            instant2 = localCookie.created;
        }
        return localCookie.copy(cookie, instant2);
    }

    @NotNull
    public String toString() {
        return "LocalCookie(cookie=" + this.cookie + ", created=" + this.created + ")";
    }

    public int hashCode() {
        int result = this.cookie.hashCode();
        result = result * 31 + this.created.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalCookie)) {
            return false;
        }
        LocalCookie localCookie = (LocalCookie)other;
        if (!Intrinsics.areEqual((Object)this.cookie, (Object)localCookie.cookie)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.created, (Object)localCookie.created);
    }
}

