Contributing to twa
===================

First of all, thank you for thinking about contributing to twa!

## Conduct

twa's maintainers will be respectful towards you, and you should be respectful towards them
(and towards any other contributors you happen to interact with). **Don't** assume or demean;
**do** explain and offer constructive criticism.

## Bugs

If you find a bug in twa, please open an issue (or a PR!). At the minimum, please include
the following:

1. What you ran (e.g. `twa -v -w google.com`)
2. What you expected it to do ("I expected it to audit `google.com` and `www.google.com`")
3. What it actually did ("It bricked my computer")

## Features

### Requests

To submit a feature request, create an issue. Include the following:

1. A short, clear explanation of what the feature should do
(e.g, "This feature lets `twa` audit Gopher sites")
2. A short, clear justification for why the feature should be added
(e.g., "Lots of people use Gopher, and it doesn't add too much maintenance burden")

### Development

If you've already developed a feature, feel free to open a PR. That PR should include
the same information as a feature request would: a short, clear explanation of what the new
feature does, and *why* it should be added.

Keep in mind that the first word in twa is "tiny." PRs that add significant complexity,
maintenance burden, or additional dependencies are more likely to be rejected.
