/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/clntdata.h>



class sipwxClientDataContainer : public ::wxClientDataContainer
{
public:
    sipwxClientDataContainer();
    sipwxClientDataContainer(const ::wxClientDataContainer&);
    ~sipwxClientDataContainer();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxClientDataContainer(const sipwxClientDataContainer &);
    sipwxClientDataContainer &operator = (const sipwxClientDataContainer &);
};

sipwxClientDataContainer::sipwxClientDataContainer(): ::wxClientDataContainer(), sipPySelf(SIP_NULLPTR)
{
}

sipwxClientDataContainer::sipwxClientDataContainer(const ::wxClientDataContainer& a0): ::wxClientDataContainer(a0), sipPySelf(SIP_NULLPTR)
{
}

sipwxClientDataContainer::~sipwxClientDataContainer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_wxClientDataContainer_GetClientData, "GetClientData() -> ClientData\n"
"\n"
"Get a pointer to the client data object.");

extern "C" {static PyObject *meth_wxClientDataContainer_GetClientData(PyObject *, PyObject *);}
static PyObject *meth_wxClientDataContainer_GetClientData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxClientDataContainer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxClientDataContainer, &sipCpp))
        {
            ::wxClientData*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetClientObject();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxClientData, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ClientDataContainer, sipName_GetClientData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxClientDataContainer_SetClientData, "SetClientData(data) -> None\n"
"\n"
"Set the client data object.");

extern "C" {static PyObject *meth_wxClientDataContainer_SetClientData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxClientDataContainer_SetClientData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxClientData* data;
        int dataState = 0;
        ::wxClientDataContainer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ2", &sipSelf, sipType_wxClientDataContainer, &sipCpp, sipType_wxClientData, &data, &dataState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetClientObject(data);
            Py_END_ALLOW_THREADS
            sipReleaseType(data, sipType_wxClientData, dataState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ClientDataContainer, sipName_SetClientData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxClientDataContainer(void *, int);}
static void release_wxClientDataContainer(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxClientDataContainer *>(sipCppV);
    else
        delete reinterpret_cast< ::wxClientDataContainer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxClientDataContainer(Py_ssize_t);}
static void *array_wxClientDataContainer(Py_ssize_t sipNrElem)
{
    return new ::wxClientDataContainer[sipNrElem];
}


extern "C" {static void array_delete_wxClientDataContainer(void *);}
static void array_delete_wxClientDataContainer(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxClientDataContainer *>(sipCpp);
}


extern "C" {static void assign_wxClientDataContainer(void *, Py_ssize_t, void *);}
static void assign_wxClientDataContainer(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxClientDataContainer *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxClientDataContainer *>(sipSrc);
}


extern "C" {static void *copy_wxClientDataContainer(const void *, Py_ssize_t);}
static void *copy_wxClientDataContainer(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxClientDataContainer(reinterpret_cast<const ::wxClientDataContainer *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxClientDataContainer(sipSimpleWrapper *);}
static void dealloc_wxClientDataContainer(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxClientDataContainer *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxClientDataContainer(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxClientDataContainer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxClientDataContainer(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxClientDataContainer *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxClientDataContainer();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxClientDataContainer* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxClientDataContainer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxClientDataContainer(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxClientDataContainer[] = {
    {sipName_GetClientData, meth_wxClientDataContainer_GetClientData, METH_VARARGS, doc_wxClientDataContainer_GetClientData},
    {sipName_SetClientData, SIP_MLMETH_CAST(meth_wxClientDataContainer_SetClientData), METH_VARARGS|METH_KEYWORDS, doc_wxClientDataContainer_SetClientData}
};

PyDoc_STRVAR(doc_wxClientDataContainer, "ClientDataContainer() -> None\n"
"\n"
"This class is a mixin that provides storage and management of \"client\n"
"data\".");


sipClassTypeDef sipTypeDef__core_wxClientDataContainer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxClientDataContainer,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ClientDataContainer,
        {0, 0, 1},
        2, methods_wxClientDataContainer,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxClientDataContainer,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxClientDataContainer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxClientDataContainer,
    assign_wxClientDataContainer,
    array_wxClientDataContainer,
    copy_wxClientDataContainer,
    release_wxClientDataContainer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxClientDataContainer,
    sizeof (::wxClientDataContainer),
};
