/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.compatibility;

import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.util.Lambdas;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import com.intellij.util.ui.UIUtilities;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.SunToolkit;

public final class SwingUtil {
    private static final Logger LOGGER = LogUtil.getLogger(SwingUtil.class);
    private static final PaintSynthStyle PAINT_STYLE = new PaintSynthStyle();
    private static final SynthGraphicsUtils SYNTH_GRAPHICS_UTILS = new SynthGraphicsUtils();
    private static boolean swingInteropAvailable;
    private static Class<?> swingInteropClass;
    private static final LazyValue<MethodHandle> grabMethod;
    private static final LazyValue<MethodHandle> ungrabMethod;

    private SwingUtil() {
    }

    public static boolean isSunToolkit(Toolkit toolkit) {
        return toolkit != null && SwingUtil.isInstanceOf(toolkit.getClass(), "sun.awt.SunToolkit");
    }

    public static boolean isUngrabEvent(AWTEvent event) {
        return event != null && SwingUtil.isInstanceOf(event.getClass(), "sun.awt.UngrabEvent");
    }

    private static boolean isInstanceOf(Class<?> cls, String type) {
        if (cls == null) {
            return false;
        }
        if (cls.getName().equals(type)) {
            return true;
        }
        for (Class<?> c : cls.getInterfaces()) {
            if (!c.getName().equals(type)) continue;
            return true;
        }
        return SwingUtil.isInstanceOf(cls.getSuperclass(), type);
    }

    public static void grab(Toolkit toolkit, Window window) {
        if (swingInteropAvailable) {
            try {
                ((MethodHandle)grabMethod.get()).invokeExact(toolkit, window);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).grab(window);
        }
    }

    public static void ungrab(Toolkit toolkit, Window window) {
        if (swingInteropAvailable) {
            try {
                ((MethodHandle)ungrabMethod.get()).invokeExact(toolkit, window);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        } else if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).ungrab(window);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent c, Graphics g, String text, int underlinedIndex, int x, int y) {
        FontMetrics fm = c.getFontMetrics(g.getFont());
        int adjustedY = y - fm.getAscent();
        SYNTH_GRAPHICS_UTILS.paintText(SwingUtil.createSynthContext(c), g, text, x, adjustedY, underlinedIndex);
    }

    public static void drawString(JComponent c, Graphics g, String text, int x, int y) {
        SwingUtil.drawStringUnderlineCharAt(c, g, text, -1, x, y);
    }

    public static void setSkipClickCount(Component comp, int count) {
        UIUtilities.setSkipClickCount(comp, count);
    }

    public static int stringWidth(JComponent c, FontMetrics fm, String string) {
        return UIUtilities.stringWidth(c, fm, string);
    }

    public static String clipStringIfNecessary(JComponent c, FontMetrics fm, String string, int availTextWidth) {
        return UIUtilities.clipStringIfNecessary(c, fm, string, availTextWidth);
    }

    public static int getFocusAcceleratorKeyMask() {
        if (SystemInfo.isMac) {
            return 10;
        }
        return 8;
    }

    public static FontMetrics getFontMetrics(JComponent c, Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException("Graphics must not be null");
        }
        return SwingUtil.getFontMetrics(c, g.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent c, Font font) {
        if (c == null) {
            throw new IllegalArgumentException("Component must not be null");
        }
        if (font == null) {
            throw new IllegalArgumentException("Font must not be null");
        }
        return c.getFontMetrics(font);
    }

    public static boolean shouldIgnore(MouseEvent me, JComponent c) {
        return c == null || !c.isEnabled() || !SwingUtilities.isLeftMouseButton(me) || me.isConsumed();
    }

    public static void adjustFocus(JComponent c) {
        if (!c.hasFocus() && c.isRequestFocusEnabled()) {
            c.requestFocus();
        }
    }

    public static void compositeRequestFocus(Component component) {
        UIUtilities.compositeRequestFocus(component);
    }

    public static void setLeadAnchorWithoutSelection(ListSelectionModel model, int lead, int anchor) {
        UIUtilities.setLeadAnchorWithoutSelection(model, lead, anchor);
    }

    public static boolean pointOutsidePrefSize(JTable table, int row, int column, Point p) {
        return UIUtilities.pointOutsidePrefSize(table, row, column, p);
    }

    public static boolean tabbedPaneChangeFocusTo(Component comp) {
        return UIUtilities.tabbedPaneChangeFocusTo(comp);
    }

    public static int loc2IndexFileList(JList<?> list, Point point) {
        return UIUtilities.loc2IndexFileList(list, point);
    }

    private static SynthContext createSynthContext(JComponent c) {
        return new SynthContext(c, Region.LABEL, PAINT_STYLE, 1024);
    }

    static {
        grabMethod = new LazyValue(Lambdas.orDefault(() -> MethodHandles.lookup().findStatic(swingInteropClass, "grab", MethodType.methodType(Void.TYPE, Toolkit.class, Window.class)), null));
        ungrabMethod = new LazyValue(Lambdas.orDefault(() -> MethodHandles.lookup().findStatic(swingInteropClass, "ungrab", MethodType.methodType(Void.TYPE, Toolkit.class, Window.class)), null));
        try {
            swingInteropClass = Class.forName("jdk.swing.interop.SwingInterOpUtils");
            swingInteropAvailable = true;
        }
        catch (Throwable e) {
            swingInteropAvailable = false;
        }
        LOGGER.fine("SwingInterOpUtils available: " + swingInteropAvailable);
    }

    private static class PaintSynthStyle
    extends SynthStyle {
        private PaintSynthStyle() {
        }

        @Override
        protected Color getColorForState(SynthContext context, ColorType type) {
            return null;
        }

        @Override
        protected Font getFontForState(SynthContext context) {
            return null;
        }
    }
}

