/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.dmx;

import com.jgoodies.binding.beans.Model;
import java.awt.Color;
import org.bidib.wizard.model.dmx.DmxChannelWrapper;
import org.bidib.wizard.model.dmx.DmxDimmer;

public class DmxChannel
extends Model {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DMX_CHANNEL_WRAPPER = "dmxChannelWrapper";
    public static final String PROPERTY_INITIAL_STATE = "intialState";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    public static final String PROPERTY_CHANNEL_NAME = "channelName";
    private int initialState;
    private Color lineColor;
    private String channelName;
    private final DmxDimmer dmxDimmer;
    private DmxChannelWrapper dmxChannelWrapper;

    public DmxChannel(DmxDimmer dmxDimmer, DmxChannelWrapper dmxChannelWrapper) {
        this.dmxDimmer = dmxDimmer;
        this.dmxChannelWrapper = dmxChannelWrapper;
    }

    public DmxChannel withDmxChannelWrapper(DmxChannelWrapper dmxChannelWrapper) {
        this.setDmxChannelWrapper(dmxChannelWrapper);
        return this;
    }

    public DmxChannel withInitialState(int initialState) {
        this.setInitialState(initialState);
        return this;
    }

    public DmxChannel withLineColor(Color lineColor) {
        this.setLineColor(lineColor);
        return this;
    }

    public DmxChannel withChannelName(String channelName) {
        this.setChannelName(channelName);
        return this;
    }

    public DmxDimmer getDmxDimmer() {
        return this.dmxDimmer;
    }

    public void setDmxChannelWrapper(DmxChannelWrapper dmxChannelWrapper) {
        DmxChannelWrapper oldValue = this.dmxChannelWrapper;
        this.dmxChannelWrapper = dmxChannelWrapper;
        this.firePropertyChange(PROPERTY_DMX_CHANNEL_WRAPPER, (Object)oldValue, (Object)this.dmxChannelWrapper);
    }

    public DmxChannelWrapper getDmxChannelWrapper() {
        return this.dmxChannelWrapper;
    }

    public static DmxChannel from(DmxChannel source) {
        DmxChannel dmxChannel = new DmxChannel(source.dmxDimmer, source.dmxChannelWrapper).withInitialState(source.initialState).withLineColor(source.lineColor).withChannelName(source.channelName);
        return dmxChannel;
    }

    public void to(DmxChannel target) {
        target.withDmxChannelWrapper(this.dmxChannelWrapper).withInitialState(this.initialState).withLineColor(this.lineColor).withChannelName(this.channelName);
    }

    private Integer getDmxChannelId() {
        if (this.dmxChannelWrapper != null) {
            return this.dmxChannelWrapper.getDmxChannelId();
        }
        return null;
    }

    public int getInitialState() {
        return this.initialState;
    }

    public void setInitialState(int initialState) {
        int oldValue = this.initialState;
        this.initialState = initialState;
        this.firePropertyChange(PROPERTY_INITIAL_STATE, oldValue, this.initialState);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        Color oldValue = this.lineColor;
        this.lineColor = lineColor;
        this.firePropertyChange(PROPERTY_LINE_COLOR, oldValue, this.lineColor);
    }

    public void setChannelName(String channelName) {
        String oldValue = this.channelName;
        this.channelName = channelName;
        this.firePropertyChange(PROPERTY_CHANNEL_NAME, oldValue, this.channelName);
    }

    public String getChannelName() {
        return this.channelName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DmxChannel) {
            return this.getDmxChannelId() == ((DmxChannel)((Object)obj)).getDmxChannelId();
        }
        return false;
    }

    public int hashCode() {
        return this.getDmxChannelId();
    }

    public String toString() {
        Object result = null;
        result = this.getDmxChannelId() != null ? "Channel " + this.getDmxChannelId() : "";
        return result;
    }
}

