/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.dmx;

import com.jgoodies.binding.beans.Model;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bidib.wizard.model.dmx.DmxChannel;
import org.bidib.wizard.model.dmx.DmxChannelWrapper;
import org.bidib.wizard.model.dmx.LineColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxDimmer
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxDimmer.class);
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_DMX_CHANNELS = "dmxChannels";
    private final String id;
    private String name;
    private final List<DmxChannel> dmxChannels = new ArrayList<DmxChannel>();

    public DmxDimmer(String id) {
        this.id = id;
    }

    public DmxDimmer() {
        this(UUID.randomUUID().toString());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public List<DmxChannel> getDmxChannels() {
        return this.dmxChannels;
    }

    public void setDmxChannels(List<DmxChannel> dmxChannels) {
        ArrayList<DmxChannel> oldValue = new ArrayList<DmxChannel>(this.dmxChannels);
        LOGGER.info("Set dmxChannels: {}", dmxChannels);
        this.dmxChannels.clear();
        this.dmxChannels.addAll(dmxChannels);
        this.firePropertyChange(PROPERTY_DMX_CHANNELS, oldValue, Collections.unmodifiableList(this.dmxChannels));
    }

    public void addDmxChannel(DmxChannel dmxChannel) {
        ArrayList<DmxChannel> oldValue = new ArrayList<DmxChannel>(this.dmxChannels);
        this.dmxChannels.add(dmxChannel);
        this.firePropertyChange(PROPERTY_DMX_CHANNELS, oldValue, Collections.unmodifiableList(this.dmxChannels));
    }

    public void removeDmxChannel(DmxChannel dmxChannel) {
        ArrayList<DmxChannel> oldValue = new ArrayList<DmxChannel>(this.dmxChannels);
        this.dmxChannels.remove((Object)dmxChannel);
        this.firePropertyChange(PROPERTY_DMX_CHANNELS, oldValue, Collections.unmodifiableList(this.dmxChannels));
    }

    public String toString() {
        return "DmxDimmer[name=" + this.name + ",id=" + this.id;
    }

    public DmxDimmer withName(String name) {
        this.setName(name);
        return this;
    }

    public DmxDimmer withNumberOfChannels(int channelCount, List<DmxChannelWrapper> availableChannelIds) {
        block9: {
            int existingChannelCount;
            block8: {
                existingChannelCount = this.dmxChannels.size();
                if (channelCount <= existingChannelCount) break block8;
                for (int channelId = existingChannelCount; channelId < channelCount; ++channelId) {
                    DmxChannelWrapper dmxChannelId = availableChannelIds.get(channelId - existingChannelCount);
                    DmxChannel dmxChannel = new DmxChannel(this, dmxChannelId);
                    switch (channelId) {
                        case 0: {
                            dmxChannel.setLineColor(LineColors.RED.getDisplayColor());
                            break;
                        }
                        case 1: {
                            dmxChannel.setLineColor(LineColors.GREEN.getDisplayColor());
                            break;
                        }
                        case 2: {
                            dmxChannel.setLineColor(LineColors.BLUE.getDisplayColor());
                            break;
                        }
                        case 3: {
                            dmxChannel.setLineColor(LineColors.WHITE.getDisplayColor());
                            break;
                        }
                        default: {
                            dmxChannel.setLineColor(LineColors.WARMWHITE.getDisplayColor());
                        }
                    }
                    LOGGER.info("Add channel: {}", (Object)dmxChannel);
                    this.addDmxChannel(dmxChannel);
                }
                break block9;
            }
            if (channelCount >= existingChannelCount) break block9;
            for (int channelId = existingChannelCount - 1; channelId >= channelCount; --channelId) {
                DmxChannel dmxChannel = this.dmxChannels.get(channelId);
                LOGGER.info("Remove channel: {}", (Object)dmxChannel);
                this.removeDmxChannel(dmxChannel);
            }
        }
        return this;
    }
}

