/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.loco;

import com.jgoodies.common.bean.Bean;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.wizard.model.loco.listener.LocoModelListener;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.model.status.BinStateValue;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.RfBasisMode;
import org.bidib.wizard.model.status.SpeedSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoModel
extends Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoModel.class);
    public static final String PROPERTY_ADDRESS = "address";
    public static final String PROPERTY_LOCO_NAME = "locoName";
    public static final String PROPERTY_LOCO_LIST_MODEL = "locoListModel";
    public static final String PROPERTY_SPEED = "speed";
    public static final String PROPERTY_SPEED_STEPS = "speedSteps";
    public static final String PROPERTY_DIRECTION = "direction";
    public static final String PROPERTY_REPORTED_SPEED = "reportedSpeed";
    public static final String PROPERTY_DRIVE_ACKNOWLEDGE = "driveAcknowledge";
    public static final String PROPERTY_DRIVE_ACKNOWLEDGE_COUNTER = "driveAcknowledgeCounter";
    public static final String PROPERTY_DYNSTATE_ENERGY = "dynStateEnergy";
    public static final String PROPERTY_ACTIVE_BASE = "activeBase";
    public static final String PROPERTY_REPORTED_CELLNUMBER = "reportedCellNumber";
    public static final String PROPERTYNAME_DEV_BINSTATE_NUMBER = "devBinStateNumber";
    public static final String PROPERTYNAME_DEV_BINSTATE_VALUE = "devBinStateValue";
    public static final String PROPERTYNAME_COUNTER_CS_DRIVE = "counterCsDrive";
    public static final String PROPERTYNAME_COUNTER_CS_DRIVE_ACK = "counterCsDriveAck";
    public static final String PROPERTYNAME_COUNTER_CS_BIN_STATE = "counterCsBinState";
    public static final int FUNCTIONINDEX_LIGHTS = 0;
    private LocoListModel llm;
    private int dynStateEnergy;
    private RfBasisMode activeBase = RfBasisMode.SINGLE;
    private RfBasisMode prevActiveBase;
    private Integer reportedCellNumber;
    private Integer devBinStateNumber;
    private BinStateValue devBinStateValue = BinStateValue.ON;
    private AtomicInteger counterCsDrive = new AtomicInteger();
    private AtomicInteger counterCsDriveAck = new AtomicInteger();
    private AtomicInteger counterCsBinState = new AtomicInteger();
    private final Collection<LocoModelListener> listeners = new LinkedList<LocoModelListener>();
    private final PropertyChangeListener listener;

    public LocoModel(LocoListModel llm) {
        this.llm = llm;
        LOGGER.info("Create new LocoModel, llm: {}", (Object)llm);
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Received pce: {}", (Object)evt);
                LocoModel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        this.addPropertyChangeListener();
    }

    public void cleanup() {
        LOGGER.info("Cleanup the locoModel, remove propertyChangeListener, llm: {}", (Object)this.llm);
        this.removePropertyChangeListener();
    }

    public void setLocoListModel(LocoListModel llm) {
        LOGGER.info("Set new LocoListModel, llm: {}", (Object)llm);
        LocoListModel oldValue = this.llm;
        this.removePropertyChangeListener();
        this.llm = llm;
        this.addPropertyChangeListener();
        this.firePropertyChange(PROPERTY_LOCO_LIST_MODEL, (Object)oldValue, (Object)this.llm);
        this.firePropertyChange(PROPERTY_ADDRESS, oldValue != null ? Integer.valueOf(oldValue.getAddress()) : null, this.llm != null ? Integer.valueOf(this.llm.getAddress()) : null);
        this.firePropertyChange(PROPERTY_SPEED_STEPS, oldValue != null ? oldValue.getSpeedSteps() : null, this.llm != null ? this.llm.getSpeedSteps() : null);
        this.firePropertyChange(PROPERTY_SPEED, oldValue != null ? Integer.valueOf(oldValue.getSpeed()) : null, this.llm != null ? Integer.valueOf(this.llm.getSpeed()) : null);
    }

    public LocoListModel getLocoListModel() {
        return this.llm;
    }

    private void removePropertyChangeListener() {
        if (this.llm != null) {
            this.llm.removePropertyChangeListener(this.listener);
        }
    }

    private void addPropertyChangeListener() {
        if (this.llm != null) {
            this.llm.addPropertyChangeListener(this.listener);
        }
    }

    public void addLocoModelListener(LocoModelListener l) {
        this.listeners.add(l);
    }

    public void removeLocoModelListener(LocoModelListener l) {
        this.listeners.remove(l);
    }

    public Integer getAddress() {
        if (this.llm != null) {
            return this.llm.getAddress();
        }
        return null;
    }

    public String getLocoName() {
        if (this.llm != null) {
            return this.llm.getLocoName();
        }
        return null;
    }

    public void setLocoName(String locoName) {
        if (this.llm != null) {
            String oldValue = this.llm.getLocoName();
            this.llm.setLocoName(locoName);
            this.firePropertyChange(PROPERTY_LOCO_NAME, oldValue, locoName);
        }
    }

    public Integer getReportedSpeed() {
        if (this.llm != null) {
            return this.llm.getReportedSpeed();
        }
        return null;
    }

    public void setReportedSpeed(Integer reportedSpeed) {
        LOGGER.debug("Update the reported speed: {}", (Object)reportedSpeed);
        if (this.llm != null) {
            Integer oldValue = this.llm.getReportedSpeed();
            this.llm.setReportedSpeed(reportedSpeed);
            this.firePropertyChange(PROPERTY_REPORTED_SPEED, oldValue, reportedSpeed);
        }
    }

    public DriveAcknowledge getDriveAcknowledge() {
        if (this.llm != null) {
            return this.llm.getDriveAcknowledge();
        }
        return null;
    }

    public void setDriveAcknowledge(DriveAcknowledge driveAcknowledge) {
        if (this.llm != null) {
            DriveAcknowledge oldValue = this.llm.getDriveAcknowledge();
            this.llm.setDriveAcknowledge(driveAcknowledge);
            this.firePropertyChange(PROPERTY_DRIVE_ACKNOWLEDGE, oldValue, driveAcknowledge);
        }
    }

    public Integer getDriveAcknowledgeCounter() {
        if (this.llm != null) {
            return this.llm.getDriveAcknowledgeCounter();
        }
        return null;
    }

    public void setDriveAcknowledgeCounter(Integer driveAcknowledgeCounter) {
        if (this.llm != null) {
            Integer oldValue = this.llm.getDriveAcknowledgeCounter();
            this.llm.setDriveAcknowledgeCounter(driveAcknowledgeCounter);
            this.firePropertyChange(PROPERTY_DRIVE_ACKNOWLEDGE_COUNTER, oldValue, driveAcknowledgeCounter);
        }
    }

    public DirectionStatus getDirection() {
        if (this.llm != null) {
            return this.llm.getDirection();
        }
        return null;
    }

    public void setDirection(DirectionStatus direction) {
        if (this.llm != null) {
            DirectionStatus oldValue = this.llm.getDirection();
            this.llm.setDirection(direction);
            this.firePropertyChange(PROPERTY_DIRECTION, oldValue, direction);
        }
    }

    public SpeedSteps getSpeedSteps() {
        if (this.llm != null) {
            return this.llm.getSpeedSteps();
        }
        return null;
    }

    public void setSpeedSteps(SpeedSteps speedSteps) {
        if (this.llm != null) {
            SpeedSteps oldValue = this.llm.getSpeedSteps();
            this.llm.setSpeedSteps(speedSteps);
            this.firePropertyChange(PROPERTY_SPEED_STEPS, oldValue, speedSteps);
        }
    }

    public Integer getSpeed() {
        if (this.llm != null) {
            return this.llm.getSpeed();
        }
        return null;
    }

    public void setSpeed(Integer speed) {
        if (this.llm != null) {
            Integer oldValue = this.llm.getSpeed();
            LOGGER.debug("Set the new speed: {}, oldValue: {}", (Object)speed, (Object)oldValue);
            this.llm.setSpeed(speed != null ? speed : 0);
            if (speed != null && (speed == 0 || speed == 1)) {
                oldValue = null;
            }
            this.firePropertyChange(PROPERTY_SPEED, oldValue, speed);
        }
    }

    public boolean getFunction(int index) {
        if (this.llm != null) {
            return this.llm.getFunction(index);
        }
        return false;
    }

    public BitSet getFunctions() {
        if (this.llm != null) {
            return this.llm.getFunctions();
        }
        return null;
    }

    public void setFunction(int index, boolean value) {
        if (this.llm != null) {
            this.llm.setFunction(index, value);
        }
        this.fireFunctionChanged(index, value);
    }

    public void setFunctions(BitSet functions) {
        if (this.llm != null) {
            this.llm.setFunctions(functions);
        }
    }

    public int getDynStateEnergy() {
        return this.dynStateEnergy;
    }

    public void setDynStateEnergy(int dynStateEnergy) {
        int oldValue = this.dynStateEnergy;
        this.dynStateEnergy = dynStateEnergy;
        this.firePropertyChange(PROPERTY_DYNSTATE_ENERGY, oldValue, dynStateEnergy);
    }

    private void fireFunctionChanged(int index, boolean value) {
        for (LocoModelListener l : this.listeners) {
            l.functionChanged(index, value);
        }
    }

    private void fireBinaryStateChanged(int state, boolean value) {
        for (LocoModelListener l : this.listeners) {
            l.binaryStateChanged(state, value);
        }
    }

    public void setBinaryState(int state, boolean value) {
        this.fireBinaryStateChanged(state, value);
    }

    public RfBasisMode getActiveBase() {
        return this.activeBase;
    }

    public void setActiveBase(RfBasisMode activeBase) {
        LOGGER.info("Set the new active rf base: {}", (Object)activeBase);
        RfBasisMode oldValue = this.activeBase;
        if (this.activeBase != activeBase) {
            LOGGER.info("The new active rf base has changed. Update the prev active base: {}", (Object)this.activeBase);
            this.prevActiveBase = this.activeBase;
        }
        this.activeBase = activeBase;
        this.firePropertyChange(PROPERTY_ACTIVE_BASE, (Object)oldValue, (Object)activeBase);
    }

    public RfBasisMode getPrevActiveBase() {
        return this.prevActiveBase;
    }

    public void resetPrevActiveBase() {
        this.prevActiveBase = null;
    }

    public Integer getReportedCellNumber() {
        return this.reportedCellNumber;
    }

    public void setReportedCellNumber(Integer reportedCellNumber) {
        Integer oldValue = this.reportedCellNumber;
        this.reportedCellNumber = reportedCellNumber;
        this.firePropertyChange(PROPERTY_REPORTED_CELLNUMBER, oldValue, this.reportedCellNumber);
    }

    public Integer getDevBinStateNumber() {
        return this.devBinStateNumber;
    }

    public void setDevBinStateNumber(Integer devBinStateNumber) {
        Integer oldValue = this.devBinStateNumber;
        this.devBinStateNumber = devBinStateNumber;
        this.firePropertyChange(PROPERTYNAME_DEV_BINSTATE_NUMBER, oldValue, devBinStateNumber);
    }

    public BinStateValue getDevBinStateValue() {
        return this.devBinStateValue;
    }

    public void setDevBinStateValue(BinStateValue devBinStateValue) {
        BinStateValue oldValue = this.devBinStateValue;
        this.devBinStateValue = devBinStateValue;
        this.firePropertyChange(PROPERTYNAME_DEV_BINSTATE_VALUE, (Object)oldValue, (Object)devBinStateValue);
    }

    public int getCounterCsDrive() {
        return this.counterCsDrive.get();
    }

    public int incCounterCsDrive() {
        int oldValue = this.counterCsDrive.get();
        int newValue = this.counterCsDrive.addAndGet(1);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE, oldValue, newValue);
        return newValue;
    }

    public void resetCounterCsDrive() {
        int oldValue = this.counterCsDrive.get();
        this.counterCsDrive.set(0);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE, oldValue, 0);
    }

    public int getCounterCsDriveAck() {
        return this.counterCsDriveAck.get();
    }

    public int incCounterCsDriveAck() {
        int oldValue = this.counterCsDriveAck.get();
        int newValue = this.counterCsDriveAck.addAndGet(1);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE_ACK, oldValue, newValue);
        return newValue;
    }

    public void resetCounterCsAckDrive() {
        int oldValue = this.counterCsDriveAck.get();
        this.counterCsDriveAck.set(0);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE_ACK, oldValue, 0);
    }

    public int getCounterCsBinState() {
        return this.counterCsBinState.get();
    }

    public int incCounterCsBinState() {
        int oldValue = this.counterCsBinState.get();
        int newValue = this.counterCsBinState.addAndGet(1);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_BIN_STATE, oldValue, newValue);
        return newValue;
    }

    public void resetCounterCsBinState() {
        int oldValue = this.counterCsBinState.get();
        this.counterCsBinState.set(0);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_BIN_STATE, oldValue, 0);
    }

    public String toString() {
        return "LocoModel, llm: " + this.llm + ", lights on: " + this.getFunction(0);
    }
}

