/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.locolist;

import com.jgoodies.binding.beans.Model;
import java.util.BitSet;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoListModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoListModel.class);
    public static final String PROPERTY_ADDRESS = "address";
    public static final String PROPERTY_LOCO_NAME = "locoName";
    public static final String PROPERTY_SPEED = "speed";
    public static final String PROPERTY_SPEED_STEPS = "speedSteps";
    public static final String PROPERTY_DIRECTION = "direction";
    public static final String PROPERTY_REPORTED_SPEED = "reportedSpeed";
    public static final String PROPERTY_DRIVE_ACKNOWLEDGE = "driveAcknowledge";
    public static final String PROPERTY_DRIVE_ACKNOWLEDGE_COUNTER = "driveAcknowledgeCounter";
    public static final String PROPERTY_OUTPUT_ACTIVE = "outputActive";
    public static final String PROPERTY_FUNCTIONS = "functions";
    private final int address;
    private String locoName;
    private boolean outputActive;
    private int dynStateEnergy;
    private Integer reportedSpeed;
    private DriveAcknowledge driveAcknowledge;
    private Integer driveAcknowledgeCounter;
    private DirectionStatus direction = DirectionStatus.FORWARD;
    private int speed;
    private SpeedSteps speedSteps = SpeedSteps.DCC128;
    private final BitSet functions = new BitSet(29);

    public LocoListModel(int locoAddress) {
        this.address = locoAddress;
        LOGGER.debug("Create new LocoModel for address: {}", (Object)this.address);
    }

    public int getAddress() {
        return this.address;
    }

    public String getLocoName() {
        return this.locoName;
    }

    public void setLocoName(String locoName) {
        String oldValue = this.locoName;
        this.locoName = locoName;
        this.firePropertyChange(PROPERTY_LOCO_NAME, oldValue, this.locoName);
    }

    public boolean isOutputActive() {
        return this.outputActive;
    }

    public void setOutputActive(boolean outputActive) {
        boolean oldValue = this.outputActive;
        this.outputActive = outputActive;
        this.firePropertyChange(PROPERTY_OUTPUT_ACTIVE, oldValue, this.outputActive);
    }

    public int getDynStateEnergy() {
        return this.dynStateEnergy;
    }

    public void setDynStateEnergy(int dynStateEnergy) {
        this.dynStateEnergy = dynStateEnergy;
    }

    public DirectionStatus getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionStatus direction) {
        DirectionStatus oldValue = this.direction;
        this.direction = direction;
        this.firePropertyChange(PROPERTY_DIRECTION, oldValue, this.direction);
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        int oldValue = this.speed;
        LOGGER.debug("Set the speed: {}", (Object)speed);
        this.speed = speed;
        this.firePropertyChange(PROPERTY_SPEED, oldValue, this.speed);
    }

    public SpeedSteps getSpeedSteps() {
        return this.speedSteps;
    }

    public void setSpeedSteps(SpeedSteps speedSteps) {
        SpeedSteps oldValue = this.speedSteps;
        this.speedSteps = speedSteps;
        this.firePropertyChange(PROPERTY_SPEED_STEPS, oldValue, this.speedSteps);
    }

    public BitSet getFunctions() {
        return this.functions;
    }

    public int getFunctions(int groupIndex) {
        byte[] convertFunctions = ConversionUtils.convertFunctions((BitSet)this.getFunctions());
        return ByteUtils.getInt((byte)convertFunctions[groupIndex]);
    }

    public void setFunctions(BitSet functions) {
        BitSet oldValue = new BitSet(29);
        oldValue.or(this.functions);
        this.functions.clear();
        this.functions.or(functions);
        this.firePropertyChange(PROPERTY_FUNCTIONS, oldValue, this.functions);
    }

    public void setFunction(int index, boolean value) {
        BitSet oldValue = new BitSet(29);
        oldValue.or(this.functions);
        this.functions.set(index, value);
        this.firePropertyChange(PROPERTY_FUNCTIONS, oldValue, this.functions);
    }

    public boolean getFunction(int index) {
        return this.functions.get(index);
    }

    public Integer getReportedSpeed() {
        return this.reportedSpeed;
    }

    public void setReportedSpeed(Integer reportedSpeed) {
        LOGGER.debug("Update the reported speed: {}", (Object)reportedSpeed);
        Integer oldValue = this.reportedSpeed;
        this.reportedSpeed = reportedSpeed;
        this.firePropertyChange(PROPERTY_REPORTED_SPEED, oldValue, reportedSpeed);
    }

    public DriveAcknowledge getDriveAcknowledge() {
        return this.driveAcknowledge;
    }

    public void setDriveAcknowledge(DriveAcknowledge driveAcknowledge) {
        DriveAcknowledge oldValue = this.driveAcknowledge;
        this.driveAcknowledge = driveAcknowledge;
        this.firePropertyChange(PROPERTY_DRIVE_ACKNOWLEDGE, oldValue, driveAcknowledge);
        this.incDriveAcknowledgeCounter();
    }

    public Integer getDriveAcknowledgeCounter() {
        return this.driveAcknowledgeCounter;
    }

    public void incDriveAcknowledgeCounter() {
        Integer oldValue = this.driveAcknowledgeCounter;
        this.driveAcknowledgeCounter = oldValue != null ? oldValue + 1 : 0;
        this.firePropertyChange(PROPERTY_DRIVE_ACKNOWLEDGE_COUNTER, oldValue, this.driveAcknowledgeCounter);
    }

    public void setDriveAcknowledgeCounter(Integer driveAcknowledgeCounter) {
        Integer oldValue = this.driveAcknowledgeCounter;
        this.driveAcknowledgeCounter = driveAcknowledgeCounter;
        this.firePropertyChange(PROPERTY_DRIVE_ACKNOWLEDGE_COUNTER, oldValue, driveAcknowledgeCounter);
    }

    public boolean equals(Object other) {
        if (other instanceof LocoListModel) {
            return this.address == ((LocoListModel)((Object)other)).address;
        }
        return false;
    }

    public int hashCode() {
        return this.address;
    }

    public String toString() {
        return "LocoListModel[address: " + this.address + ", locoName: " + this.locoName + ", speed: " + this.speed + ", reportedSpeed: " + this.reportedSpeed + ", functions: " + this.functions + ", driveAcknowledgeCounter: " + this.driveAcknowledgeCounter + "]";
    }
}

