/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.enums.BacklightPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ValuePort;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightPort
extends Port<BacklightPortStatus>
implements ValuePort {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPort.class);
    public static final int DIMM_STRETCHMAX8_8 = 65535;
    public static final int DIMM_STRETCHMAX8 = 255;
    public static final String PROPERTY_DIM_SLOPE_UP = "dimSlopeUp";
    public static final String PROPERTY_DIM_SLOPE_DOWN = "dimSlopeDown";
    public static final String PROPERTY_DIM_STRETCH_MAX = "dimStretchMax";
    public static final String PROPERTY_DIM_STRETCH_MIN = "dimStretchMin";
    public static final String PROPERTY_DMX_MAPPING = "dmxMapping";
    public static final String PROPERTYNAME_VALUE = "value";
    public static final BacklightPort NONE = new LabelBuilder(-1).setLabel("<none>").build();
    private int dimSlopeUp;
    private int dimSlopeDown;
    private int dimStretchMax = 255;
    private int dimStretchMin = 255;
    private Integer dmxMapping;
    private Integer value;
    private Integer preAdjustingValue;
    private boolean adjusting;
    private Integer expectedTargetValue;

    public BacklightPort() {
        this((GenericPort)null);
    }

    public BacklightPort(GenericPort genericPort) {
        super(genericPort);
    }

    private BacklightPort(Builder builder) {
        super(builder);
        this.dmxMapping = builder.dmxMapping;
        this.dimSlopeUp = builder.dimSlopeUp;
        this.dimSlopeDown = builder.dimSlopeDown;
        this.dimStretchMax = builder.dimStretchMax;
        this.dimStretchMin = builder.dimStretchMin;
        this.value = builder.value;
    }

    private BacklightPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    public int getDimSlopeUp() {
        return this.dimSlopeUp;
    }

    public void setDimSlopeUp(int dimSlopeUp) {
        int oldValue = this.dimSlopeUp;
        this.dimSlopeUp = dimSlopeUp;
        this.firePropertyChange(PROPERTY_DIM_SLOPE_UP, oldValue, this.dimSlopeUp);
    }

    public int getDimSlopeDown() {
        return this.dimSlopeDown;
    }

    public void setDimSlopeDown(int dimSlopeDown) {
        int oldValue = this.dimSlopeDown;
        this.dimSlopeDown = dimSlopeDown;
        this.firePropertyChange(PROPERTY_DIM_SLOPE_DOWN, oldValue, this.dimSlopeDown);
    }

    public Integer getDmxMapping() {
        LOGGER.trace("Return the dmxMapping: {}", (Object)this.dmxMapping);
        return this.dmxMapping;
    }

    public void setDmxMapping(Integer dmxMapping) {
        LOGGER.trace("Set the dmxMapping: {}", (Object)dmxMapping);
        Integer oldValue = this.dmxMapping;
        this.dmxMapping = dmxMapping;
        this.firePropertyChange(PROPERTY_DMX_MAPPING, oldValue, this.dmxMapping);
    }

    public int getDimStretchMax() {
        return this.dimStretchMax;
    }

    public void setDimStretchMax(int dimStretchMax) {
        int oldValue = this.dimStretchMax;
        this.dimStretchMax = dimStretchMax;
        this.firePropertyChange(PROPERTY_DIM_STRETCH_MAX, oldValue, this.dimStretchMax);
    }

    public int getDimStretchMin() {
        return this.dimStretchMin;
    }

    public void setDimStretchMin(int dimStretchMin) {
        int oldValue = this.dimStretchMin;
        this.dimStretchMin = dimStretchMin;
        this.firePropertyChange(PROPERTY_DIM_STRETCH_MIN, oldValue, this.dimStretchMin);
    }

    @Override
    public Integer getValue() {
        if (this.genericPort != null) {
            Integer portVal = this.genericPort.getPortValue();
            this.value = portVal != null ? portVal : Integer.valueOf(0);
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        Integer oldValue = this.value;
        this.value = value;
        if (this.genericPort != null) {
            this.genericPort.setPortValue(value);
        }
        this.firePropertyChange(PROPERTYNAME_VALUE, oldValue, this.value);
    }

    public void setValue(Integer value, boolean force) {
        if (force || this.getPreAdjustingValue() == null) {
            LOGGER.info("Set the new value to port: {}", (Object)value);
            this.setValue(value);
        } else if (value == this.expectedTargetValue) {
            LOGGER.info("Set the new value to port because the expected target value is reached: {}", (Object)value);
            this.value = value;
            this.expectedTargetValue = null;
            this.setPreAdjustingValue(null);
        } else {
            LOGGER.info("Prevent set value because adjusting: {}", (Object)value);
        }
    }

    public static int getAbsoluteValue(int value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("The allowed range is 0-100. Provided value: " + value);
        }
        int stepWidth = value * 255 / 100;
        return stepWidth;
    }

    public static int getRelativeValue(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("The allowed range is 0-255. Provided value: " + value);
        }
        long result = Math.round((double)value * 100.0 / 255.0);
        return (int)result;
    }

    public int getRelativeValue() {
        if (this.value != null) {
            long result = Math.round(this.value.doubleValue() * 100.0 / 255.0);
            return (int)result;
        }
        return 0;
    }

    public Integer getPreAdjustingValue() {
        return this.preAdjustingValue;
    }

    public void setPreAdjustingValue(Integer preAdjustingValue) {
        LOGGER.info("Set the preAdjusting value: {}", (Object)preAdjustingValue);
        this.preAdjustingValue = preAdjustingValue;
    }

    public Integer getExpectedTargetValue() {
        return this.expectedTargetValue;
    }

    public void setExpectedTargetValue(Integer expectedTargetValue) {
        this.expectedTargetValue = expectedTargetValue;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public void setAdjusting(boolean adjusting) {
        this.adjusting = adjusting;
    }

    @Override
    public String getDebugString() {
        return this.getClass().getSimpleName() + "[dimSlopeDown=" + this.dimSlopeDown + ",dimSlopeUp=" + this.dimSlopeUp + ",dmxMapping=" + this.dmxMapping + ",value=" + this.value + ",preAdjustingValue=" + this.preAdjustingValue + ",adjusting=" + this.adjusting + "]";
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{ByteUtils.getLowByte((int)this.dimSlopeDown), ByteUtils.getLowByte((int)this.dimSlopeUp), ByteUtils.getLowByte((Integer)this.dmxMapping), 0};
    }

    public void setPortConfig(int dimSlopeDown, int dimSlopeUp, int dmxMapping) {
        LOGGER.trace("Set port config, id: {}, dimSlopeDown: {}, dimSlopeUp: {}, dmxMapping: {}", new Object[]{this.getId(), dimSlopeDown, dimSlopeUp, dmxMapping});
        this.setDimSlopeDown(dimSlopeDown);
        this.getKnownPortConfigKeys().add((byte)68);
        this.setDimSlopeUp(dimSlopeUp);
        this.getKnownPortConfigKeys().add((byte)67);
        this.setDmxMapping(dmxMapping);
        this.getKnownPortConfigKeys().add((byte)6);
    }

    public void setPortConfig(byte[] portConfig) {
        LOGGER.info("Set the backlight port parameters: {}", (Object)ByteUtils.bytesToHex((byte[])portConfig));
        this.setPortConfigEnabled(true);
        this.setDimSlopeDown(ByteUtils.getInt((byte)portConfig[0]));
        this.getKnownPortConfigKeys().add((byte)68);
        this.setDimSlopeUp(ByteUtils.getInt((byte)portConfig[1]));
        this.getKnownPortConfigKeys().add((byte)67);
        this.setDmxMapping(ByteUtils.getInt((byte)portConfig[2]));
        this.getKnownPortConfigKeys().add((byte)6);
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        Number dimMax = (Number)this.getPortConfigValue((byte)67, portConfig);
        if (dimMax != null) {
            this.setDimSlopeUp(ByteUtils.getWORD((int)dimMax.intValue()));
            this.setDimStretchMax(65535);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_DIMM_UP_8_8!");
        }
        Number dimMin = (Number)this.getPortConfigValue((byte)68, portConfig);
        if (dimMin != null) {
            this.setDimSlopeDown(ByteUtils.getWORD((int)dimMin.intValue()));
            this.setDimStretchMin(65535);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_DIMM_DOWN_8_8!");
        }
        Number outputMap = (Number)this.getPortConfigValue((byte)6, portConfig);
        if (outputMap != null) {
            this.setDmxMapping(ByteUtils.getInt((byte)outputMap.byteValue()));
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_OUTPUT_MAP!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported((byte)67)) {
            portConfigX.put((byte)67, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(this.dimSlopeUp)));
        } else if (this.isPortConfigKeySupported((byte)3)) {
            portConfigX.put((byte)3, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.dimSlopeUp))));
        } else {
            LOGGER.warn("No DIMM_UP config available.");
        }
        if (this.isPortConfigKeySupported((byte)68)) {
            portConfigX.put((byte)68, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(this.dimSlopeDown)));
        } else if (this.isPortConfigKeySupported((byte)4)) {
            portConfigX.put((byte)4, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.dimSlopeDown))));
        } else {
            LOGGER.warn("No DIMM_DOWN config available.");
        }
        if (this.isPortConfigKeySupported((byte)6)) {
            portConfigX.put((byte)6, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)this.dmxMapping)));
        }
        return portConfigX;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BacklightPort) {
            return ((BacklightPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.BACKLIGHTPORT;
    }

    @Override
    protected BacklightPortStatus internalGetStatus(GenericPort genericPort) {
        return BacklightPortStatus.valueOf(BacklightPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static BacklightPort clonePort(BacklightPort bp) {
        BacklightPort backlightPort = (BacklightPort)BacklightPort.builder().withDmxMapping(bp.getDmxMapping()).withDimSlopeDown(bp.getDimSlopeDown()).withDimSlopeUp(bp.getDimSlopeUp()).withDimStretchMax(bp.getDimStretchMax()).withDimStretchMin(bp.getDimStretchMin()).withId(bp.getId()).withConfigStatus(bp.getConfigStatus()).withEnabled(bp.isEnabled()).withGenericPort(bp.getGenericPort()).withIsInactive(bp.isInactive()).withKnownPortConfigKeys(bp.getKnownPortConfigKeys()).withLabel(bp.getLabel()).withPortConfigEnabled(bp.isPortConfigEnabled()).withPortConfigErrorCode(bp.getPortConfigErrorCode()).withPortIdentifier(bp.getPortIdentifier()).withRemappingEnabled(bp.isRemappingEnabled()).withStatus((BacklightPortStatus)bp.getStatus()).build();
        return backlightPort;
    }

    public static final class Builder
    extends Port.Builder<BacklightPort, BacklightPortStatus> {
        private Integer dmxMapping;
        private int dimSlopeDown;
        private int dimSlopeUp;
        private int dimStretchMax;
        private int dimStretchMin;
        private Integer value;

        public Builder withDmxMapping(Integer dmxMapping) {
            this.dmxMapping = dmxMapping;
            return this;
        }

        public Builder withDimSlopeDown(int dimSlopeDown) {
            this.dimSlopeDown = dimSlopeDown;
            return this;
        }

        public Builder withDimSlopeUp(int dimSlopeUp) {
            this.dimSlopeUp = dimSlopeUp;
            return this;
        }

        public Builder withDimStretchMax(int dimStretchMax) {
            this.dimStretchMax = dimStretchMax;
            return this;
        }

        public Builder withDimStretchMin(int dimStretchMin) {
            this.dimStretchMin = dimStretchMin;
            return this;
        }

        public Builder withValue(Integer value) {
            this.value = value;
            return this;
        }

        @Override
        public BacklightPort build() {
            return new BacklightPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public BacklightPort build() {
            return new BacklightPort(this);
        }
    }
}

