/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.model.dmx.DmxChannel;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.LightPortStatus;

public class DmxLightPort
extends Port<LightPortStatus> {
    private static final long serialVersionUID = 1L;
    private final LightPort lightPort;
    private DmxChannel dmxTargetChannel;
    private final transient PropertyChangeListener listener;

    public DmxLightPort(LightPort lightPort) {
        super((GenericPort)null);
        this.lightPort = lightPort;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DmxLightPort.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        this.lightPort.addPropertyChangeListener(this.listener);
    }

    public void freeLightPort() {
        this.lightPort.removePropertyChangeListener(this.listener);
    }

    public LightPort getLightPort() {
        return this.lightPort;
    }

    public DmxChannel getDmxTargetChannel() {
        return this.dmxTargetChannel;
    }

    public void setDmxTargetChannel(DmxChannel dmxTargetChannel) {
        this.dmxTargetChannel = dmxTargetChannel;
    }

    @Override
    public int getId() {
        return this.lightPort.getId();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DmxLightPort) {
            return ((DmxLightPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    @Override
    public byte[] getPortConfig() {
        return this.lightPort.getPortConfig();
    }

    @Override
    public String getLabel() {
        return this.lightPort.getLabel();
    }

    @Override
    public LightPortStatus getStatus() {
        return (LightPortStatus)this.lightPort.getStatus();
    }

    @Override
    public void setStatus(LightPortStatus status) {
        this.lightPort.setStatus(status);
    }

    @Override
    public String toString() {
        return this.lightPort.toString();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.LIGHTPORT;
    }

    @Override
    protected LightPortStatus internalGetStatus(GenericPort genericPort) {
        return (LightPortStatus)this.lightPort.getStatus();
    }

    @Override
    public boolean isPortConfigKeySupported(Byte key) {
        return this.lightPort.isPortConfigKeySupported(key);
    }

    @Override
    public boolean isPortConfigKeySupported(byte[] keys) {
        return this.lightPort.isPortConfigKeySupported(keys);
    }
}

