/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.FeedbackConfidenceData;
import org.bidib.jbidibc.messages.FeedbackDynStateData;
import org.bidib.jbidibc.messages.FeedbackTimestampData;
import org.bidib.jbidibc.messages.enums.FeedbackPortEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;

public class FeedbackPort
extends Port<FeedbackPortStatus> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ADDRESSES = "addresses";
    public static final String PROPERTY_DYNSTATES = "dynStates";
    public static final int GLOBAL_FEEDBACK_PORT_NUMBER = 255;
    private final List<FeedbackAddressData> addresses;
    private final Set<FeedbackDynStateData> dynStates;
    private FeedbackTimestampData timestamp;
    private FeedbackConfidenceData confidence;
    private final Object dynStateLock = new Object();

    public FeedbackPort() {
        super((GenericPort)null);
        this.addresses = new LinkedList<FeedbackAddressData>();
        this.dynStates = new HashSet<FeedbackDynStateData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeedbackAddressData> getAddresses() {
        Object object = this.dynStateLock;
        synchronized (object) {
            return Collections.unmodifiableList(new ArrayList<FeedbackAddressData>(this.addresses));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddresses(List<FeedbackAddressData> addresses) {
        Object object = this.dynStateLock;
        synchronized (object) {
            this.addresses.clear();
            if (CollectionUtils.isNotEmpty(addresses)) {
                this.addresses.addAll(addresses);
            }
        }
        this.firePropertyChange(PROPERTY_ADDRESSES, null, this.addresses);
    }

    public FeedbackConfidenceData getConfidence() {
        return this.confidence;
    }

    public void setConfidence(FeedbackConfidenceData confidence) {
        this.confidence = confidence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FeedbackDynStateData> getDynStates() {
        Object object = this.dynStateLock;
        synchronized (object) {
            return Collections.unmodifiableSet(new HashSet<FeedbackDynStateData>(this.dynStates));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynStates(List<FeedbackDynStateData> dynStates) {
        Object object = this.dynStateLock;
        synchronized (object) {
            for (FeedbackDynStateData data : dynStates) {
                this.dynStates.remove(data);
                this.dynStates.add(data);
            }
        }
        this.firePropertyChange(PROPERTY_DYNSTATES, null, this.dynStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDynStates() {
        Object object = this.dynStateLock;
        synchronized (object) {
            this.dynStates.clear();
        }
        this.firePropertyChange(PROPERTY_DYNSTATES, null, this.dynStates);
    }

    public FeedbackTimestampData getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(FeedbackTimestampData timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void setStatus(FeedbackPortStatus status) {
        super.setStatus(status);
        if (FeedbackPortStatus.FREE.equals(status)) {
            this.clearDynStates();
            this.setAddresses(null);
            this.setTimestamp(null);
        }
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{0, 0, 0, 0};
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FeedbackPort) {
            return ((FeedbackPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.FEEDBACKPORT;
    }

    @Override
    protected FeedbackPortStatus internalGetStatus(GenericPort genericPort) {
        return FeedbackPortStatus.valueOf(FeedbackPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }
}

