/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LocalPortConfigStatus;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.enums.PortConfigStatus;
import org.bidib.jbidibc.messages.port.PortConfigUtils;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.PortMapUtils;
import org.bidib.jbidibc.messages.port.ReconfigPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.collections4.MapUtils;
import org.bidib.wizard.model.ports.ConfigEvent;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPort
implements PortTypeAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericPort.class);
    public static final String PROPERTY_CONFIG_STATUS = "configStatus";
    public static final String PROPERTY_LOCAL_CONFIG_STATUS = "localConfigStatus";
    public static final String PROPERTY_PORT_CONFIG_ERRORCODE = "portConfigErrorCode";
    public static final String PROPERTY_PORT_INACTIVE = "isInactive";
    public static final String PROPERTY_PORT_TYPE_CHANGED = "portTypeChanged";
    public static final String PROPERTY_PORT_CONFIG_CHANGED = "portConfigChanged";
    public static final String PROPERTY_PORT_STATUS = "portStatus";
    public static final String PROPERTY_PORT_VALUE = "portValue";
    private transient PropertyChangeSupport pcs;
    private Integer portNumber;
    private Map<Byte, PortConfigValue<?>> portConfig = new HashMap();
    private transient Set<Byte> knownPortConfigKeys = new HashSet<Byte>();
    private PortConfigStatus configStatus = PortConfigStatus.CONFIG_PENDING;
    private LocalPortConfigStatus localConfigStatus = LocalPortConfigStatus.CONFIG_NA;
    private Integer portConfigErrorCode;
    private byte portStatus;
    private Integer portValue;
    private boolean isInactive;
    private transient WeakReference<GenericPort> pairedPortMaster;

    private GenericPort(Builder builder) {
        this(builder.portNumber);
        if (MapUtils.isNotEmpty(builder.portConfig)) {
            this.portConfig.putAll(builder.portConfig);
        } else {
            LOGGER.warn("No port config available for port number: {}", (Object)this.portNumber);
        }
        if (CollectionUtils.isNotEmpty(builder.knownPortConfigKeys)) {
            this.knownPortConfigKeys.addAll(builder.knownPortConfigKeys);
        }
        this.configStatus = builder.configStatus;
        this.portConfigErrorCode = builder.portConfigErrorCode;
        this.portStatus = builder.portStatus;
        this.portValue = builder.portValue;
        this.isInactive = builder.isInactive;
        this.pairedPortMaster = builder.pairedPortMaster;
    }

    public GenericPort(Integer portNumber) {
        this.portNumber = portNumber;
    }

    @Override
    public Integer getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    public LcOutputType getCurrentPortType() {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)this.getPortConfigX((byte)-127);
        if (reconfig != null) {
            return reconfig.getCurrentOutputType();
        }
        return null;
    }

    @Override
    public LcOutputType getPortType() {
        return this.getCurrentPortType();
    }

    public boolean isMatchingPortType(LcOutputType requiredPortType) {
        if (requiredPortType == null) {
            throw new IllegalArgumentException("requiredPortType must not be null");
        }
        LcOutputType currentPortType = this.getCurrentPortType();
        LOGGER.trace("isMatchingPortType for requiredPortType: {}, currentPortType: {}, portNumber: {}", new Object[]{requiredPortType, currentPortType, this.portNumber});
        if (currentPortType == null) {
            return true;
        }
        boolean matchingTypeSelf = requiredPortType.equals((Object)currentPortType);
        if (matchingTypeSelf && this.pairedPortMaster != null && this.pairedPortMaster.get() != null) {
            matchingTypeSelf = ((GenericPort)this.pairedPortMaster.get()).isMatchingPortType(requiredPortType);
        }
        return matchingTypeSelf;
    }

    public boolean isRemappingEnabled() {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)this.getPortConfigX((byte)-127);
        if (reconfig != null) {
            return PortMapUtils.supportsPortRemapping((ReconfigPortConfigValue)reconfig);
        }
        return false;
    }

    public PortConfigStatus getConfigStatus() {
        return this.configStatus;
    }

    public void setConfigStatus(PortConfigStatus configStatus) {
        PortConfigStatus oldValue = this.configStatus;
        this.configStatus = configStatus;
        LOGGER.info("New port configStatus: {}", (Object)configStatus);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_CONFIG_STATUS, new ConfigEvent(this.portNumber, oldValue), new ConfigEvent(this.portNumber, this.configStatus));
        }
    }

    public void setLocalConfigStatus(LocalPortConfigStatus localConfigStatus) {
        LocalPortConfigStatus oldValue = this.localConfigStatus;
        this.localConfigStatus = localConfigStatus;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_LOCAL_CONFIG_STATUS, new ConfigEvent(this.portNumber, oldValue), new ConfigEvent(this.portNumber, this.localConfigStatus));
        }
    }

    public LocalPortConfigStatus getLocalConfigStatus() {
        return this.localConfigStatus;
    }

    public Integer getPortConfigErrorCode() {
        return this.portConfigErrorCode;
    }

    public void setPortConfigErrorCode(Integer portConfigErrorCode) {
        Integer oldValue = this.portConfigErrorCode;
        LOGGER.info("Set the portConfigErrorCode: {}, port number: {}", (Object)portConfigErrorCode, (Object)this.portNumber);
        this.portConfigErrorCode = portConfigErrorCode;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_PORT_CONFIG_ERRORCODE, new ConfigEvent(this.portNumber, oldValue), new ConfigEvent(this.portNumber, this.portConfigErrorCode));
        }
    }

    public void clearPortConfig() {
        this.portConfig.clear();
    }

    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        boolean moreToContinue;
        LcOutputType newPortType;
        LcOutputType currentPortType;
        LOGGER.info("Set the port config: {}", portConfig);
        this.getKnownPortConfigKeys().clear();
        Collections.addAll(this.getKnownPortConfigKeys(), portConfig.keySet().toArray(new Byte[0]));
        boolean changedPortTypeDetected = false;
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)portConfig.get((byte)-127);
        if (reconfig != null) {
            currentPortType = this.getCurrentPortType();
            if (!Objects.equals(currentPortType, newPortType = reconfig.getCurrentOutputType())) {
                LOGGER.info("The port type has changed from: {}, to: {}", (Object)currentPortType, (Object)newPortType);
                changedPortTypeDetected = true;
                this.portStatus = ByteUtils.getLowByte((int)0);
                this.portValue = null;
                LOGGER.info("Port type changed. Clear the current port config.");
                this.portConfig.clear();
            }
        } else {
            currentPortType = null;
            newPortType = null;
        }
        this.updatePortConfigValues(portConfig);
        if (changedPortTypeDetected && this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_PORT_TYPE_CHANGED, currentPortType, newPortType);
        }
        if (moreToContinue = portConfig.containsKey((byte)-1)) {
            LOGGER.info("An additional message with more config will follow.");
            this.setConfigStatus(PortConfigStatus.CONFIG_PENDING);
        } else {
            this.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        }
        Number noneErrorCode = (Number)this.getPortConfigValue((byte)0, portConfig);
        if (noneErrorCode != null) {
            int errorCode = ByteUtils.getInt((byte)noneErrorCode.byteValue());
            LOGGER.error("The returned port config has signaled an error: {}", (Object)errorCode);
            if (errorCode > 0) {
                this.setPortConfigErrorCode(errorCode);
                this.setConfigStatus(PortConfigStatus.CONFIG_ERROR);
            }
        }
    }

    private void updatePortConfigValues(Map<Byte, PortConfigValue<?>> portConfig) {
        boolean valuesChanged = false;
        for (Map.Entry<Byte, PortConfigValue<?>> entry : portConfig.entrySet()) {
            PortConfigValue<?> value = this.portConfig.get(entry.getKey());
            if (value != null && value.equals(entry.getValue())) continue;
            LOGGER.debug("Changed port config value detected, old: {}, new: {}", value, entry.getValue());
            valuesChanged = true;
            break;
        }
        Map<Byte, PortConfigValue<?>> currentPortConfigX = this.getPortConfigX();
        LOGGER.info("==> Port config before update: {}", currentPortConfigX);
        try {
            portConfig.entrySet().stream().filter(e -> (Byte)e.getKey() != 0).forEach(e -> GenericPort.updatePortConfigValue(this.portConfig, e));
        }
        catch (Exception ex) {
            LOGGER.warn("Update port config failed.", (Throwable)ex);
        }
        LOGGER.info("==> Port config after update: {}", this.portConfig);
        if (valuesChanged && this.pcs != null) {
            LOGGER.info("Notify the changed port config values.");
            this.pcs.firePropertyChange(PROPERTY_PORT_CONFIG_CHANGED, false, true);
        }
    }

    private static void updatePortConfigValue(Map<Byte, PortConfigValue<?>> portConfig, Map.Entry<Byte, PortConfigValue<?>> e) {
        portConfig.put(e.getKey(), e.getValue());
    }

    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        HashMap values = new HashMap();
        values.putAll(this.portConfig);
        return values;
    }

    public Set<Byte> getKnownPortConfigKeys() {
        return this.knownPortConfigKeys;
    }

    public void setKnownPortConfigKeys(Set<Byte> knownPortConfigKeys) {
        this.knownPortConfigKeys.clear();
        this.knownPortConfigKeys.addAll(knownPortConfigKeys);
    }

    public boolean isPortConfigKeySupported(Byte key) {
        return this.knownPortConfigKeys.contains(key);
    }

    public boolean isPortConfigKeySupported(PortConfigKeys key) {
        return this.knownPortConfigKeys.contains(key.getType());
    }

    protected void setPortConfigValue(Byte key, PortConfigValue<?> value) {
        try {
            PortConfigValue<?> portConfigValue = this.portConfig.get(key);
            if (portConfigValue != null) {
                LOGGER.info("Replace old portConfigValue: {} for key: {} with new value: {}", new Object[]{portConfigValue, ByteUtils.byteToHex((Byte)key), value});
            }
            this.portConfig.put(key, value);
        }
        catch (ClassCastException ex) {
            LOGGER.warn("Cast value of key: {} to target type failed.", (Object)key, (Object)ex);
        }
    }

    protected void removePortConfigValue(Byte key) {
        LOGGER.info("Remove port config value with key: {}", (Object)key);
        this.portConfig.remove(key);
    }

    protected <T> T getPortConfigValue(Byte key) {
        try {
            PortConfigValue<?> portConfigValue = this.portConfig.get(key);
            if (portConfigValue != null) {
                return (T)this.portConfig.get(key).getValue();
            }
        }
        catch (ClassCastException ex) {
            LOGGER.warn("Cast value of key: {} to target type failed.", (Object)key, (Object)ex);
        }
        return null;
    }

    protected <T> T getPortConfigValue(Byte key, Map<Byte, PortConfigValue<?>> portConfig) {
        try {
            PortConfigValue<?> portConfigValue = portConfig.get(key);
            if (portConfigValue != null) {
                return (T)portConfig.get(key).getValue();
            }
        }
        catch (ClassCastException ex) {
            LOGGER.warn("Cast value of key: {} to target type failed.", (Object)key, (Object)ex);
        }
        return null;
    }

    protected <T> T getPortConfigX(Byte key) {
        try {
            PortConfigValue<?> portConfigValue = this.portConfig.get(key);
            if (portConfigValue != null) {
                return (T)this.portConfig.get(key);
            }
        }
        catch (ClassCastException ex) {
            LOGGER.warn("Cast value of key: {} to target type failed.", (Object)key, (Object)ex);
        }
        return null;
    }

    public boolean isHasPortConfig(Byte key) {
        boolean hasPortConfig = this.portConfig.containsKey(key);
        LOGGER.info("The generic port has port config for key '{}': {}", (Object)key.intValue(), (Object)hasPortConfig);
        return hasPortConfig;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.pcs == null) {
            this.pcs = this.createPropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.pcs == null) {
            return;
        }
        this.pcs.removePropertyChangeListener(listener);
    }

    protected PropertyChangeSupport createPropertyChangeSupport(Object bean) {
        return new PropertyChangeSupport(bean);
    }

    public boolean isSupportsSwitchPort() {
        boolean isSupportsSwitchPort = PortConfigUtils.isSupportsSwitchPort(this.portConfig);
        return isSupportsSwitchPort;
    }

    public boolean isSupportsSwitchPairPort() {
        boolean isSupportsSwitchPairPort = PortConfigUtils.isSupportsSwitchPairPort(this.portConfig);
        return isSupportsSwitchPairPort;
    }

    public boolean isSupportsInputPort() {
        boolean isSupportsInputPort = PortConfigUtils.isSupportsInputPort(this.portConfig);
        return isSupportsInputPort;
    }

    public boolean isSupportsAnalogPort() {
        boolean isSupportsAnalogPort = PortConfigUtils.isSupportsAnalogPort(this.portConfig);
        return isSupportsAnalogPort;
    }

    public boolean isSupportsServoPort() {
        boolean isSupportsServoPort = PortConfigUtils.isSupportsServoPort(this.portConfig);
        return isSupportsServoPort;
    }

    public boolean isSupportsLightPort() {
        boolean isSupportsLightPort = PortConfigUtils.isSupportsLightPort(this.portConfig);
        return isSupportsLightPort;
    }

    public boolean isSupportsBacklightPort() {
        boolean isSupportsBacklightPort = PortConfigUtils.isSupportsBacklightPort(this.portConfig);
        return isSupportsBacklightPort;
    }

    public boolean isSupportsMotorPort() {
        boolean isSupportsMotorPort = PortConfigUtils.isSupportsMotorPort(this.portConfig);
        return isSupportsMotorPort;
    }

    public boolean isSupportsSoundPort() {
        boolean isSupportsMotorPort = PortConfigUtils.isSupportsSoundPort(this.portConfig);
        return isSupportsMotorPort;
    }

    public Integer getSupportedPortTypes() {
        ReconfigPortConfigValue reconfig = (ReconfigPortConfigValue)this.getPortConfigX((byte)-127);
        if (reconfig != null) {
            return reconfig.getPortMap();
        }
        return null;
    }

    public byte getPortStatus() {
        return this.portStatus;
    }

    public void setPortStatus(byte portStatus) {
        LOGGER.info("Set portStatus: {}, port: {}", (Object)portStatus, (Object)this);
        byte oldValue = this.portStatus;
        this.portStatus = portStatus;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_PORT_STATUS, oldValue, portStatus);
        }
    }

    public Integer getPortValue() {
        return this.portValue;
    }

    public void setPortValue(Integer portValue) {
        Integer oldValue = this.portValue;
        this.portValue = portValue;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_PORT_VALUE, oldValue, this.portValue);
        }
    }

    public boolean isInactive() {
        return this.isInactive;
    }

    public void setInactive(boolean isInactive) {
        boolean oldValue = this.isInactive;
        this.isInactive = isInactive;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROPERTY_PORT_INACTIVE, oldValue, isInactive);
        }
    }

    public WeakReference<GenericPort> getPairedPortMaster() {
        return this.pairedPortMaster;
    }

    public void setPairedPortMaster(WeakReference<GenericPort> pairedPortMaster) {
        LOGGER.info("Set the paired port master: {}", pairedPortMaster);
        this.pairedPortMaster = pairedPortMaster;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer portNumber;
        private Map<Byte, PortConfigValue<?>> portConfig = Collections.emptyMap();
        private Set<Byte> knownPortConfigKeys = Collections.emptySet();
        private PortConfigStatus configStatus;
        private Integer portConfigErrorCode;
        private byte portStatus;
        private Integer portValue;
        private boolean isInactive;
        private WeakReference<GenericPort> pairedPortMaster;

        private Builder() {
        }

        public Builder withPortNumber(Integer portNumber) {
            this.portNumber = portNumber;
            return this;
        }

        public Builder withPortConfig(Map<Byte, PortConfigValue<?>> portConfig) {
            this.portConfig = portConfig;
            return this;
        }

        public Builder withKnownPortConfigKeys(Set<Byte> knownPortConfigKeys) {
            this.knownPortConfigKeys = knownPortConfigKeys;
            return this;
        }

        public Builder withConfigStatus(PortConfigStatus configStatus) {
            this.configStatus = configStatus;
            return this;
        }

        public Builder withPortConfigErrorCode(Integer portConfigErrorCode) {
            this.portConfigErrorCode = portConfigErrorCode;
            return this;
        }

        public Builder withPortStatus(byte portStatus) {
            this.portStatus = portStatus;
            return this;
        }

        public Builder withPortValue(Integer portValue) {
            this.portValue = portValue;
            return this;
        }

        public Builder withIsInactive(boolean isInactive) {
            this.isInactive = isInactive;
            return this;
        }

        public Builder withPairedPortMaster(WeakReference<GenericPort> pairedPortMaster) {
            this.pairedPortMaster = pairedPortMaster;
            return this;
        }

        public GenericPort build() {
            return new GenericPort(this);
        }
    }
}

