/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.InputPortEnum;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.TicksAware;
import org.bidib.wizard.model.status.InputPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPort
extends Port<InputPortStatus>
implements ConfigurablePort<InputPortStatus>,
TicksAware {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPort.class);
    public static final String PROPERTYNAME_SWITCHOFFTIME = "switchOffTime";
    public static final String PROPERTYNAME_INPUTBEHAVIOUR = "inputBehaviour";
    public static final InputPort NONE = new LabelBuilder(-1).setLabel("<none>").build();
    private IoBehaviourInputEnum inputBehaviour = IoBehaviourInputEnum.UNKNOWN;
    private Integer switchOffTime;
    private transient boolean hasInputPortConfig;

    public InputPort() {
        this((GenericPort)null);
    }

    public InputPort(GenericPort genericPort) {
        super(genericPort);
    }

    private InputPort(Builder builder) {
        super(builder);
        this.inputBehaviour = builder.inputBehaviour;
        this.switchOffTime = builder.switchOffTime;
        this.hasInputPortConfig = builder.hasInputPortConfig;
    }

    private InputPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.INPUTPORT;
    }

    @Override
    protected InputPortStatus internalGetStatus(GenericPort genericPort) {
        InputPortStatus portStat = InputPortStatus.valueOf(InputPortEnum.valueOf((byte)genericPort.getPortStatus()));
        LOGGER.debug("Prepared internal status: {}", (Object)portStat);
        return portStat;
    }

    public IoBehaviourInputEnum getInputBehaviour() {
        if (this.genericPort != null) {
            if (this.isEnabled()) {
                Number inputBehaviour = (Number)this.genericPort.getPortConfigValue(BidibLibrary.BIDIB_PCFG_INPUT_CTRL);
                if (inputBehaviour != null) {
                    try {
                        this.inputBehaviour = IoBehaviourInputEnum.valueOf((byte)inputBehaviour.byteValue());
                        LOGGER.debug("Prepared inputBehaviour from value: {}, inputBehaviour: {}", (Object)ByteUtils.byteToHex((byte)inputBehaviour.byteValue()), (Object)this.inputBehaviour);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Get inputBehaviour failed on port: {}, inputBehaviour: {}", (Object)this.genericPort.getPortNumber(), (Object)inputBehaviour);
                        this.inputBehaviour = IoBehaviourInputEnum.UNKNOWN;
                    }
                } else {
                    LOGGER.debug("No value received from generic port for BIDIB_PCFG_INPUT_CTRL!");
                    this.inputBehaviour = IoBehaviourInputEnum.UNKNOWN;
                }
            } else {
                LOGGER.debug("The current port is not enabled, return UNKNOWN.");
                this.inputBehaviour = IoBehaviourInputEnum.UNKNOWN;
            }
        }
        return this.inputBehaviour;
    }

    public void setInputBehaviour(IoBehaviourInputEnum inputBehaviour) {
        LOGGER.info("Set inputBehaviour: {}", (Object)inputBehaviour);
        IoBehaviourInputEnum oldValue = this.inputBehaviour;
        this.inputBehaviour = inputBehaviour;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(inputBehaviour.getType())));
        }
        this.firePropertyChange(PROPERTYNAME_INPUTBEHAVIOUR, oldValue, this.inputBehaviour);
    }

    @Override
    public Integer getTicks() {
        return this.getSwitchOffTime();
    }

    public Integer getSwitchOffTime() {
        if (this.genericPort != null) {
            Number switchOffTime = (Number)this.genericPort.getPortConfigValue((byte)11);
            if (switchOffTime != null) {
                this.switchOffTime = ByteUtils.getInt((byte)switchOffTime.byteValue());
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_TICKS!");
            }
        }
        return this.switchOffTime;
    }

    public void setSwitchOffTime(Integer switchOffTime) {
        LOGGER.info("Set switchOff time: {}", (Object)switchOffTime);
        Integer oldValue = this.switchOffTime;
        this.switchOffTime = switchOffTime;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchOffTime)));
        }
        this.firePropertyChange(PROPERTYNAME_SWITCHOFFTIME, oldValue, this.switchOffTime);
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{0, 0, 0, 0};
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port config for the input port.");
        Number inputBehaviour = (Number)this.getPortConfigValue(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, portConfig);
        if (inputBehaviour != null) {
            this.setInputBehaviour(IoBehaviourInputEnum.valueOf((byte)inputBehaviour.byteValue()));
            this.setHasInputPortConfig(true);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_INPUT_CTRL!");
        }
        Number switchOffTime = (Number)this.getPortConfigValue((byte)11, portConfig);
        if (switchOffTime != null) {
            this.setSwitchOffTime(ByteUtils.getInt((byte)switchOffTime.byteValue()));
            this.setHasInputPortConfig(true);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_TICKS!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_INPUT_CTRL)) {
            portConfigX.put(BidibLibrary.BIDIB_PCFG_INPUT_CTRL, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.inputBehaviour.getType()))));
        }
        if (this.isPortConfigKeySupported((byte)11)) {
            portConfigX.put((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)this.switchOffTime)));
        }
        return portConfigX;
    }

    public boolean isHasInputPortConfig() {
        if (this.genericPort != null) {
            this.hasInputPortConfig = this.genericPort.isHasPortConfig(BidibLibrary.BIDIB_PCFG_INPUT_CTRL);
            LOGGER.info("The generic port has input port config: {}", (Object)this.hasInputPortConfig);
        }
        return this.hasInputPortConfig;
    }

    public void setHasInputPortConfig(boolean hasInputPortConfig) {
        LOGGER.info("The port has input port config available: {}, port: {}", (Object)hasInputPortConfig, (Object)this);
        this.hasInputPortConfig = hasInputPortConfig;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InputPort) {
            return ((InputPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InputPort clonePort(InputPort ip) {
        InputPort inputPort = (InputPort)InputPort.builder().withInputBehaviour(ip.getInputBehaviour()).withSwitchOffTime(ip.getSwitchOffTime()).withHasInputPortConfig(ip.isHasInputPortConfig()).withId(ip.getId()).withConfigStatus(ip.getConfigStatus()).withEnabled(ip.isEnabled()).withGenericPort(ip.getGenericPort()).withIsInactive(ip.isInactive()).withKnownPortConfigKeys(ip.getKnownPortConfigKeys()).withLabel(ip.getLabel()).withPortConfigEnabled(ip.isPortConfigEnabled()).withPortConfigErrorCode(ip.getPortConfigErrorCode()).withPortIdentifier(ip.getPortIdentifier()).withRemappingEnabled(ip.isRemappingEnabled()).withStatus((InputPortStatus)ip.getStatus()).build();
        return inputPort;
    }

    public static final class Builder
    extends Port.Builder<InputPort, InputPortStatus> {
        private IoBehaviourInputEnum inputBehaviour;
        private Integer switchOffTime;
        private boolean hasInputPortConfig;

        private Builder() {
        }

        public Builder withInputBehaviour(IoBehaviourInputEnum inputBehaviour) {
            this.inputBehaviour = inputBehaviour;
            return this;
        }

        public Builder withSwitchOffTime(Integer switchOffTime) {
            this.switchOffTime = switchOffTime;
            return this;
        }

        public Builder withHasInputPortConfig(boolean hasInputPortConfig) {
            this.hasInputPortConfig = hasInputPortConfig;
            return this;
        }

        @Override
        public InputPort build() {
            return new InputPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public InputPort build() {
            return new InputPort(this);
        }
    }
}

