/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LightPortEnum;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.Int16PortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.port.RgbPortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.StatusPort;
import org.bidib.wizard.model.status.LightPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPort
extends Port<LightPortStatus>
implements ConfigurablePort<LightPortStatus>,
StatusPort<LightPortStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPort.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_DIM_MAX = "dimMax";
    public static final String PROPERTY_DIM_MIN = "dimMin";
    public static final String PROPERTY_DIM_STRETCH_MAX = "dimStretchMax";
    public static final String PROPERTY_DIM_STRETCH_MIN = "dimStretchMin";
    public static final String PROPERTY_PWM_MAX = "pwmMax";
    public static final String PROPERTY_PWM_MIN = "pwmMin";
    public static final String PROPERTY_RGB_VALUE = "rgbValue";
    public static final String PROPERTY_TRANSITION_TIME = "transitionTime";
    public static final String PROPERTY_DMX_MAPPING = "dmxMapping";
    public static final int DIMM_STRETCHMAX8_8 = 65535;
    public static final int DIMM_STRETCHMAX8 = 255;
    private int dimMax;
    private int dimStretchMax = 255;
    private int dimMin;
    private int dimStretchMin = 255;
    private int pwmMax;
    private int pwmMin;
    private Integer rgbValue;
    private Integer transitionTime;
    private Integer dmxMapping;
    public static final LightPort NONE = new LabelBuilder(-1).setLabel("<none>").build();

    public LightPort() {
        this((GenericPort)null);
    }

    public LightPort(GenericPort genericPort) {
        super(genericPort);
    }

    private LightPort(Builder builder) {
        super(builder);
        this.rgbValue = builder.rgbValue;
        this.dmxMapping = builder.dmxMapping;
        this.transitionTime = builder.transitionTime;
        this.dimMax = builder.dimMax;
        this.dimMin = builder.dimMin;
        this.dimStretchMax = builder.dimStretchMax;
        this.dimStretchMin = builder.dimStretchMin;
        this.pwmMax = builder.pwmMax;
        this.pwmMin = builder.pwmMin;
    }

    private LightPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    public int getDimMax() {
        if (this.genericPort != null) {
            Number dimMax = null;
            if (this.isPortConfigKeySupported((byte)67)) {
                dimMax = (Number)this.genericPort.getPortConfigValue((byte)67);
            } else if (this.isPortConfigKeySupported((byte)3)) {
                dimMax = (Number)this.genericPort.getPortConfigValue((byte)3);
            } else {
                LOGGER.debug("No value received from generic port for BIDIB_PCFG_DIMM_UP!");
            }
            if (dimMax != null) {
                this.dimMax = dimMax instanceof Byte ? ByteUtils.getInt((byte)dimMax.byteValue()) : dimMax.intValue();
            }
        }
        return this.dimMax;
    }

    public void setDimMax(int dimMax) {
        int oldValue = this.getDimMax();
        LOGGER.trace("Set new dimMax: {}, oldValue: {}", (Object)dimMax, (Object)oldValue);
        this.dimMax = dimMax;
        if (this.genericPort != null) {
            if (this.isPortConfigKeySupported((byte)67)) {
                this.genericPort.setPortConfigValue((byte)67, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimMax))));
            } else {
                this.genericPort.setPortConfigValue((byte)3, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimMax))));
            }
        }
        this.firePropertyChange(PROPERTY_DIM_MAX, oldValue, this.dimMax);
    }

    public void setDimMax8_8(int dimMax) {
        int oldValue = this.getDimMax();
        LOGGER.trace("Set new dimMax8_8: {}, oldValue: {}", (Object)dimMax, (Object)oldValue);
        this.dimMax = dimMax;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)67, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(dimMax)));
        }
        this.firePropertyChange(PROPERTY_DIM_MAX, oldValue, this.dimMax);
    }

    public int getDimMin() {
        if (this.genericPort != null) {
            Number dimMin = null;
            if (this.isPortConfigKeySupported((byte)68)) {
                dimMin = (Number)this.genericPort.getPortConfigValue((byte)68);
            } else if (this.isPortConfigKeySupported((byte)4)) {
                dimMin = (Number)this.genericPort.getPortConfigValue((byte)4);
            } else {
                LOGGER.debug("No value received from generic port for BIDIB_PCFG_DIMM_DOWN!");
            }
            if (dimMin != null) {
                this.dimMin = dimMin instanceof Byte ? ByteUtils.getInt((byte)dimMin.byteValue()) : dimMin.intValue();
            }
        }
        return this.dimMin;
    }

    public void setDimMin(int dimMin) {
        int oldValue = this.getDimMin();
        LOGGER.trace("Set new dimMin: {}, oldValue: {}", (Object)dimMin, (Object)oldValue);
        this.dimMin = dimMin;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)4, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)dimMin))));
        }
        this.firePropertyChange(PROPERTY_DIM_MIN, oldValue, this.dimMin);
    }

    public void setDimMin8_8(int dimMin) {
        int oldValue = this.getDimMin();
        LOGGER.trace("Set new dimMin: {}, oldValue: {}", (Object)dimMin, (Object)oldValue);
        this.dimMin = dimMin;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)68, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(dimMin)));
        }
        this.firePropertyChange(PROPERTY_DIM_MIN, oldValue, this.dimMin);
    }

    public int getDimStretchMax() {
        return this.dimStretchMax;
    }

    public void setDimStretchMax(int dimStretchMax) {
        int oldValue = this.dimStretchMax;
        this.dimStretchMax = dimStretchMax;
        this.firePropertyChange(PROPERTY_DIM_STRETCH_MAX, oldValue, this.dimStretchMax);
    }

    public int getDimStretchMin() {
        return this.dimStretchMin;
    }

    public void setDimStretchMin(int dimStretchMin) {
        int oldValue = this.dimStretchMin;
        this.dimStretchMin = dimStretchMin;
        this.firePropertyChange(PROPERTY_DIM_STRETCH_MIN, oldValue, this.dimStretchMin);
    }

    public int getPwmMax() {
        if (this.genericPort != null) {
            Number pwmMax = (Number)this.genericPort.getPortConfigValue((byte)1);
            if (pwmMax != null) {
                this.pwmMax = ByteUtils.getInt((byte)pwmMax.byteValue());
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_LEVEL_PORT_ON!");
            }
        }
        return this.pwmMax;
    }

    public void setPwmMax(int pwmMax) {
        int oldValue = this.getPwmMax();
        this.pwmMax = pwmMax;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)1, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)pwmMax))));
        }
        this.firePropertyChange(PROPERTY_PWM_MAX, oldValue, this.pwmMax);
    }

    public int getPwmMin() {
        if (this.genericPort != null) {
            Number pwmMin = (Number)this.genericPort.getPortConfigValue((byte)2);
            if (pwmMin != null) {
                this.pwmMin = ByteUtils.getInt((byte)pwmMin.byteValue());
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_LEVEL_PORT_OFF!");
            }
        }
        return this.pwmMin;
    }

    public void setPwmMin(int pwmMin) {
        int oldValue = this.getPwmMin();
        this.pwmMin = pwmMin;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)2, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)pwmMin))));
        }
        this.firePropertyChange(PROPERTY_PWM_MIN, oldValue, this.pwmMin);
    }

    public Integer getRgbValue() {
        if (this.genericPort != null) {
            Number rgbValue = (Number)this.genericPort.getPortConfigValue((byte)-128);
            if (rgbValue != null) {
                this.rgbValue = rgbValue.intValue();
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_RGB!");
            }
        }
        return this.rgbValue;
    }

    public void setRgbValue(Integer rgbValue) {
        Integer oldValue = this.rgbValue;
        this.rgbValue = rgbValue;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)-128, (PortConfigValue<?>)new RgbPortConfigValue(rgbValue));
        }
        this.firePropertyChange(PROPERTY_RGB_VALUE, oldValue, this.rgbValue);
    }

    public Integer getTransitionTime() {
        if (this.genericPort != null) {
            Number transitionTime = (Number)this.genericPort.getPortConfigValue(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME);
            if (transitionTime != null) {
                this.transitionTime = transitionTime.intValue();
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_TRANSITION_TIME!");
            }
        }
        return this.transitionTime;
    }

    public void setTransitionTime(Integer transitionTime) {
        Integer oldValue = this.transitionTime;
        this.transitionTime = transitionTime;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME, (PortConfigValue<?>)new Int16PortConfigValue(transitionTime));
        }
        this.firePropertyChange(PROPERTY_TRANSITION_TIME, oldValue, this.transitionTime);
    }

    public Integer getDmxMapping() {
        LOGGER.trace("Return the dmxMapping: {}", (Object)this.dmxMapping);
        if (this.genericPort != null) {
            Number dmxMapping = (Number)this.genericPort.getPortConfigValue((byte)6);
            if (dmxMapping != null) {
                this.dmxMapping = dmxMapping.intValue();
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_OUTPUT_MAP!");
            }
        }
        LOGGER.debug("Get current dmxMapping: {}", (Object)this.dmxMapping);
        return this.dmxMapping;
    }

    public void setDmxMapping(Integer dmxMapping) {
        LOGGER.trace("Set the dmxMapping: {}", (Object)dmxMapping);
        Integer oldValue = this.dmxMapping;
        this.dmxMapping = dmxMapping;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)6, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)dmxMapping)));
        }
        this.firePropertyChange(PROPERTY_DMX_MAPPING, oldValue, this.dmxMapping);
    }

    @Override
    public String getDebugString() {
        return this.getClass().getSimpleName() + "[pwmMin=" + this.pwmMin + ",pwmMax=" + this.pwmMax + ",dimMin=" + this.dimMin + ",dimMax=" + this.dimMax + ",dimStretchMax=" + this.dimStretchMax + ",dimStretchMin=" + this.dimStretchMin + ",rgbValue=" + (Serializable)(this.rgbValue != null ? this.rgbValue : "<null>") + ",dmxMapping=" + (Serializable)(this.dmxMapping != null ? this.dmxMapping : "<null>") + ",status=" + this.getStatus() + "]";
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{ByteUtils.getLowByte((int)this.pwmMin), ByteUtils.getLowByte((int)this.pwmMax), ByteUtils.getLowByte((int)this.dimMin), ByteUtils.getLowByte((int)this.dimMax)};
    }

    public void setPortConfig(byte[] portConfig) {
        LOGGER.info("Set the light port parameters: {}", (Object)ByteUtils.bytesToHex((byte[])portConfig));
        this.setPortConfigEnabled(true);
        this.setPwmMin(ByteUtils.getInt((byte)portConfig[0]));
        this.getKnownPortConfigKeys().add((byte)2);
        this.setPwmMax(ByteUtils.getInt((byte)portConfig[1]));
        this.getKnownPortConfigKeys().add((byte)1);
        this.setDimMin(ByteUtils.getInt((byte)portConfig[2]));
        this.getKnownPortConfigKeys().add((byte)68);
        this.setDimMax(ByteUtils.getInt((byte)portConfig[3]));
        this.getKnownPortConfigKeys().add((byte)67);
        this.setDimStretchMin(255);
        this.setDimStretchMax(255);
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port config for LightPort: {}", portConfig);
        Number pwmMax = (Number)this.getPortConfigValue((byte)1, portConfig);
        if (pwmMax != null) {
            this.setPwmMax(ByteUtils.getInt((byte)pwmMax.byteValue()));
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_LEVEL_PORT_ON!");
        }
        Number pwmMin = (Number)this.getPortConfigValue((byte)2, portConfig);
        if (pwmMin != null) {
            this.setPwmMin(ByteUtils.getInt((byte)pwmMin.byteValue()));
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_LEVEL_PORT_OFF!");
        }
        Number dimMax = (Number)this.getPortConfigValue((byte)67, portConfig);
        if (dimMax != null) {
            this.setDimMax8_8(ByteUtils.getWORD((int)dimMax.intValue()));
            this.setDimStretchMax(65535);
        } else {
            dimMax = (Number)this.getPortConfigValue((byte)3, portConfig);
            if (dimMax != null) {
                this.setDimMax(ByteUtils.getInt((byte)dimMax.byteValue()));
                this.setDimStretchMax(255);
            } else {
                LOGGER.debug("No value received for BIDIB_PCFG_DIMM_UP or BIDIB_PCFG_DIMM_UP_8_8!");
                this.setDimStretchMax(255);
            }
        }
        Number dimMin = (Number)this.getPortConfigValue((byte)68, portConfig);
        if (dimMin != null) {
            this.setDimMin8_8(ByteUtils.getWORD((int)dimMin.intValue()));
            this.setDimStretchMin(65535);
        } else {
            dimMin = (Number)this.getPortConfigValue((byte)4, portConfig);
            if (dimMin != null) {
                this.setDimMin(ByteUtils.getInt((byte)dimMin.byteValue()));
                this.setDimStretchMin(255);
            } else {
                LOGGER.debug("No value received for BIDIB_PCFG_DIMM_DOWN or BIDIB_PCFG_DIMM_DOWN_8_8!");
                this.setDimStretchMin(255);
            }
        }
        Number rgbValue = (Number)this.getPortConfigValue((byte)-128, portConfig);
        if (rgbValue != null) {
            this.setRgbValue(ByteUtils.getRGB((Integer)rgbValue.intValue()));
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_RGB!");
        }
        Number transitionTime = (Number)this.getPortConfigValue(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME, portConfig);
        if (transitionTime != null) {
            this.setTransitionTime(transitionTime.intValue());
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_TRANSITION_TIME!");
        }
        Number outputMap = (Number)this.getPortConfigValue((byte)6, portConfig);
        if (outputMap != null) {
            this.setDmxMapping(ByteUtils.getInt((byte)outputMap.byteValue()));
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_OUTPUT_MAP!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported((byte)67)) {
            portConfigX.put((byte)67, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(this.dimMax)));
        } else if (this.isPortConfigKeySupported((byte)3)) {
            portConfigX.put((byte)3, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.dimMax))));
        } else {
            LOGGER.debug("No DIMM_UP config available.");
        }
        if (this.isPortConfigKeySupported((byte)68)) {
            portConfigX.put((byte)68, (PortConfigValue<?>)new Int16PortConfigValue(Integer.valueOf(this.dimMin)));
        } else if (this.isPortConfigKeySupported((byte)4)) {
            portConfigX.put((byte)4, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.dimMin))));
        } else {
            LOGGER.debug("No DIMM_DOWN config available.");
        }
        if (this.isPortConfigKeySupported((byte)1)) {
            portConfigX.put((byte)1, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.pwmMax))));
        }
        if (this.isPortConfigKeySupported((byte)2)) {
            portConfigX.put((byte)2, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.pwmMin))));
        }
        if (this.isPortConfigKeySupported((byte)-128) && this.getRgbValue() != null) {
            portConfigX.put((byte)-128, (PortConfigValue<?>)new RgbPortConfigValue(this.getRgbValue()));
        }
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME) && this.getTransitionTime() != null) {
            portConfigX.put(BidibLibrary.BIDIB_PCFG_TRANSITION_TIME, (PortConfigValue<?>)new Int16PortConfigValue(this.getTransitionTime()));
        }
        if (this.isPortConfigKeySupported((byte)6)) {
            portConfigX.put((byte)6, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)this.getDmxMapping())));
        }
        return portConfigX;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LightPort) {
            return ((LightPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.LIGHTPORT;
    }

    @Override
    protected LightPortStatus internalGetStatus(GenericPort genericPort) {
        LOGGER.trace("Get the genericPort.getPortStatus(): {}, port number: {}", (Object)genericPort.getPortStatus(), (Object)genericPort.getPortNumber());
        return LightPortStatus.valueOf(LightPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LightPort clonePort(LightPort lp) {
        LightPort lightPort = (LightPort)LightPort.builder().withRgbValue(lp.getRgbValue()).withDmxMapping(lp.getDmxMapping()).withDimMax(lp.getDimMax()).withDimMin(lp.getDimMin()).withDimStretchMax(lp.getDimStretchMax()).withDimStretchMin(lp.getDimStretchMin()).withPwmMax(lp.getPwmMax()).withPwmMin(lp.getPwmMin()).withTransitionTime(lp.getTransitionTime()).withId(lp.getId()).withConfigStatus(lp.getConfigStatus()).withEnabled(lp.isEnabled()).withGenericPort(lp.getGenericPort()).withIsInactive(lp.isInactive()).withKnownPortConfigKeys(lp.getKnownPortConfigKeys()).withLabel(lp.getLabel()).withPortConfigEnabled(lp.isPortConfigEnabled()).withPortConfigErrorCode(lp.getPortConfigErrorCode()).withPortIdentifier(lp.getPortIdentifier()).withRemappingEnabled(lp.isRemappingEnabled()).withStatus((LightPortStatus)lp.getStatus()).build();
        return lightPort;
    }

    public static final class Builder
    extends Port.Builder<LightPort, LightPortStatus> {
        private Integer rgbValue;
        private Integer dmxMapping;
        private Integer transitionTime;
        private int dimMax;
        private int dimMin;
        private int dimStretchMax;
        private int dimStretchMin;
        private int pwmMax;
        private int pwmMin;

        public Builder withRgbValue(Integer rgbValue) {
            this.rgbValue = rgbValue;
            return this;
        }

        public Builder withDmxMapping(Integer dmxMapping) {
            this.dmxMapping = dmxMapping;
            return this;
        }

        public Builder withTransitionTime(Integer transistionTime) {
            this.transitionTime = transistionTime;
            return this;
        }

        public Builder withDimMax(int dimMax) {
            this.dimMax = dimMax;
            return this;
        }

        public Builder withDimMin(int dimMin) {
            this.dimMin = dimMin;
            return this;
        }

        public Builder withDimStretchMax(int dimStretchMax) {
            this.dimStretchMax = dimStretchMax;
            return this;
        }

        public Builder withDimStretchMin(int dimStretchMin) {
            this.dimStretchMin = dimStretchMin;
            return this;
        }

        public Builder withPwmMax(int pwmMax) {
            this.pwmMax = pwmMax;
            return this;
        }

        public Builder withPwmMin(int pwmMin) {
            this.pwmMin = pwmMin;
            return this;
        }

        @Override
        public LightPort build() {
            return new LightPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public LightPort build() {
            return new LightPort(this);
        }
    }
}

