/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.MotorPortEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ValuePort;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorPort
extends Port<MotorPortStatus>
implements ConfigurablePort<MotorPortStatus>,
ValuePort {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPort.class);
    public static final String PROPERTY_PORT_VALUE = "value";
    public static final MotorPort NONE = new LabelBuilder(-1).setLabel("<none>").build();
    private Integer value;

    public MotorPort() {
        this((GenericPort)null);
    }

    public MotorPort(GenericPort genericPort) {
        super(genericPort);
    }

    private MotorPort(Builder builder) {
        super(builder);
    }

    private MotorPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    @Override
    public Integer getValue() {
        if (this.genericPort != null) {
            Integer portVal = this.genericPort.getPortValue();
            this.value = portVal != null ? portVal : Integer.valueOf(0);
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        LOGGER.info("Set the value: {}", (Object)value);
        Integer oldValue = this.value;
        if (this.genericPort != null) {
            this.genericPort.setPortValue(value);
        }
        this.value = value;
        this.firePropertyChange(PROPERTY_PORT_VALUE, oldValue, value);
    }

    @Override
    public String getDebugString() {
        return this.getClass().getSimpleName() + "[value=" + this.getValue() + "]";
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{0, 0, 0, 0};
    }

    public void setPortConfig(byte[] portConfig) {
        LOGGER.info("Set the motor port parameters: {}", (Object)ByteUtils.bytesToHex((byte[])portConfig));
        this.setPortConfigEnabled(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MotorPort) {
            return ((MotorPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.MOTORPORT;
    }

    @Override
    protected MotorPortStatus internalGetStatus(GenericPort genericPort) {
        return MotorPortStatus.valueOf(MotorPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Port.Builder<MotorPort, MotorPortStatus> {
        private Builder() {
        }

        @Override
        public MotorPort build() {
            return new MotorPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public MotorPort build() {
            return new MotorPort(this);
        }
    }
}

