/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import com.jgoodies.binding.beans.Model;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LocalPortConfigStatus;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.enums.PortConfigStatus;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.status.BidibStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Port<T extends BidibStatus>
extends Model
implements PortTypeAware {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Port.class);
    public static final String PROPERTY_CONFIG_STATUS = "configStatus";
    public static final String PROPERTY_LOCAL_CONFIG_STATUS = "localConfigStatus";
    public static final String PROPERTY_PORT_CONFIG_ERRORCODE = "portConfigErrorCode";
    public static final String PROPERTY_STATUS = "status";
    public static final String PROPERTY_INACTIVE = "inactive";
    public static final String PROPERTY_ENABLED = "enabled";
    public static final String PROPERTY_LABEL = "label";
    private int id;
    private boolean enabled = true;
    private boolean remappingEnabled = false;
    private String portIdentifier;
    private String label;
    private T status;
    private PortConfigStatus configStatus = PortConfigStatus.CONFIG_PENDING;
    private LocalPortConfigStatus localConfigStatus = LocalPortConfigStatus.CONFIG_NA;
    private Integer portConfigErrorCode;
    protected transient GenericPort genericPort;
    private transient Set<Byte> knownPortConfigKeys = new LinkedHashSet<Byte>();
    private boolean portConfigEnabled = true;
    private boolean isInactive;

    protected Port(Builder<?, T> builder) {
        this.id = builder.id;
        this.enabled = builder.enabled;
        this.remappingEnabled = builder.remappingEnabled;
        this.portIdentifier = builder.portIdentifier;
        this.label = builder.label;
        this.status = builder.status;
        this.configStatus = builder.configStatus;
        this.portConfigErrorCode = builder.portConfigErrorCode;
        this.genericPort = builder.genericPort;
        this.knownPortConfigKeys = builder.knownPortConfigKeys;
        this.portConfigEnabled = builder.portConfigEnabled;
        this.isInactive = builder.isInactive;
    }

    protected Port(GenericPort genericPort) {
        this.genericPort = genericPort;
    }

    public GenericPort getGenericPort() {
        return this.genericPort;
    }

    public static LcOutputType getPortType(Port<?> port) {
        return port.getPortType();
    }

    public static LcOutputType getConfiguredPortType(Port<?> port) {
        if (port.getGenericPort() != null) {
            if (port.getGenericPort().getPairedPortMaster() != null && port.getGenericPort().getPairedPortMaster().get() != null) {
                return ((GenericPort)port.getGenericPort().getPairedPortMaster().get()).getCurrentPortType();
            }
            return port.getGenericPort().getCurrentPortType();
        }
        return port.getPortType();
    }

    public Set<Byte> getKnownPortConfigKeys() {
        if (this.genericPort != null) {
            return this.genericPort.getKnownPortConfigKeys();
        }
        return this.knownPortConfigKeys;
    }

    public void setKnownPortConfigKeys(Set<Byte> knownPortConfigKeys) {
        if (this.genericPort != null) {
            this.genericPort.setKnownPortConfigKeys(knownPortConfigKeys);
            return;
        }
        this.knownPortConfigKeys.clear();
        this.knownPortConfigKeys.addAll(knownPortConfigKeys);
    }

    public void addKnownPortConfigKeys(Set<Byte> knownPortConfigKeys) {
        Collections.addAll(this.getKnownPortConfigKeys(), knownPortConfigKeys.toArray(new Byte[0]));
    }

    public boolean isPortConfigKeySupported(Byte key) {
        if (this.genericPort != null) {
            return this.genericPort.isPortConfigKeySupported(key);
        }
        return this.knownPortConfigKeys.contains(key);
    }

    public boolean isPortConfigKeySupported(PortConfigKeys key) {
        if (this.genericPort != null) {
            return this.genericPort.isPortConfigKeySupported(key);
        }
        return this.knownPortConfigKeys.contains(key.getType());
    }

    public boolean isPortConfigKeySupported(byte[] keys) {
        if (this.genericPort != null) {
            byte[] byArray = keys;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte key = byArray[i];
                if (!this.genericPort.isPortConfigKeySupported(key)) continue;
                return true;
            }
            return false;
        }
        byte[] byArray = keys;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte key = byArray[i];
            if (!this.knownPortConfigKeys.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getPortNumber() {
        return this.getId();
    }

    public int getId() {
        if (this.genericPort != null) {
            return this.genericPort.getPortNumber();
        }
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isEnabled() {
        if (this.genericPort != null) {
            return this.genericPort.isMatchingPortType(this.getPortType()) && !this.genericPort.isInactive();
        }
        if (this.isInactive()) {
            return false;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        if (this.genericPort != null && this.genericPort.isMatchingPortType(this.getPortType())) {
            this.genericPort.setInactive(!enabled);
        }
        this.firePropertyChange(PROPERTY_ENABLED, oldValue, this.enabled);
    }

    public boolean isRemappingEnabled() {
        if (this.genericPort != null) {
            return this.genericPort.isRemappingEnabled();
        }
        return this.remappingEnabled;
    }

    public void setRemappingEnabled(boolean remappingEnabled) {
        this.remappingEnabled = remappingEnabled;
    }

    public boolean isInactive() {
        if (this.genericPort != null) {
            return this.genericPort.isInactive();
        }
        return this.isInactive;
    }

    public void setInactive(boolean isInactive) {
        LOGGER.info("Set port inactive: {}, port: {}", (Object)isInactive, (Object)this);
        boolean oldValue = this.isInactive;
        this.isInactive = isInactive;
        this.firePropertyChange(PROPERTY_INACTIVE, oldValue, this.isInactive);
        if (this.genericPort != null) {
            this.genericPort.setInactive(isInactive);
        }
    }

    public String getPortIdentifier() {
        return this.portIdentifier;
    }

    public void setPortIdentifier(String portIdentifier) {
        this.portIdentifier = portIdentifier;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        LOGGER.debug("Set label: {}", (Object)label);
        String oldValue = this.label;
        this.label = label;
        this.firePropertyChange(PROPERTY_LABEL, oldValue, label);
    }

    public T getStatus() {
        if (this.genericPort != null) {
            this.status = this.internalGetStatus(this.genericPort);
        }
        LOGGER.debug("Get the port status: {}", this.status);
        return this.status;
    }

    protected abstract T internalGetStatus(GenericPort var1);

    public void setStatus(T status) {
        T oldValue = this.status;
        if (this.genericPort != null) {
            this.genericPort.setPortStatus(status.getType().getType());
        }
        this.status = status;
        this.firePropertyChange(PROPERTY_STATUS, oldValue, status);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Port) {
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            return ((Port)obj).getId() == this.getId();
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public String toString() {
        Integer genericPortNumber;
        int localId = this.id;
        if (this.genericPort != null && (genericPortNumber = this.genericPort.getPortNumber()) != null) {
            localId = genericPortNumber;
        }
        if (localId != -1) {
            Object result = null;
            result = StringUtils.isNotBlank((CharSequence)this.label) ? this.label : this.getClass().getSimpleName() + "_" + localId;
            return result;
        }
        return super.toString();
    }

    public String getDebugString() {
        return this.getClass().getSimpleName();
    }

    public abstract byte[] getPortConfig();

    public boolean isPortConfigEnabled() {
        return this.portConfigEnabled;
    }

    public void setPortConfigEnabled(boolean portConfigEnabled) {
        this.portConfigEnabled = portConfigEnabled;
    }

    public PortConfigStatus getConfigStatus() {
        if (this.genericPort != null) {
            this.configStatus = this.genericPort.getConfigStatus();
        }
        return this.configStatus;
    }

    public void setConfigStatus(PortConfigStatus configStatus) {
        PortConfigStatus oldValue = this.configStatus;
        this.configStatus = configStatus;
        if (this.configStatus == PortConfigStatus.CONFIG_PASSED && this.localConfigStatus == LocalPortConfigStatus.CONFIG_NA) {
            this.setLocalConfigStatus(LocalPortConfigStatus.CONFIG_PERSISTENT);
        }
        this.firePropertyChange(PROPERTY_CONFIG_STATUS, oldValue, this.configStatus);
    }

    public void setLocalConfigStatus(LocalPortConfigStatus localConfigStatus) {
        LocalPortConfigStatus oldValue = this.localConfigStatus;
        this.localConfigStatus = localConfigStatus;
        if (this.genericPort != null) {
            this.genericPort.setLocalConfigStatus(localConfigStatus);
        }
        this.firePropertyChange(PROPERTY_LOCAL_CONFIG_STATUS, oldValue, this.localConfigStatus);
    }

    public LocalPortConfigStatus getLocalConfigStatus() {
        if (this.genericPort != null) {
            this.localConfigStatus = this.genericPort.getLocalConfigStatus();
        }
        return this.localConfigStatus;
    }

    public Integer getPortConfigErrorCode() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigErrorCode();
        }
        return this.portConfigErrorCode;
    }

    public void setPortConfigErrorCode(Integer portConfigErrorCode) {
        Integer oldValue = this.portConfigErrorCode;
        LOGGER.info("Set the portConfigErrorCode: {}, port id: {}", (Object)portConfigErrorCode, (Object)this.getId());
        this.portConfigErrorCode = portConfigErrorCode;
        this.firePropertyChange(PROPERTY_PORT_CONFIG_ERRORCODE, oldValue, this.portConfigErrorCode);
    }

    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        int errorCode;
        LOGGER.info("Set the port config: {}", portConfig);
        if (this.genericPort != null) {
            this.genericPort.setPortConfigX(portConfig);
            return;
        }
        this.addKnownPortConfigKeys(portConfig.keySet());
        boolean moreToContinue = portConfig.containsKey((byte)-1);
        if (moreToContinue) {
            LOGGER.info("An additional message with more config will follow.");
            this.setConfigStatus(PortConfigStatus.CONFIG_PENDING);
        } else {
            this.setConfigStatus(PortConfigStatus.CONFIG_PASSED);
        }
        Number noneErrorCode = (Number)this.getPortConfigValue((byte)0, portConfig);
        if (noneErrorCode != null && (errorCode = ByteUtils.getInt((byte)noneErrorCode.byteValue())) != ByteUtils.getInt((byte)0)) {
            this.setPortConfigErrorCode(errorCode);
            this.setConfigStatus(PortConfigStatus.CONFIG_ERROR);
        }
    }

    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        return Collections.emptyMap();
    }

    protected <T> T getPortConfigValue(Byte key, Map<Byte, PortConfigValue<?>> portConfig) {
        try {
            PortConfigValue<?> portConfigValue = portConfig.get(key);
            if (portConfigValue != null) {
                return (T)portConfig.get(key).getValue();
            }
        }
        catch (ClassCastException ex) {
            LOGGER.warn("Cast value of key: {} to target type failed.", (Object)key, (Object)ex);
        }
        return null;
    }

    public static abstract class Builder<P extends Port<T>, T extends BidibStatus> {
        private int id;
        private boolean enabled;
        private boolean remappingEnabled;
        private String portIdentifier;
        private String label;
        private T status;
        private PortConfigStatus configStatus;
        private Integer portConfigErrorCode;
        private GenericPort genericPort;
        private Set<Byte> knownPortConfigKeys = Collections.emptySet();
        private boolean portConfigEnabled;
        private boolean isInactive;

        protected Builder() {
        }

        public Builder<P, T> withId(int id) {
            this.id = id;
            return this;
        }

        public Builder<P, T> withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder<P, T> withRemappingEnabled(boolean remappingEnabled) {
            this.remappingEnabled = remappingEnabled;
            return this;
        }

        public Builder<P, T> withPortIdentifier(String portIdentifier) {
            this.portIdentifier = portIdentifier;
            return this;
        }

        public Builder<P, T> withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder<P, T> withStatus(T status) {
            this.status = status;
            return this;
        }

        public Builder<P, T> withConfigStatus(PortConfigStatus configStatus) {
            this.configStatus = configStatus;
            return this;
        }

        public Builder<P, T> withPortConfigErrorCode(Integer portConfigErrorCode) {
            this.portConfigErrorCode = portConfigErrorCode;
            return this;
        }

        public Builder<P, T> withGenericPort(GenericPort genericPort) {
            this.genericPort = genericPort;
            return this;
        }

        public Builder<P, T> withKnownPortConfigKeys(Set<Byte> knownPortConfigKeys) {
            this.knownPortConfigKeys = knownPortConfigKeys;
            return this;
        }

        public Builder<P, T> withPortConfigEnabled(boolean portConfigEnabled) {
            this.portConfigEnabled = portConfigEnabled;
            return this;
        }

        public Builder<P, T> withIsInactive(boolean isInactive) {
            this.isInactive = isInactive;
            return this;
        }

        public abstract P build();
    }
}

