/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.enums.CurveFormEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.ServoPortEnum;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ValuePort;
import org.bidib.wizard.model.status.ServoPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServoPort
extends Port<ServoPortStatus>
implements ConfigurablePort<ServoPortStatus>,
ValuePort {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServoPort.class);
    public static final String PROPERTYNAME_SPEED = "speed";
    public static final String PROPERTYNAME_TRIM_DOWN = "trimDown";
    public static final String PROPERTYNAME_TRIM_UP = "trimUp";
    public static final String PROPERTYNAME_CURVEFORM_UP = "curveFormUp";
    public static final String PROPERTYNAME_CURVEFORM_DOWN = "curveFormDown";
    public static final String PROPERTYNAME_SERVO_EXTRA = "servoExtra";
    public static final String PROPERTYNAME_VALUE = "value";
    public static final int SLEEP_BETWEEN_POSITION_ADJUSTMENT = 50;
    public static final ServoPort NONE = new LabelBuilder(-1).setLabel("<none>").build();
    private int speed;
    private int trimDown;
    private int trimUp;
    private CurveFormEnum curveFormUp;
    private CurveFormEnum curveFormDown;
    private Integer servoExtra;
    private Integer value;

    public ServoPort() {
        this((GenericPort)null);
    }

    private ServoPort(Builder builder) {
        super(builder);
        this.speed = builder.speed;
        this.trimDown = builder.trimDown;
        this.trimUp = builder.trimUp;
        this.curveFormUp = builder.curveFormUp;
        this.curveFormDown = builder.curveFormDown;
        this.servoExtra = builder.servoExtra;
        this.value = builder.value;
    }

    public ServoPort(GenericPort genericPort) {
        super(genericPort);
    }

    private ServoPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    public int getSpeed() {
        if (this.genericPort != null) {
            Number servoSpeed = (Number)this.genericPort.getPortConfigValue((byte)9);
            if (servoSpeed != null) {
                this.speed = ByteUtils.getInt((byte)servoSpeed.byteValue());
            } else {
                LOGGER.info("No value received from generic port for BIDIB_PCFG_SERVO_SPEED!");
            }
        }
        return this.speed;
    }

    public void setSpeed(int speed) {
        int oldValue = this.speed;
        this.speed = speed;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)9, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)speed))));
        }
        this.firePropertyChange(PROPERTYNAME_SPEED, oldValue, this.speed);
    }

    public int getTrimDown() {
        if (this.genericPort != null) {
            Number servoTrimDown = (Number)this.genericPort.getPortConfigValue((byte)7);
            if (servoTrimDown != null) {
                this.trimDown = ByteUtils.getInt((byte)servoTrimDown.byteValue());
            } else {
                LOGGER.info("No value received from generic port for BIDIB_PCFG_SERVO_ADJ_L!");
            }
        }
        return this.trimDown;
    }

    public void setTrimDown(int trimDown) {
        int oldValue = this.trimDown;
        this.trimDown = trimDown;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)7, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)trimDown))));
        }
        this.firePropertyChange(PROPERTYNAME_TRIM_DOWN, oldValue, this.trimDown);
    }

    public int getTrimUp() {
        if (this.genericPort != null) {
            Number servoTrimUp = (Number)this.genericPort.getPortConfigValue((byte)8);
            if (servoTrimUp != null) {
                this.trimUp = ByteUtils.getInt((byte)servoTrimUp.byteValue());
            } else {
                LOGGER.info("No value received from generic port for BIDIB_PCFG_SERVO_ADJ_H!");
            }
        }
        return this.trimUp;
    }

    public void setTrimUp(int trimUp) {
        int oldValue = this.trimUp;
        this.trimUp = trimUp;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)8, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)trimUp))));
        }
        this.firePropertyChange(PROPERTYNAME_TRIM_UP, oldValue, this.trimUp);
    }

    public int prepareMoveType() {
        byte downValue = this.curveFormDown != null ? this.curveFormDown.getType() : CurveFormEnum.LIN.getType();
        byte upValue = this.curveFormUp != null ? this.curveFormUp.getType() : CurveFormEnum.LIN.getType();
        int moveType = upValue & 0xF | (downValue & 0xF) << 4;
        return moveType;
    }

    public CurveFormEnum getCurveFormUp() {
        if (this.genericPort != null) {
            Number servoCurveFormUp = (Number)this.genericPort.getPortConfigValue((byte)16);
            if (servoCurveFormUp != null) {
                this.curveFormUp = CurveFormEnum.valueOf((int)ByteUtils.getLowNibble((byte)servoCurveFormUp.byteValue()));
            } else {
                LOGGER.info("No value received from generic port for BIDIB_PCFG_MOVE_TYPE!");
            }
        }
        return this.curveFormUp;
    }

    public void setCurveFormUp(CurveFormEnum curveFormUp) {
        CurveFormEnum oldValue = this.curveFormUp;
        this.curveFormUp = curveFormUp;
        if (this.genericPort != null) {
            int moveType = this.prepareMoveType();
            LOGGER.info("Prepared BIDIB_PCFG_MOVE_TYPE: {}", (Object)ByteUtils.byteToHex((int)moveType));
            this.genericPort.setPortConfigValue((byte)16, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)moveType))));
        }
        this.firePropertyChange(PROPERTYNAME_CURVEFORM_UP, oldValue, this.curveFormUp);
    }

    public CurveFormEnum getCurveFormDown() {
        if (this.genericPort != null) {
            Number servoCurveFormDown = (Number)this.genericPort.getPortConfigValue((byte)16);
            if (servoCurveFormDown != null) {
                this.curveFormDown = CurveFormEnum.valueOf((int)ByteUtils.getHighNibble((byte)servoCurveFormDown.byteValue()));
            } else {
                LOGGER.info("No value received from generic port for BIDIB_PCFG_MOVE_TYPE!");
            }
        }
        return this.curveFormDown;
    }

    public void setCurveFormDown(CurveFormEnum curveFormDown) {
        CurveFormEnum oldValue = this.curveFormDown;
        this.curveFormDown = curveFormDown;
        if (this.genericPort != null) {
            int moveType = this.prepareMoveType();
            LOGGER.info("Prepared BIDIB_PCFG_MOVE_TYPE: {}", (Object)ByteUtils.byteToHex((int)moveType));
            this.genericPort.setPortConfigValue((byte)16, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)moveType))));
        }
        this.firePropertyChange(PROPERTYNAME_CURVEFORM_DOWN, oldValue, this.curveFormDown);
    }

    public Integer getServoExtra() {
        if (this.genericPort != null) {
            Number servoExtra = (Number)this.genericPort.getPortConfigValue((byte)10);
            if (servoExtra != null) {
                this.servoExtra = ByteUtils.getInt((byte)servoExtra.byteValue());
            } else {
                LOGGER.info("No value received from generic port for BIDIB_PCFG_SERVO_EXTRA!");
            }
        }
        return this.servoExtra;
    }

    public void setServoExtra(Integer servoExtra) {
        Integer oldValue = this.servoExtra;
        this.servoExtra = servoExtra;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)10, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)servoExtra)));
        }
        this.firePropertyChange(PROPERTYNAME_SERVO_EXTRA, oldValue, this.servoExtra);
    }

    @Override
    public Integer getValue() {
        if (this.genericPort != null) {
            return this.genericPort.getPortValue();
        }
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        Integer oldValue = this.value;
        this.value = value;
        if (this.genericPort != null) {
            this.genericPort.setPortValue(value);
        }
        this.firePropertyChange(PROPERTYNAME_VALUE, oldValue, this.value);
    }

    public static int getAbsoluteValue(int value) {
        if (value < 0 || value > 100) {
            throw new IllegalArgumentException("The allowed range is 0-100. Provided value: " + value);
        }
        int stepWidth = value * 255 / 100;
        return stepWidth;
    }

    public static int getRelativeValue(int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("The allowed range is 0-255. Provided value: " + value);
        }
        long result = Math.round((double)value * 100.0 / 255.0);
        return (int)result;
    }

    public int getRelativeValue() {
        Integer value = this.getValue();
        if (value != null) {
            long result = Math.round(value.doubleValue() * 100.0 / 255.0);
            return (int)result;
        }
        return 0;
    }

    public void setRelativeValue(int value) {
        this.setValue(ServoPort.getAbsoluteValue(value));
    }

    @Override
    public String getDebugString() {
        return this.getClass().getSimpleName() + "[speed=" + this.speed + ",trimDown=" + this.trimDown + ",trimUp=" + this.trimUp + ",value=" + this.getValue() + "]";
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{ByteUtils.getLowByte((int)this.trimDown), ByteUtils.getLowByte((int)this.trimUp), ByteUtils.getLowByte((int)this.speed), 0};
    }

    public void setPortConfig(byte[] portConfig) {
        LOGGER.info("Set the servo port parameters: {}", (Object)ByteUtils.bytesToHex((byte[])portConfig));
        this.setPortConfigEnabled(true);
        this.setTrimDown(ByteUtils.getInt((byte)portConfig[0]));
        this.getKnownPortConfigKeys().add((byte)7);
        this.setTrimUp(ByteUtils.getInt((byte)portConfig[1]));
        this.getKnownPortConfigKeys().add((byte)8);
        this.setSpeed(ByteUtils.getInt((byte)portConfig[2]));
        this.getKnownPortConfigKeys().add((byte)9);
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        Number trimmDown = (Number)this.getPortConfigValue((byte)7, portConfig);
        if (trimmDown != null) {
            this.setTrimDown(ByteUtils.getInt((byte)trimmDown.byteValue()));
        } else {
            LOGGER.info("No value received for BIDIB_PCFG_SERVO_ADJ_L!");
        }
        Number trimUp = (Number)this.getPortConfigValue((byte)8, portConfig);
        if (trimUp != null) {
            this.setTrimUp(ByteUtils.getInt((byte)trimUp.byteValue()));
        } else {
            LOGGER.info("No value received for BIDIB_PCFG_SERVO_ADJ_H!");
        }
        Number speed = (Number)this.getPortConfigValue((byte)9, portConfig);
        if (speed != null) {
            this.setSpeed(ByteUtils.getInt((byte)speed.byteValue()));
        } else {
            LOGGER.info("No value received for BIDIB_PCFG_SERVO_SPEED!");
        }
        Number servoExtra = (Number)this.getPortConfigValue((byte)10, portConfig);
        if (servoExtra != null) {
            this.setServoExtra(ByteUtils.getInt((byte)servoExtra.byteValue()));
        } else {
            LOGGER.info("No value received for BIDIB_PCFG_SERVO_EXTRA!");
        }
        Number moveType = (Number)this.getPortConfigValue((byte)16, portConfig);
        if (moveType != null) {
            byte moveTypeValue = moveType.byteValue();
            int curveFormUp = ByteUtils.getLowNibble((byte)moveTypeValue);
            this.setCurveFormUp(CurveFormEnum.valueOf((int)curveFormUp));
            int curveFormDown = ByteUtils.getHighNibble((byte)moveTypeValue);
            this.setCurveFormDown(CurveFormEnum.valueOf((int)curveFormDown));
        } else {
            LOGGER.info("No value received for BIDIB_PCFG_MOVE_TYPE!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported((byte)7)) {
            portConfigX.put((byte)7, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.trimDown))));
        }
        if (this.isPortConfigKeySupported((byte)8)) {
            portConfigX.put((byte)8, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.trimUp))));
        }
        if (this.isPortConfigKeySupported((byte)9)) {
            portConfigX.put((byte)9, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.speed))));
        }
        if (this.isPortConfigKeySupported((byte)16)) {
            int moveType = this.prepareMoveType();
            portConfigX.put((byte)16, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)moveType))));
        }
        if (this.isPortConfigKeySupported((byte)10)) {
            Integer servoExtra = this.getServoExtra();
            if (servoExtra == null) {
                servoExtra = 0;
            }
            portConfigX.put((byte)10, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)servoExtra)));
        }
        return portConfigX;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ServoPort) {
            return ((ServoPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.SERVOPORT;
    }

    @Override
    protected ServoPortStatus internalGetStatus(GenericPort genericPort) {
        return ServoPortStatus.valueOf(ServoPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ServoPort clonePort(ServoPort sp) {
        ServoPort servoPort = (ServoPort)ServoPort.builder().withSpeed(sp.getSpeed()).withTrimDown(sp.getTrimDown()).withTrimUp(sp.getTrimUp()).withCurveFormUp(sp.getCurveFormUp()).withCurveFormDown(sp.getCurveFormDown()).withServoExtra(sp.getServoExtra()).withId(sp.getId()).withConfigStatus(sp.getConfigStatus()).withEnabled(sp.isEnabled()).withGenericPort(sp.getGenericPort()).withIsInactive(sp.isInactive()).withKnownPortConfigKeys(sp.getKnownPortConfigKeys()).withLabel(sp.getLabel()).withPortConfigEnabled(sp.isPortConfigEnabled()).withPortConfigErrorCode(sp.getPortConfigErrorCode()).withPortIdentifier(sp.getPortIdentifier()).withRemappingEnabled(sp.isRemappingEnabled()).withStatus((ServoPortStatus)sp.getStatus()).build();
        return servoPort;
    }

    public static final class Builder
    extends Port.Builder<ServoPort, ServoPortStatus> {
        private int speed;
        private int trimDown;
        private int trimUp;
        private CurveFormEnum curveFormUp;
        private CurveFormEnum curveFormDown;
        private Integer servoExtra;
        private Integer value;

        public Builder withSpeed(int speed) {
            this.speed = speed;
            return this;
        }

        public Builder withTrimDown(int trimDown) {
            this.trimDown = trimDown;
            return this;
        }

        public Builder withTrimUp(int trimUp) {
            this.trimUp = trimUp;
            return this;
        }

        public Builder withCurveFormUp(CurveFormEnum curveFormUp) {
            this.curveFormUp = curveFormUp;
            return this;
        }

        public Builder withCurveFormDown(CurveFormEnum curveFormDown) {
            this.curveFormDown = curveFormDown;
            return this;
        }

        public Builder withValue(Integer value) {
            this.value = value;
            return this;
        }

        public Builder withServoExtra(Integer servoExtra) {
            this.servoExtra = servoExtra;
            return this;
        }

        @Override
        public ServoPort build() {
            return new ServoPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public ServoPort build() {
            return new ServoPort(this);
        }
    }
}

