/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.SoundPortEnum;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.StatusPort;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPort
extends Port<SoundPortStatus>
implements ConfigurablePort<SoundPortStatus>,
StatusPort<SoundPortStatus> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SoundPort.class);
    private int pulseTime;
    private transient boolean hasSoundPortConfig;

    public SoundPort() {
        this((GenericPort)null);
    }

    public SoundPort(GenericPort genericPort) {
        super(genericPort);
    }

    private SoundPort(Builder builder) {
        super(builder);
    }

    private SoundPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.SOUNDPORT;
    }

    @Override
    protected SoundPortStatus internalGetStatus(GenericPort genericPort) {
        return SoundPortStatus.valueOf(SoundPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    public int getPulseTime() {
        if (this.genericPort != null) {
            Number pulseTime = (Number)this.genericPort.getPortConfigValue((byte)11);
            if (pulseTime != null) {
                this.pulseTime = ByteUtils.getInt((byte)pulseTime.byteValue());
            } else {
                LOGGER.warn("No value received from generic for BIDIB_PCFG_TICKS!");
            }
        }
        return this.pulseTime;
    }

    public void setPulseTime(int pulseTime) {
        LOGGER.info("Set pulse time: {}", (Object)pulseTime);
        this.pulseTime = pulseTime;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)11, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)pulseTime))));
        }
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{0, 0, 0, 0};
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port config for the sound port.");
        Number pulseTime = (Number)this.getPortConfigValue((byte)11, portConfig);
        if (pulseTime != null) {
            this.setPulseTime(ByteUtils.getInt((byte)pulseTime.byteValue()));
            this.setHasSoundPortConfig(true);
        } else {
            LOGGER.warn("No value received for BIDIB_PCFG_TICKS!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported((byte)11)) {
            portConfigX.put((byte)11, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.pulseTime))));
        }
        return portConfigX;
    }

    public boolean isHasSoundPortConfig() {
        if (this.genericPort != null) {
            this.hasSoundPortConfig = this.genericPort.isHasPortConfig((byte)11);
            LOGGER.info("The generic port has sound port config: {}", (Object)this.hasSoundPortConfig);
        }
        return this.hasSoundPortConfig;
    }

    public void setHasSoundPortConfig(boolean hasSoundPortConfig) {
        LOGGER.info("The port has sound port config available: {}, port: {}", (Object)hasSoundPortConfig, (Object)this);
        this.hasSoundPortConfig = hasSoundPortConfig;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SoundPort) {
            return ((SoundPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Port.Builder<SoundPort, SoundPortStatus> {
        private Builder() {
        }

        @Override
        public SoundPort build() {
            return new SoundPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public SoundPort build() {
            return new SoundPort(this);
        }
    }
}

