/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.LoadTypeAware;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.StatusPort;
import org.bidib.wizard.model.ports.TicksAware;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPairPort
extends Port<SwitchPortStatus>
implements ConfigurablePort<SwitchPortStatus>,
TicksAware,
StatusPort<SwitchPortStatus>,
LoadTypeAware {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPairPort.class);
    public static final String PROPERTYNAME_SWITCHOFFTIME = "switchOffTime";
    public static final String PROPERTYNAME_LOADTYPE = "loadType";
    private Integer switchOffTime;
    private LoadTypeEnum loadType = LoadTypeEnum.UNKNOWN;
    private transient boolean hasSwitchPortConfig;
    public static final SwitchPairPort NONE = new LabelBuilder(-1).setLabel("<none>").build();

    public SwitchPairPort() {
        this((GenericPort)null);
    }

    public SwitchPairPort(GenericPort genericPort) {
        super(genericPort);
    }

    private SwitchPairPort(Builder builder) {
        super(builder);
        this.hasSwitchPortConfig = builder.hasSwitchPortConfig;
        this.loadType = builder.loadType;
        this.switchOffTime = builder.switchOffTime;
    }

    private SwitchPairPort(LabelBuilder builder) {
        super((GenericPort)null);
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.SWITCHPAIRPORT;
    }

    @Override
    protected SwitchPortStatus internalGetStatus(GenericPort genericPort) {
        return SwitchPortStatus.valueOf(SwitchPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    @Override
    public Integer getTicks() {
        return this.getSwitchOffTime();
    }

    public Integer getSwitchOffTime() {
        if (this.genericPort != null) {
            Number switchOffTime = (Number)this.genericPort.getPortConfigValue((byte)11);
            if (switchOffTime != null) {
                this.switchOffTime = ByteUtils.getInt((byte)switchOffTime.byteValue());
            } else {
                LOGGER.warn("No value received from generic for BIDIB_PCFG_TICKS!");
            }
        }
        return this.switchOffTime;
    }

    public void setSwitchOffTime(Integer switchOffTime) {
        LOGGER.info("Set switchOff time: {}", (Object)switchOffTime);
        Integer oldValue = this.switchOffTime;
        this.switchOffTime = switchOffTime;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchOffTime)));
        }
        this.firePropertyChange(PROPERTYNAME_SWITCHOFFTIME, oldValue, this.switchOffTime);
    }

    public void setLoadType(LoadTypeEnum loadType) {
        LOGGER.info("Set load type: {}", (Object)loadType);
        LoadTypeEnum oldValue = this.loadType;
        this.loadType = loadType;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(loadType.getType())));
        }
        this.firePropertyChange(PROPERTYNAME_LOADTYPE, oldValue, this.loadType);
    }

    @Override
    public LoadTypeEnum getLoadType() {
        if (this.genericPort != null) {
            if (this.isEnabled()) {
                Number loadType = (Number)this.genericPort.getPortConfigValue(BidibLibrary.BIDIB_PCFG_LOAD_TYPE);
                if (loadType != null) {
                    try {
                        this.loadType = LoadTypeEnum.valueOf((byte)loadType.byteValue());
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Get loadType failed on port: {}, loadType: {}", (Object)this.genericPort.getPortNumber(), (Object)loadType);
                        this.loadType = LoadTypeEnum.UNKNOWN;
                    }
                } else {
                    LOGGER.warn("No value received from generic port for BIDIB_PCFG_LOAD_TYPE!");
                    this.loadType = LoadTypeEnum.UNKNOWN;
                }
            } else {
                LOGGER.debug("The current port is not enabled, return UNKNOWN.");
                this.loadType = LoadTypeEnum.UNKNOWN;
            }
        }
        return this.loadType;
    }

    @Override
    public byte[] getPortConfig() {
        return null;
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port config for the switchPair port.");
        Number switchOffTime = (Number)this.getPortConfigValue((byte)11, portConfig);
        if (switchOffTime != null) {
            this.setSwitchOffTime(ByteUtils.getInt((byte)switchOffTime.byteValue()));
            this.setHasSwitchPortConfig(true);
        } else {
            LOGGER.warn("No value received for BIDIB_PCFG_TICKS!");
        }
        Number loadType = (Number)this.getPortConfigValue(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, portConfig);
        if (loadType != null) {
            this.setLoadType(LoadTypeEnum.valueOf((byte)loadType.byteValue()));
            this.setHasSwitchPortConfig(true);
        } else {
            LOGGER.warn("No value received for BIDIB_PCFG_LOAD_TYPE!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported((byte)11)) {
            portConfigX.put((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)this.switchOffTime)));
        }
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_LOAD_TYPE)) {
            portConfigX.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.loadType.getType()))));
        }
        return portConfigX;
    }

    public boolean isHasSwitchPortConfig() {
        if (this.genericPort != null) {
            this.hasSwitchPortConfig = this.genericPort.isHasPortConfig((byte)11) || this.genericPort.isHasPortConfig(BidibLibrary.BIDIB_PCFG_LOAD_TYPE);
            LOGGER.info("The generic port has switch port config: {}", (Object)this.hasSwitchPortConfig);
        }
        return this.hasSwitchPortConfig;
    }

    public void setHasSwitchPortConfig(boolean hasSwitchPortConfig) {
        LOGGER.info("The port has switch port config available: {}, port: {}", (Object)hasSwitchPortConfig, (Object)this);
        this.hasSwitchPortConfig = hasSwitchPortConfig;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SwitchPairPort) {
            return ((SwitchPairPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SwitchPairPort clonePort(SwitchPairPort sp) {
        SwitchPairPort servoPort = (SwitchPairPort)SwitchPairPort.builder().withHasSwitchPortConfig(sp.isHasSwitchPortConfig()).withLoadType(sp.getLoadType()).withSwitchOffTime(sp.getSwitchOffTime()).withId(sp.getId()).withConfigStatus(sp.getConfigStatus()).withEnabled(sp.isEnabled()).withGenericPort(sp.getGenericPort()).withIsInactive(sp.isInactive()).withKnownPortConfigKeys(sp.getKnownPortConfigKeys()).withLabel(sp.getLabel()).withPortConfigEnabled(sp.isPortConfigEnabled()).withPortConfigErrorCode(sp.getPortConfigErrorCode()).withPortIdentifier(sp.getPortIdentifier()).withRemappingEnabled(sp.isRemappingEnabled()).withStatus((SwitchPortStatus)sp.getStatus()).build();
        return servoPort;
    }

    public static final class Builder
    extends Port.Builder<SwitchPairPort, SwitchPortStatus> {
        private boolean hasSwitchPortConfig;
        private LoadTypeEnum loadType;
        private Integer switchOffTime;

        public Builder withHasSwitchPortConfig(boolean hasSwitchPortConfig) {
            this.hasSwitchPortConfig = hasSwitchPortConfig;
            return this;
        }

        public Builder withLoadType(LoadTypeEnum loadType) {
            this.loadType = loadType;
            return this;
        }

        public Builder withSwitchOffTime(Integer switchOffTime) {
            this.switchOffTime = switchOffTime;
            return this;
        }

        @Override
        public SwitchPairPort build() {
            return new SwitchPairPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public SwitchPairPort build() {
            return new SwitchPairPort(this);
        }
    }
}

