/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.enums.SwitchPortEnum;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.LoadTypeAware;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.StatusPort;
import org.bidib.wizard.model.ports.TicksAware;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPort
extends Port<SwitchPortStatus>
implements ConfigurablePort<SwitchPortStatus>,
TicksAware,
StatusPort<SwitchPortStatus>,
LoadTypeAware {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPort.class);
    public static final String PROPERTYNAME_SWITCHOFFTIME = "switchOffTime";
    public static final String PROPERTYNAME_OUTPUTBEHAVIOUR = "outputBehaviour";
    public static final String PROPERTYNAME_LOADTYPE = "loadType";
    public static final SwitchPort NONE = new LabelBuilder(-1).setLabel("<none>").build();
    private IoBehaviourSwitchEnum outputBehaviour = IoBehaviourSwitchEnum.UNKNOWN;
    private LoadTypeEnum loadType = LoadTypeEnum.UNKNOWN;
    private Integer switchOffTime;
    private transient boolean hasSwitchPortConfig;

    public SwitchPort() {
        this((GenericPort)null);
    }

    public SwitchPort(GenericPort genericPort) {
        super(genericPort);
    }

    private SwitchPort(Builder builder) {
        super(builder);
        this.hasSwitchPortConfig = builder.hasSwitchPortConfig;
        this.loadType = builder.loadType;
        this.outputBehaviour = builder.outputBehaviour;
        this.switchOffTime = builder.switchOffTime;
    }

    private SwitchPort(LabelBuilder builder) {
        this();
        this.setId(builder.id);
        this.setLabel(builder.label);
    }

    @Override
    public LcOutputType getPortType() {
        return LcOutputType.SWITCHPORT;
    }

    @Override
    protected SwitchPortStatus internalGetStatus(GenericPort genericPort) {
        return SwitchPortStatus.valueOf(SwitchPortEnum.valueOf((byte)genericPort.getPortStatus()));
    }

    public IoBehaviourSwitchEnum getOutputBehaviour() {
        if (this.genericPort != null) {
            if (this.isEnabled()) {
                Number outputBehaviour = (Number)this.genericPort.getPortConfigValue(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL);
                if (outputBehaviour != null) {
                    try {
                        this.outputBehaviour = IoBehaviourSwitchEnum.valueOf((byte)outputBehaviour.byteValue());
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Get outputBehaviour failed on port: {}, outputBehaviour: {}", (Object)this.genericPort.getPortNumber(), (Object)outputBehaviour);
                        this.outputBehaviour = IoBehaviourSwitchEnum.UNKNOWN;
                    }
                } else {
                    LOGGER.info("No value received from generic port for BIDIB_PCFG_SWITCH_CTRL!");
                    this.outputBehaviour = IoBehaviourSwitchEnum.UNKNOWN;
                }
            } else {
                LOGGER.debug("The current port is not enabled, return UNKNOWN.");
                this.outputBehaviour = IoBehaviourSwitchEnum.UNKNOWN;
            }
        }
        return this.outputBehaviour;
    }

    public void setOutputBehaviour(IoBehaviourSwitchEnum outputBehaviour) {
        LOGGER.trace("Set outputBehaviour: {}", (Object)outputBehaviour);
        IoBehaviourSwitchEnum oldValue = this.outputBehaviour;
        this.outputBehaviour = outputBehaviour;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(outputBehaviour.getType())));
        }
        this.firePropertyChange(PROPERTYNAME_OUTPUTBEHAVIOUR, oldValue, this.outputBehaviour);
    }

    @Override
    public LoadTypeEnum getLoadType() {
        if (this.genericPort != null) {
            if (this.isEnabled()) {
                Number loadType = (Number)this.genericPort.getPortConfigValue(BidibLibrary.BIDIB_PCFG_LOAD_TYPE);
                if (loadType != null) {
                    try {
                        this.loadType = LoadTypeEnum.valueOf((byte)loadType.byteValue());
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.warn("Get loadType failed on port: {}, loadType: {}", (Object)this.genericPort.getPortNumber(), (Object)loadType);
                        this.loadType = LoadTypeEnum.UNKNOWN;
                    }
                } else {
                    LOGGER.info("No value received from generic port for BIDIB_PCFG_LOAD_TYPE!");
                    this.loadType = LoadTypeEnum.UNKNOWN;
                }
            } else {
                LOGGER.debug("The current port is not enabled, return UNKNOWN.");
                this.loadType = LoadTypeEnum.UNKNOWN;
            }
        }
        return this.loadType;
    }

    public void setLoadType(LoadTypeEnum loadType) {
        LOGGER.trace("Set load type: {}", (Object)loadType);
        LoadTypeEnum oldValue = this.loadType;
        this.loadType = loadType;
        if (this.genericPort != null) {
            this.genericPort.setPortConfigValue(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(loadType.getType())));
        }
        this.firePropertyChange(PROPERTYNAME_LOADTYPE, oldValue, this.loadType);
    }

    @Override
    public Integer getTicks() {
        return this.getSwitchOffTime();
    }

    public Integer getSwitchOffTime() {
        if (this.genericPort != null) {
            Number switchOffTime = (Number)this.genericPort.getPortConfigValue((byte)11);
            if (switchOffTime != null) {
                this.switchOffTime = ByteUtils.getInteger((byte)switchOffTime.byteValue());
            } else {
                LOGGER.debug("No value received from generic for BIDIB_PCFG_TICKS!");
            }
        }
        return this.switchOffTime;
    }

    public void setSwitchOffTime(Integer switchOffTime) {
        LOGGER.trace("Set switchOff time: {}", (Object)switchOffTime);
        Integer oldValue = this.switchOffTime;
        this.switchOffTime = switchOffTime;
        if (this.genericPort != null) {
            if (switchOffTime != null) {
                this.genericPort.setPortConfigValue((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchOffTime)));
            } else {
                this.genericPort.removePortConfigValue((byte)11);
            }
        }
        this.firePropertyChange(PROPERTYNAME_SWITCHOFFTIME, oldValue, this.switchOffTime);
    }

    @Override
    public byte[] getPortConfig() {
        return new byte[]{this.outputBehaviour.getType(), ByteUtils.getLowByte((Integer)this.switchOffTime), 0, 0};
    }

    public void setPortConfig(byte[] portConfig) {
        LOGGER.trace("Set the switch port parameters: {}", (Object)ByteUtils.bytesToHex((byte[])portConfig));
        this.setPortConfigEnabled(true);
        try {
            this.setOutputBehaviour(IoBehaviourSwitchEnum.valueOf((byte)portConfig[0]));
            this.getKnownPortConfigKeys().add(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL);
        }
        catch (Exception ex) {
            LOGGER.warn("Set the IoBehaviour failed.", (Throwable)ex);
            this.setOutputBehaviour(IoBehaviourSwitchEnum.UNKNOWN);
        }
        this.setSwitchOffTime(ByteUtils.getInt((byte)portConfig[1]));
        this.getKnownPortConfigKeys().add((byte)11);
    }

    @Override
    public void setPortConfigX(Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.trace("Set the port config for the switch port.");
        Number ioBehaviour = (Number)this.getPortConfigValue(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, portConfig);
        if (ioBehaviour != null) {
            this.setOutputBehaviour(IoBehaviourSwitchEnum.valueOf((byte)ioBehaviour.byteValue()));
            this.setHasSwitchPortConfig(true);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_SWITCH_CTRL!");
        }
        Number switchOffTime = (Number)this.getPortConfigValue((byte)11, portConfig);
        if (switchOffTime != null) {
            this.setSwitchOffTime(ByteUtils.getInt((byte)switchOffTime.byteValue()));
            this.setHasSwitchPortConfig(true);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_TICKS!");
        }
        Number loadType = (Number)this.getPortConfigValue(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, portConfig);
        if (loadType != null) {
            this.setLoadType(LoadTypeEnum.valueOf((byte)loadType.byteValue()));
            this.setHasSwitchPortConfig(true);
        } else {
            LOGGER.debug("No value received for BIDIB_PCFG_LOAD_TYPE!");
        }
        super.setPortConfigX(portConfig);
    }

    @Override
    public Map<Byte, PortConfigValue<?>> getPortConfigX() {
        if (this.genericPort != null) {
            return this.genericPort.getPortConfigX();
        }
        LinkedHashMap portConfigX = new LinkedHashMap();
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL)) {
            portConfigX.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.outputBehaviour.getType()))));
        }
        if (this.isPortConfigKeySupported((byte)11)) {
            portConfigX.put((byte)11, (PortConfigValue<?>)new BytePortConfigValue(ByteUtils.getLowByte((Integer)this.switchOffTime)));
        }
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_LOAD_TYPE)) {
            portConfigX.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, (PortConfigValue<?>)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)this.loadType.getType()))));
        }
        return portConfigX;
    }

    public boolean isHasSwitchPortConfig() {
        if (this.genericPort != null) {
            this.hasSwitchPortConfig = this.genericPort.isHasPortConfig(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL) || this.genericPort.isHasPortConfig((byte)11) || this.genericPort.isHasPortConfig(BidibLibrary.BIDIB_PCFG_LOAD_TYPE);
            LOGGER.trace("The generic port has switch port config: {}", (Object)this.hasSwitchPortConfig);
        }
        return this.hasSwitchPortConfig;
    }

    public void setHasSwitchPortConfig(boolean hasSwitchPortConfig) {
        LOGGER.trace("The port has switch port config available: {}, port: {}", (Object)hasSwitchPortConfig, (Object)this);
        this.hasSwitchPortConfig = hasSwitchPortConfig;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SwitchPort) {
            return ((SwitchPort)obj).getId() == this.getId();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getId();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SwitchPort clonePort(SwitchPort sp) {
        SwitchPort servoPort = (SwitchPort)SwitchPort.builder().withHasSwitchPortConfig(sp.isHasSwitchPortConfig()).withLoadType(sp.getLoadType()).withOutputBehaviour(sp.getOutputBehaviour()).withSwitchOffTime(sp.getSwitchOffTime()).withId(sp.getId()).withConfigStatus(sp.getConfigStatus()).withEnabled(sp.isEnabled()).withGenericPort(sp.getGenericPort()).withIsInactive(sp.isInactive()).withKnownPortConfigKeys(sp.getKnownPortConfigKeys()).withLabel(sp.getLabel()).withPortConfigEnabled(sp.isPortConfigEnabled()).withPortConfigErrorCode(sp.getPortConfigErrorCode()).withPortIdentifier(sp.getPortIdentifier()).withRemappingEnabled(sp.isRemappingEnabled()).withStatus((SwitchPortStatus)sp.getStatus()).build();
        return servoPort;
    }

    public static final class Builder
    extends Port.Builder<SwitchPort, SwitchPortStatus> {
        private boolean hasSwitchPortConfig;
        private LoadTypeEnum loadType;
        private IoBehaviourSwitchEnum outputBehaviour;
        private Integer switchOffTime;

        public Builder withHasSwitchPortConfig(boolean hasSwitchPortConfig) {
            this.hasSwitchPortConfig = hasSwitchPortConfig;
            return this;
        }

        public Builder withLoadType(LoadTypeEnum loadType) {
            this.loadType = loadType;
            return this;
        }

        public Builder withOutputBehaviour(IoBehaviourSwitchEnum outputBehaviour) {
            this.outputBehaviour = outputBehaviour;
            return this;
        }

        public Builder withSwitchOffTime(Integer switchOffTime) {
            this.switchOffTime = switchOffTime;
            return this;
        }

        @Override
        public SwitchPort build() {
            return new SwitchPort(this);
        }
    }

    public static class LabelBuilder {
        private final int id;
        private String label;

        public LabelBuilder(int id) {
            this.id = id;
        }

        public LabelBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public SwitchPort build() {
            return new SwitchPort(this);
        }
    }
}

