/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.ports.event;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.AbstractPortEvent;

public class PortConfigChangeEvent
extends AbstractPortEvent {
    private final PortTypeAware port;
    private Integer portValue;
    private final Map<Byte, PortConfigValue<?>> values = new LinkedHashMap();

    public PortConfigChangeEvent(String connectionId, long uniqueId, PortTypeAware port, Map<Byte, PortConfigValue<?>> values) {
        super(connectionId, uniqueId);
        this.port = port;
        this.values.putAll(values);
    }

    public PortConfigChangeEvent(String connectionId, long uniqueId, PortTypeAware port, Byte key, PortConfigValue<?> value) {
        super(connectionId, uniqueId);
        this.port = port;
        this.values.put(key, value);
    }

    public PortTypeAware getPort() {
        return this.port;
    }

    public Map<Byte, PortConfigValue<?>> getPortConfig() {
        return this.values;
    }

    public <T> T getPortConfigValue(Byte key) {
        PortConfigValue<?> value = this.values.get(key);
        return (T)(value != null ? value.getValue() : null);
    }

    public Integer getPortValue() {
        return this.portValue;
    }

    public void setPortValue(Integer portValue) {
        this.portValue = portValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.port);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortConfigChangeEvent other = (PortConfigChangeEvent)obj;
        if (this.port instanceof GenericPort) {
            return Objects.equals(this.port.getPortNumber(), other.port.getPortNumber());
        }
        boolean portNumberEquals = Objects.equals(this.port.getPortNumber(), other.port.getPortNumber());
        if (portNumberEquals) {
            return Objects.equals(this.port.getPortType(), other.port.getPortType());
        }
        return false;
    }
}

