/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.wizard.model.status.BidibStatus;

public enum BoosterStatus implements BidibStatus
{
    OFF(BoosterState.OFF, "off"),
    OFF_SHORT(BoosterState.OFF_SHORT, "off_short"),
    OFF_HOT(BoosterState.OFF_HOT, "off_hot"),
    OFF_NO_POWER(BoosterState.OFF_NO_POWER, "off_no_power"),
    OFF_GO_REQ(BoosterState.OFF_GO_REQ, "off_go_req"),
    OFF_HERE(BoosterState.OFF_HERE, "off_here"),
    OFF_NO_DCC(BoosterState.OFF_NO_DCC, "off_no_dcc"),
    ON(BoosterState.ON, "on"),
    ON_LIMIT(BoosterState.ON_LIMIT, "on_limit"),
    ON_HOT(BoosterState.ON_HOT, "on_hot"),
    ON_STOP_REQ(BoosterState.ON_STOP_REQ, "on_stop_req"),
    ON_HERE(BoosterState.ON_HERE, "on_here");

    private final BoosterState boosterState;
    private final String key;

    private BoosterStatus(BoosterState boosterState, String key) {
        this.boosterState = boosterState;
        this.key = key;
    }

    public BoosterState getBoosterState() {
        return this.boosterState;
    }

    public BoosterState getType() {
        return this.boosterState;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static boolean isOffState(BoosterStatus boosterState) {
        return BoosterStatus.isOffState(boosterState.getBoosterState());
    }

    public static boolean isOffState(BoosterState boosterState) {
        return (boosterState.getType() & 0x80) == 0;
    }

    public static BoosterStatus valueOf(BoosterState boosterState) {
        BoosterStatus result = null;
        for (BoosterStatus e : BoosterStatus.values()) {
            if (e.boosterState != boosterState) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + boosterState + " to a booster status");
        }
        return result;
    }

    public static BoosterStatus fromString(String boosterState) {
        BoosterStatus result = null;
        for (BoosterStatus e : BoosterStatus.values()) {
            if (!e.key.equalsIgnoreCase(boosterState)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + boosterState + " to a booster status");
        }
        return result;
    }

    public BoosterStatus[] getValues() {
        return new BoosterStatus[]{OFF, OFF_SHORT, OFF_HOT, OFF_NO_POWER, OFF_GO_REQ, OFF_HERE, OFF_NO_DCC, ON, ON_LIMIT, ON_HOT, ON_STOP_REQ, ON_HERE};
    }
}

