/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.model.status;

import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.wizard.model.status.BidibStatus;

public enum CommandStationStatus implements BidibStatus
{
    OFF(CommandStationState.OFF, "off"),
    STOP(CommandStationState.STOP, "stop"),
    SOFTSTOP(CommandStationState.SOFTSTOP, "softstop"),
    GO(CommandStationState.GO, "go"),
    PROG(CommandStationState.PROG, "prog"),
    PROGBUSY(CommandStationState.PROGBUSY, "progbusy"),
    BUSY(CommandStationState.BUSY, "busy"),
    QUERY(CommandStationState.QUERY, "query"),
    GO_IGN_WD(CommandStationState.GO_IGN_WD, "go-ign-wd");

    private final CommandStationState commandStationState;
    private final String key;

    private CommandStationStatus(CommandStationState commandStationState, String key) {
        this.commandStationState = commandStationState;
        this.key = key;
    }

    public CommandStationState getCommandStationState() {
        return this.commandStationState;
    }

    public CommandStationState getType() {
        return this.commandStationState;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public static CommandStationStatus valueOf(CommandStationState commandStationState) {
        CommandStationStatus result = null;
        for (CommandStationStatus e : CommandStationStatus.values()) {
            if (e.commandStationState != commandStationState) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + commandStationState + " to a command station status");
        }
        return result;
    }

    public static CommandStationStatus fromString(String commandStationState) {
        CommandStationStatus result = null;
        for (CommandStationStatus e : CommandStationStatus.values()) {
            if (!e.key.equalsIgnoreCase(commandStationState)) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + commandStationState + " to a command station status");
        }
        return result;
    }

    public CommandStationStatus[] getValues() {
        return new CommandStationStatus[]{OFF, STOP, SOFTSTOP, GO, PROG, PROGBUSY, BUSY, QUERY, GO_IGN_WD};
    }

    public static boolean isOnState(CommandStationStatus commandStationState) {
        return !CommandStationStatus.isPtProgState(commandStationState) && !CommandStationStatus.isOffState(commandStationState);
    }

    public static boolean isOffState(CommandStationStatus commandStationState) {
        if (commandStationState == null) {
            return true;
        }
        boolean isOffState = false;
        switch (commandStationState) {
            case OFF: 
            case STOP: 
            case SOFTSTOP: {
                isOffState = true;
                break;
            }
        }
        return isOffState;
    }

    public static boolean isPtProgState(CommandStationStatus commandStationState) {
        boolean isPtProgState = false;
        switch (commandStationState) {
            case PROG: 
            case PROGBUSY: {
                isPtProgState = true;
                break;
            }
        }
        return isPtProgState;
    }
}

